/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStreamSource
implements InputStreamSource {
    private final File mFile;
    private boolean mIsCancelled = false;
    private boolean mDeleteOnCancel = false;

    public FileInputStreamSource(File file2) {
        this.mFile = file2;
    }

    public FileInputStreamSource(File file2, boolean deleteFileOnCancel) {
        this.mFile = file2;
        this.mDeleteOnCancel = deleteFileOnCancel;
    }

    @Override
    public synchronized InputStream createInputStream() {
        if (this.mIsCancelled) {
            return null;
        }
        try {
            return new FileInputStream(this.mFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public synchronized void close() {
        this.mIsCancelled = true;
        if (this.mDeleteOnCancel) {
            this.cleanFile();
        }
    }

    @Override
    public long size() {
        return this.mFile.length();
    }

    public void cleanFile() {
        FileUtil.deleteFile(this.mFile);
    }

    public File getFile() {
        return this.mFile;
    }
}

