/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.result.RetentionFileSaver;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

@OptionClass(alias="file-system-log-saver")
public class FileSystemLogSaver
implements ILogSaver {
    @Option(name="log-file-path", description="root file system path to store log files.")
    private File mRootReportDir = new File(System.getProperty("java.io.tmpdir"));
    @Option(name="log-file-url", description="root http url of log files. Assumes files placed in log-file-path are visible via this url.")
    private String mReportUrl = null;
    @Option(name="log-retention-days", description="the number of days to keep saved log files.")
    private Integer mLogRetentionDays = null;
    @Option(name="compress-files", description="whether to compress files which are not already compressed")
    private boolean mCompressFiles = true;
    private File mLogReportDir = null;
    private LogFileSaver mFileSaver = null;
    private int mShardingLock = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationStarted(IInvocationContext context) {
        IBuildInfo info = context.getBuildInfos().get(0);
        FileSystemLogSaver fileSystemLogSaver = this;
        synchronized (fileSystemLogSaver) {
            if (this.mShardingLock == 0) {
                this.mLogReportDir = this.createLogReportDir(info, this.mRootReportDir, this.mLogRetentionDays);
                this.mFileSaver = new LogFileSaver(this.mLogReportDir);
            }
            ++this.mShardingLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invocationEnded(long elapsedTime) {
        FileSystemLogSaver fileSystemLogSaver = this;
        synchronized (fileSystemLogSaver) {
            --this.mShardingLock;
            if (this.mShardingLock < 0) {
                LogUtil.CLog.w("Sharding lock exited more times than entered, possible unbalanced invocationStarted/Ended calls");
            }
        }
    }

    @Override
    public LogFile saveLogData(String dataName, LogDataType dataType, InputStream dataStream) throws IOException {
        if (!this.mCompressFiles) {
            File log = this.mFileSaver.saveLogData(dataName, dataType, dataStream);
            return new LogFile(log.getAbsolutePath(), this.getUrl(log), dataType);
        }
        File log = this.mFileSaver.saveAndGZipLogData(dataName, dataType, dataStream);
        return new LogFile(log.getAbsolutePath(), this.getUrl(log), true, dataType, log.length());
    }

    @Override
    public LogFile saveLogFile(String dataName, LogDataType dataType, File fileToLog) throws IOException {
        if (!this.mCompressFiles) {
            File log = this.mFileSaver.saveLogFile(dataName, dataType, fileToLog);
            return new LogFile(log.getAbsolutePath(), this.getUrl(log), dataType);
        }
        File log = this.mFileSaver.saveAndGZipLogFile(dataName, dataType, fileToLog);
        return new LogFile(log.getAbsolutePath(), this.getUrl(log), true, dataType, log.length());
    }

    @Override
    public LogFile getLogReportDir() {
        return new LogFile(this.mLogReportDir.getAbsolutePath(), this.getUrl(this.mLogReportDir), LogDataType.DIR);
    }

    private File createLogReportDir(IBuildInfo buildInfo, File reportDir, Integer logRetentionDays) {
        File logReportDir;
        try {
            logReportDir = this.generateLogReportDir(buildInfo, reportDir);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Unable to create unique directory in %s. Attempting to use tmp dir instead", reportDir.getAbsolutePath());
            LogUtil.CLog.e(e);
            logReportDir = this.createTempDir();
        }
        boolean setPerms = FileUtil.chmodGroupRWX(logReportDir);
        if (!setPerms) {
            LogUtil.CLog.w(String.format("Failed to set dir %s to be group accessible.", logReportDir));
        }
        if (logRetentionDays != null && logRetentionDays > 0) {
            new RetentionFileSaver().writeRetentionFile(logReportDir, logRetentionDays);
        }
        LogUtil.CLog.d("Using log file directory %s", logReportDir.getAbsolutePath());
        return logReportDir;
    }

    protected File generateLogReportDir(IBuildInfo buildInfo, File reportDir) throws IOException {
        File buildDir = this.createBuildDir(buildInfo, reportDir);
        return FileUtil.createTempDir("inv_", buildDir);
    }

    private File createBuildDir(IBuildInfo buildInfo, File reportDir) throws IOException {
        ArrayList<String> pathSegments = new ArrayList<String>();
        if (buildInfo.getBuildBranch() != null) {
            pathSegments.add(buildInfo.getBuildBranch());
        }
        pathSegments.add(buildInfo.getBuildId());
        pathSegments.add(buildInfo.getTestTag());
        File buildReportDir = FileUtil.getFileForPath(reportDir, pathSegments.toArray(new String[0]));
        if (buildReportDir.exists()) {
            if (buildReportDir.isDirectory()) {
                return buildReportDir;
            }
            String msg = String.format("Cannot create build-specific output dir %s. File already exists.", buildReportDir.getAbsolutePath());
            LogUtil.CLog.w(msg);
            throw new IOException(msg);
        }
        if (FileUtil.mkdirsRWX(buildReportDir)) {
            return buildReportDir;
        }
        String msg = String.format("Cannot create build-specific output dir %s. Failed to create directory.", buildReportDir.getAbsolutePath());
        LogUtil.CLog.w(msg);
        throw new IOException(msg);
    }

    private File createTempDir() {
        try {
            return FileUtil.createTempDir("inv_");
        }
        catch (IOException e) {
            throw new FatalHostError("Cannot create tmp directory.", e, InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
        }
    }

    private String getUrl(File file2) {
        if (this.mReportUrl == null) {
            return null;
        }
        String filePath = file2.getAbsolutePath();
        String reportPath = this.mRootReportDir.getAbsolutePath();
        if (reportPath.endsWith(File.separator)) {
            LogUtil.CLog.w("Cannot create URL. getAbsolutePath() returned %s which ends with %s", reportPath, File.separator);
            return null;
        }
        if (filePath.startsWith(reportPath)) {
            String relativePath = filePath.substring(reportPath.length());
            String url = this.mReportUrl;
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            return String.format("%s%s", url, relativePath.replace(File.separator, "/"));
        }
        return null;
    }

    void setReportDir(File reportDir) {
        this.mRootReportDir = reportDir;
    }

    void setLogRetentionDays(int logRetentionDays) {
        this.mLogRetentionDays = logRetentionDays;
    }

    public void setCompressFiles(boolean compress) {
        this.mCompressFiles = compress;
    }
}

