/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestDescription;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FilteredResultForwarder
extends ResultForwarder {
    private final Collection<TestDescription> mAllowedTests;

    public FilteredResultForwarder(Collection<TestDescription> allowedTests, ITestInvocationListener ... listeners) {
        super(listeners);
        this.mAllowedTests = allowedTests;
    }

    @Override
    public void testStarted(TestDescription test) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testStarted(test);
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testStarted(test, startTime);
    }

    @Override
    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testEnded(test, testMetrics);
    }

    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testEnded(test, endTime, testMetrics);
    }

    @Override
    public void testEnded(TestDescription test, long endTime, Map<String, String> testMetrics) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testEnded(test, endTime, testMetrics);
    }

    @Override
    public void testEnded(TestDescription test, Map<String, String> testMetrics) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testEnded(test, testMetrics);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, String trace) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testAssumptionFailure(test, trace);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testAssumptionFailure(test, failure);
    }

    @Override
    public void testIgnored(TestDescription test) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testIgnored(test);
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testFailed(test, failure);
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        if (!this.mAllowedTests.contains(test)) {
            return;
        }
        super.testFailed(test, trace);
    }
}

