/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.util.HashMap;
import java.util.Map;

public interface ITestLifeCycleReceiver {
    default public void testRunStarted(String runName, int testCount) {
    }

    default public void testRunStarted(String runName, int testCount, int attemptNumber) {
        this.testRunStarted(runName, testCount);
    }

    default public void testRunStarted(String runName, int testCount, int attemptNumber, long startTime) {
        this.testRunStarted(runName, testCount);
    }

    default public void testRunFailed(String errorMessage) {
    }

    default public void testRunFailed(FailureDescription failure) {
        this.testRunFailed(failure.toString());
    }

    default public void testRunEnded(long elapsedTimeMillis, Map<String, String> runMetrics) {
        this.testRunEnded(elapsedTimeMillis, TfMetricProtoUtil.upgradeConvert(runMetrics));
    }

    default public void testRunEnded(long elapsedTimeMillis, HashMap<String, MetricMeasurement.Metric> runMetrics) {
    }

    default public void testRunStopped(long elapsedTime) {
    }

    default public void testStarted(TestDescription test) {
    }

    default public void testStarted(TestDescription test, long startTime) {
        this.testStarted(test);
    }

    default public void testFailed(TestDescription test, String trace) {
    }

    default public void testFailed(TestDescription test, FailureDescription failure) {
        this.testFailed(test, failure.toString());
    }

    default public void testAssumptionFailure(TestDescription test, String trace) {
    }

    default public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        this.testAssumptionFailure(test, failure.toString());
    }

    default public void testIgnored(TestDescription test) {
    }

    default public void testEnded(TestDescription test, Map<String, String> testMetrics) {
        this.testEnded(test, TfMetricProtoUtil.upgradeConvert(testMetrics));
    }

    default public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
    }

    default public void testEnded(TestDescription test, long endTime, Map<String, String> testMetrics) {
        this.testEnded(test, endTime, TfMetricProtoUtil.upgradeConvert(testMetrics));
    }

    default public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.testEnded(test, testMetrics);
    }
}

