/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.TestSummary;
import java.util.ArrayList;
import java.util.List;

public class InvocationSummaryHelper {
    private InvocationSummaryHelper() {
    }

    public static void reportInvocationStarted(List<ITestInvocationListener> listeners, IInvocationContext context) {
        ArrayList<TestSummary> summaries = new ArrayList<TestSummary>(listeners.size());
        for (ITestInvocationListener listener : listeners) {
            String log = "putEarlySummary";
            try {
                if (listener instanceof ITestSummaryListener) {
                    ((ITestSummaryListener)listener).putEarlySummary(summaries);
                }
                log = "invocationStarted";
                listener.invocationStarted(context);
                log = "getSummary";
                TestSummary summary = listener.getSummary();
                if (summary == null) continue;
                summary.setSource(listener.getClass().getName());
                summaries.add(summary);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("RuntimeException while invoking %s on %s", log, listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    public static void reportInvocationEnded(List<ITestInvocationListener> listeners, long elapsedTime) {
        ArrayList<TestSummary> summaries = new ArrayList<TestSummary>(listeners.size());
        for (ITestInvocationListener listener : listeners) {
            if (listener instanceof ITestSummaryListener) continue;
            try {
                listener.invocationEnded(elapsedTime);
                TestSummary summary = listener.getSummary();
                if (summary == null) continue;
                summary.setSource(listener.getClass().getName());
                summaries.add(summary);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("RuntimeException while invoking invocationEnded on %s", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
        for (ITestInvocationListener listener : listeners) {
            if (!(listener instanceof ITestSummaryListener)) continue;
            try {
                ((ITestSummaryListener)listener).putSummary(summaries);
                listener.invocationEnded(elapsedTime);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("RuntimeException while invoking invocationEnded on %s", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }
}

