/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.util.TimeUtil;
import java.util.HashMap;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.junit.AssumptionViolatedException;

public class InvocationToJUnitResultForwarder
implements ITestInvocationListener {
    private TestListener mJUnitListener;

    public InvocationToJUnitResultForwarder(TestListener junitListener) {
        this.mJUnitListener = junitListener;
    }

    protected TestListener getJUnitListener() {
        return this.mJUnitListener;
    }

    @Override
    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.mJUnitListener.endTest(new TestIdentifierResult(test));
    }

    @Override
    public void testFailed(TestDescription testId, String trace) {
        TestIdentifierResult test = new TestIdentifierResult(testId);
        this.mJUnitListener.addFailure(test, new AssertionFailedError(trace));
        LogUtil.CLog.w("\nTest %s failed with stack:\n %s", testId.toString(), trace);
    }

    @Override
    public void testAssumptionFailure(TestDescription testId, String trace) {
        TestIdentifierResult test = new TestIdentifierResult(testId);
        AssumptionViolatedException throwable = new AssumptionViolatedException(trace);
        this.mJUnitListener.addError(test, throwable);
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        LogUtil.CLog.i("Run ended in %s", TimeUtil.formatElapsedTime(elapsedTime));
    }

    @Override
    public void testRunFailed(String errorMessage) {
        LogUtil.CLog.e("Run failed: %s", errorMessage);
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        LogUtil.CLog.i("Running %s: %d tests", runName, testCount);
    }

    @Override
    public void testRunStopped(long elapsedTime) {
        LogUtil.CLog.i("run stopped after %s", TimeUtil.formatElapsedTime(elapsedTime));
    }

    @Override
    public void testStarted(TestDescription test) {
        LogUtil.CLog.d("Starting test: %s", test.toString());
        this.mJUnitListener.startTest(new TestIdentifierResult(test));
    }

    @Override
    public void invocationEnded(long elapsedTime) {
    }

    @Override
    public void invocationFailed(Throwable cause) {
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
    }

    @Override
    public void testLog(String dataName, LogDataType logData, InputStreamSource dataStream) {
    }

    @Override
    public void testIgnored(TestDescription test) {
    }

    static class TestIdentifierResult
    implements Test {
        private final TestDescription mTestId;

        private TestIdentifierResult(TestDescription testId) {
            this.mTestId = testId;
        }

        @Override
        public int countTestCases() {
            return 1;
        }

        @Override
        public void run(TestResult result) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object other) {
            return this.mTestId.equals(other);
        }

        public int hashCode() {
            return this.mTestId.hashCode();
        }

        public String toString() {
            return this.mTestId.toString();
        }
    }
}

