/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;

public class JUnitToInvocationResultForwarder
implements TestListener {
    private final List<ITestInvocationListener> mInvocationListeners;
    private CloseableTraceScope mMethodTrace = null;

    public JUnitToInvocationResultForwarder(ITestInvocationListener invocationListener) {
        this.mInvocationListeners = new ArrayList<ITestInvocationListener>(1);
        this.mInvocationListeners.add(invocationListener);
    }

    public JUnitToInvocationResultForwarder(List<ITestInvocationListener> invocationListeners) {
        this.mInvocationListeners = new ArrayList<ITestInvocationListener>(invocationListeners.size());
        this.mInvocationListeners.addAll(invocationListeners);
    }

    @Override
    public void addError(Test test, Throwable t) {
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testFailed(this.getTestId(test), this.getStackTrace(t));
        }
    }

    @Override
    public void addFailure(Test test, AssertionFailedError t) {
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testFailed(this.getTestId(test), this.getStackTrace((Throwable)((Object)t)));
        }
    }

    @Override
    public void endTest(Test test) {
        HashMap<String, MetricMeasurement.Metric> emptyMap = new HashMap<String, MetricMeasurement.Metric>();
        this.endTest(test, emptyMap);
    }

    public void endTest(Test test, HashMap<String, MetricMeasurement.Metric> metrics) {
        TestDescription description = this.getTestId(test);
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testEnded(description, metrics);
        }
        if (this.mMethodTrace != null) {
            this.mMethodTrace.close();
            this.mMethodTrace = null;
        }
    }

    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testLog(dataName, dataType, dataStream);
        }
    }

    @Override
    public void startTest(Test test) {
        TestDescription description = this.getTestId(test);
        this.mMethodTrace = new CloseableTraceScope(description.getTestName());
        for (ITestInvocationListener listener : this.mInvocationListeners) {
            listener.testStarted(description);
        }
    }

    private TestDescription getTestId(Test test) {
        String className = test.getClass().getName();
        String testName = "";
        if (test instanceof TestCase) {
            testName = ((TestCase)test).getName();
        }
        Annotation[] annotations = new Annotation[]{};
        try {
            Method testMethod = test.getClass().getMethod(testName, new Class[0]);
            annotations = testMethod.getAnnotations();
        }
        catch (NoSuchMethodException | SecurityException e) {
            LogUtil.CLog.e("Ignoring this exception:");
            LogUtil.CLog.e(e);
        }
        return new TestDescription(className, testName, annotations);
    }

    private String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream bytePrintStream = new PrintStream(outputStream);
        throwable.printStackTrace(bytePrintStream);
        return outputStream.toString();
    }
}

