/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.build.DeviceBuildDescriptor;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.net.HttpHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="json-reporter")
public class JsonHttpTestResultReporter
extends CollectingTestListener {
    private static final String SEPARATOR = "#";
    private static final String RESULT_SEPARATOR = "##";
    private static final String KEY_METRICS = "metrics";
    private static final String KEY_BRANCH = "branch";
    private static final String KEY_BUILD_FLAVOR = "build_flavor";
    private static final String KEY_BUILD_ID = "build_id";
    private static final String KEY_RESULTS_NAME = "results_name";
    private static final String KEY_DEVICE_NAME = "device_name";
    private static final String KEY_SDK_RELEASE_NAME = "sdk_release_name";
    private static final String DEVICE_NAME_PROPERTY = "ro.product.device";
    private static final String SDK_VERSION_PROPERTY = "ro.build.version.sdk";
    private static final String BUILD_ID_PROPERTY = "ro.build.id";
    private static final String SDK_BUILDID_FORMAT = "API_%s_%c";
    private static final int CONNECTION_TIMEOUT_MS = 60000;
    @Option(name="include-run-name", description="include test run name in reporting unit")
    private boolean mIncludeRunName = false;
    @Option(name="posting-endpoint", description="url for the HTTP data posting endpoint", importance=Option.Importance.ALWAYS)
    private String mPostingEndpoint;
    @Option(name="reporting-unit-key-suffix", description="suffix to append after the regular reporting unit key")
    private String mReportingUnitKeySuffix = null;
    @Option(name="skip-failed-runs", description="flag to skip reporting results from failed runs")
    private boolean mSkipFailedRuns = false;
    @Option(name="include-device-details", description="Enabling this flag will parse additional device details such as device name, sdk version and build id.")
    private boolean mDeviceDetails = false;
    @Option(name="additional-key-value-pairs", description="Map of additional key/value pairs to be added to the results.")
    private Map<String, String> mAdditionalKeyValuePairs = new LinkedHashMap<String, String>();
    private boolean mHasInvocationFailures = false;
    private IInvocationContext mInvocationContext = null;
    private String mDeviceName = null;
    private String mSdkBuildId = null;

    @Override
    public void invocationStarted(IInvocationContext context) {
        super.invocationStarted(context);
        this.mInvocationContext = context;
    }

    @Override
    public void invocationFailed(Throwable cause) {
        super.invocationFailed(cause);
        this.mHasInvocationFailures = true;
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        if (this.mHasInvocationFailures) {
            LogUtil.CLog.d("Skipping reporting beacuse there are invocation failures.");
        } else {
            try {
                if (this.mDeviceDetails) {
                    this.parseAdditionalDeviceDetails(this.getDevice(this.mInvocationContext));
                }
                this.postResults(this.convertMetricsToJson(this.getMergedTestRunResults()));
            }
            catch (JSONException e) {
                LogUtil.CLog.e("JSONException while converting test metrics.");
                LogUtil.CLog.e(e);
            }
        }
    }

    protected ITestDevice getDevice(IInvocationContext context) {
        return context.getDevices().get(0);
    }

    protected void parseAdditionalDeviceDetails(ITestDevice testDevice) {
        try {
            this.mDeviceName = testDevice.getProperty(DEVICE_NAME_PROPERTY);
            this.mSdkBuildId = String.format(SDK_BUILDID_FORMAT, testDevice.getProperty(SDK_VERSION_PROPERTY), Character.valueOf(testDevice.getProperty(BUILD_ID_PROPERTY).charAt(0)));
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("Error in parsing additional additional device info.");
            LogUtil.CLog.e(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postResults(JSONObject postData) {
        HttpHelper helper = new HttpHelper();
        OutputStream outputStream = null;
        String data = postData.toString();
        LogUtil.CLog.d("Attempting to post %s: Data: '%s'", this.mPostingEndpoint, data);
        try {
            HttpURLConnection conn = helper.createJsonConnection(new URL(this.mPostingEndpoint), "POST");
            conn.setConnectTimeout(60000);
            conn.setReadTimeout(60000);
            outputStream = conn.getOutputStream();
            outputStream.write(data.getBytes());
            String response = StreamUtil.getStringFromStream(conn.getInputStream()).trim();
            int responseCode = conn.getResponseCode();
            if (responseCode < 200 || responseCode >= 300) {
                LogUtil.CLog.e("Posting failure. code: %d, response: %s", responseCode, response);
            } else {
                LogUtil.CLog.d("Successfully posted results, raw data: %s", postData);
            }
            StreamUtil.close(outputStream);
        }
        catch (IOException e) {
            LogUtil.CLog.e("IOException occurred while reporting to HTTP endpoint: %s", this.mPostingEndpoint);
            LogUtil.CLog.e(e);
        }
        finally {
            StreamUtil.close(outputStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    JSONObject convertMetricsToJson(Collection<TestRunResult> runResults) throws JSONException {
        void var8_11;
        JSONObject allTestMetrics = new JSONObject();
        StringBuffer resultsName = new StringBuffer();
        for (TestRunResult runResult : runResults) {
            if (this.mSkipFailedRuns && runResult.isRunFailure()) continue;
            if (runResult.getRunMetrics().size() > 0) {
                JSONObject runResultMetrics = new JSONObject(this.getValidMetrics(runResult.getRunMetrics()));
                Object reportingUnit = runResult.getName();
                if (this.mReportingUnitKeySuffix != null && !this.mReportingUnitKeySuffix.isEmpty()) {
                    reportingUnit = (String)reportingUnit + this.mReportingUnitKeySuffix;
                }
                allTestMetrics.put((String)reportingUnit, runResultMetrics);
                resultsName.append(String.format("%s%s", reportingUnit, RESULT_SEPARATOR));
            }
            Map<TestDescription, TestResult> testResultMap = runResult.getTestResults();
            for (Map.Entry entry : testResultMap.entrySet()) {
                TestDescription testDescription = (TestDescription)entry.getKey();
                TestResult testResult = (TestResult)entry.getValue();
                List<String> reportingUnitParts = Arrays.asList(testDescription.getClassName(), testDescription.getTestName());
                if (this.mIncludeRunName) {
                    reportingUnitParts.add(0, runResult.getName());
                }
                String reportingUnit = String.join((CharSequence)SEPARATOR, reportingUnitParts);
                if (this.mReportingUnitKeySuffix != null && !this.mReportingUnitKeySuffix.isEmpty()) {
                    reportingUnit = reportingUnit + this.mReportingUnitKeySuffix;
                }
                resultsName.append(String.format("%s%s", reportingUnit, RESULT_SEPARATOR));
                if (testResult.getMetrics().size() <= 0) continue;
                JSONObject testResultMetrics = new JSONObject(this.getValidMetrics(testResult.getMetrics()));
                allTestMetrics.put(reportingUnit, testResultMetrics);
            }
        }
        List<IBuildInfo> buildInfos = this.mInvocationContext.getBuildInfos();
        if (buildInfos.isEmpty()) {
            throw new IllegalArgumentException("There is no build info");
        }
        IBuildInfo buildInfo = buildInfos.get(0);
        String buildBranch = buildInfo.getBuildBranch();
        String buildFlavor = buildInfo.getBuildFlavor();
        String string = buildInfo.getBuildId();
        if (DeviceBuildDescriptor.describesDeviceBuild(buildInfo)) {
            DeviceBuildDescriptor deviceBuild = new DeviceBuildDescriptor(buildInfo);
            buildBranch = deviceBuild.getDeviceBuildBranch();
            buildFlavor = deviceBuild.getDeviceBuildFlavor();
            String string2 = deviceBuild.getDeviceBuildId();
        }
        JSONObject result = new JSONObject();
        result.put(KEY_RESULTS_NAME, resultsName);
        result.put(KEY_METRICS, allTestMetrics);
        result.put(KEY_BRANCH, buildBranch);
        result.put(KEY_BUILD_FLAVOR, buildFlavor);
        result.put(KEY_BUILD_ID, var8_11);
        if (this.mDeviceDetails) {
            result.put(KEY_DEVICE_NAME, this.mDeviceName);
            result.put(KEY_SDK_RELEASE_NAME, this.mSdkBuildId);
        }
        if (!this.mAdditionalKeyValuePairs.isEmpty()) {
            for (Map.Entry<String, String> pair : this.mAdditionalKeyValuePairs.entrySet()) {
                result.put(pair.getKey(), pair.getValue());
            }
        }
        return result;
    }

    public Map<String, String> getValidMetrics(Map<String, String> collectedMetrics) {
        HashMap<String, String> validMetrics = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : collectedMetrics.entrySet()) {
            try {
                Double.parseDouble(entry.getValue());
                validMetrics.put(entry.getKey(), entry.getValue());
            }
            catch (Exception exception) {}
        }
        return validMetrics;
    }
}

