/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.SubprocessResultsReporter;
import com.android.tradefed.util.SubprocessEventHelper;
import java.util.Map;
import org.json.JSONObject;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class LegacySubprocessResultsReporter
extends SubprocessResultsReporter {
    private static SignalHandler handler = new SignalHandler(){

        @Override
        public void handle(Signal sig) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.ERROR, String.format("Received signal %s. Shutting down...", sig.getName()));
            GlobalConfiguration.getInstance().getCommandScheduler().shutdownHard();
        }
    };

    public LegacySubprocessResultsReporter() {
        this(true);
    }

    protected LegacySubprocessResultsReporter(boolean installHandler) {
        if (installHandler) {
            Signal.handle(new Signal("TERM"), handler);
        }
    }

    public void testAssumptionFailure(TestIdentifier testId, String trace) {
        SubprocessEventHelper.FailedTestEventInfo info = new SubprocessEventHelper.FailedTestEventInfo(testId.getClassName(), testId.getTestName(), trace);
        this.printEvent("TEST_ASSUMPTION_FAILURE", info);
    }

    public void testEnded(TestIdentifier testId, Map<String, String> metrics) {
        this.testEnded(testId, System.currentTimeMillis(), metrics);
    }

    public void testEnded(TestIdentifier testId, long endTime, Map<String, String> metrics) {
        SubprocessEventHelper.TestEndedEventInfo info = new SubprocessEventHelper.TestEndedEventInfo(testId.getClassName(), testId.getTestName(), endTime, metrics);
        this.printEvent("TEST_ENDED", info);
    }

    public void testFailed(TestIdentifier testId, String reason) {
        SubprocessEventHelper.FailedTestEventInfo info = new SubprocessEventHelper.FailedTestEventInfo(testId.getClassName(), testId.getTestName(), reason);
        this.printEvent("TEST_FAILED", info);
    }

    public void testIgnored(TestIdentifier testId) {
        SubprocessEventHelper.BaseTestEventInfo info = new SubprocessEventHelper.BaseTestEventInfo(testId.getClassName(), testId.getTestName());
        this.printEvent("TEST_IGNORED", info);
    }

    public void testStarted(TestIdentifier testId) {
        this.testStarted(testId, System.currentTimeMillis());
    }

    public void testStarted(TestIdentifier testId, long startTime) {
        SubprocessEventHelper.TestStartedEventInfo info = new SubprocessEventHelper.TestStartedEventInfo(testId.getClassName(), testId.getTestName(), startTime);
        this.printEvent("TEST_STARTED", info);
    }

    public void invocationStarted(IBuildInfo buildInfo) {
        SubprocessEventHelper.InvocationStartedEventInfo info = new SubprocessEventHelper.InvocationStartedEventInfo(buildInfo.getTestTag(), System.currentTimeMillis());
        this.printEvent("INVOCATION_STARTED", info);
    }

    @Override
    public void invocationFailed(Throwable cause) {
        SubprocessEventHelper.InvocationFailedEventInfo info = new SubprocessEventHelper.InvocationFailedEventInfo(cause);
        this.printEvent("INVOCATION_FAILED", info);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
    }

    @Override
    public void testRunFailed(String reason) {
        SubprocessEventHelper.TestRunFailedEventInfo info = new SubprocessEventHelper.TestRunFailedEventInfo(reason);
        this.printEvent("TEST_RUN_FAILED", info);
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        SubprocessEventHelper.TestRunStartedEventInfo info = new SubprocessEventHelper.TestRunStartedEventInfo(runName, testCount);
        this.printEvent("TEST_RUN_STARTED", info);
    }

    @Override
    public void testRunEnded(long time, Map<String, String> runMetrics) {
        SubprocessEventHelper.TestRunEndedEventInfo info = new SubprocessEventHelper.TestRunEndedEventInfo(time, runMetrics);
        this.printEvent("TEST_RUN_ENDED", info);
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        SubprocessEventHelper.TestModuleStartedEventInfo info = new SubprocessEventHelper.TestModuleStartedEventInfo(moduleContext);
        this.printEvent("TEST_MODULE_STARTED", info);
    }

    @Override
    public void testModuleEnded() {
        this.printEvent("TEST_MODULE_ENDED", new JSONObject());
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        SubprocessEventHelper.LogAssociationEventInfo info = new SubprocessEventHelper.LogAssociationEventInfo(dataName, logFile);
        this.printEvent("LOG_ASSOCIATION", info);
    }

    @Override
    public void setLogSaver(ILogSaver logSaver) {
    }
}

