/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.command.FatalHostError;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.RetentionFileSaver;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class LogFileSaver {
    private static final int BUFFER_SIZE = 65536;
    private File mInvLogDir;
    private List<String> mInvLogPathSegments;

    public LogFileSaver(IBuildInfo buildInfo, File rootDir, Integer logRetentionDays) {
        List<String> testArtifactPathSegments = this.generateTestArtifactPath(buildInfo);
        File buildDir = this.createBuildDir(testArtifactPathSegments, rootDir);
        this.mInvLogDir = this.createInvLogDir(buildDir, logRetentionDays);
        String invLogDirName = this.mInvLogDir.getName();
        this.mInvLogPathSegments = new ArrayList<String>(testArtifactPathSegments);
        this.mInvLogPathSegments.add(invLogDirName);
    }

    public LogFileSaver(IBuildInfo buildInfo, File rootDir) {
        this(buildInfo, rootDir, null);
    }

    public LogFileSaver(File rootDir) {
        this(null, rootDir, null);
    }

    private File createTempDir() {
        try {
            return FileUtil.createTempDir("inv_");
        }
        catch (IOException e) {
            throw new FatalHostError("Cannot create tmp directory.", e, InfraErrorIdentifier.LAB_HOST_FILESYSTEM_ERROR);
        }
    }

    public File getFileDir() {
        return this.mInvLogDir;
    }

    File createInvLogDir(File buildDir, Integer logRetentionDays) {
        File invocationDir = null;
        try {
            invocationDir = FileUtil.createTempDir("inv_", buildDir);
            if (logRetentionDays != null && logRetentionDays > 0) {
                new RetentionFileSaver().writeRetentionFile(invocationDir, logRetentionDays);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Unable to create unique directory in %s. Attempting to use tmp dir instead", buildDir.getAbsolutePath());
            LogUtil.CLog.e(e);
            invocationDir = this.createTempDir();
        }
        LogUtil.CLog.i("Using log file directory %s", invocationDir.getAbsolutePath());
        return invocationDir;
    }

    File createBuildDir(List<String> buildPathSegments, File rootDir) {
        File buildReportDir = FileUtil.getFileForPath(rootDir, buildPathSegments.toArray(new String[0]));
        if (buildReportDir.exists()) {
            if (buildReportDir.isDirectory()) {
                return buildReportDir;
            }
            LogUtil.CLog.w("Cannot create build-specific output dir %s. File already exists.", buildReportDir.getAbsolutePath());
        } else {
            if (FileUtil.mkdirsRWX(buildReportDir)) {
                return buildReportDir;
            }
            LogUtil.CLog.w("Cannot create build-specific output dir %s. Failed to create directory.", buildReportDir.getAbsolutePath());
        }
        return buildReportDir;
    }

    List<String> generateTestArtifactPath(IBuildInfo buildInfo) {
        ArrayList<String> pathSegments = new ArrayList<String>();
        if (buildInfo == null) {
            return pathSegments;
        }
        if (buildInfo.getBuildBranch() != null) {
            pathSegments.add(buildInfo.getBuildBranch());
        }
        pathSegments.add(buildInfo.getBuildId());
        pathSegments.add(buildInfo.getTestTag());
        return pathSegments;
    }

    private static String sanitizeFilename(String name) {
        return name.replace(File.separatorChar, '_');
    }

    public File saveLogData(String dataName, LogDataType dataType, InputStream dataStream) throws IOException {
        return this.saveLogDataRaw(dataName, dataType.getFileExt(), dataStream);
    }

    public File saveLogFile(String dataName, LogDataType dataType, File fileToLog) throws IOException {
        long startTime = System.currentTimeMillis();
        String saneDataName = LogFileSaver.sanitizeFilename(dataName);
        if (this.mInvLogDir != null && !this.mInvLogDir.exists()) {
            this.mInvLogDir.mkdirs();
        }
        File logFile = FileUtil.createTempFile(saneDataName + "_", "." + dataType.getFileExt(), this.mInvLogDir);
        logFile.delete();
        FileUtil.hardlinkFile(fileToLog, logFile);
        LogUtil.CLog.i("Saved log file %s. [size=%s, elapsed=%sms]", logFile.getAbsolutePath(), logFile.length(), System.currentTimeMillis() - startTime);
        return logFile;
    }

    public File saveLogDataRaw(String dataName, String ext, InputStream dataStream) throws IOException {
        long startTime = System.currentTimeMillis();
        String saneDataName = LogFileSaver.sanitizeFilename(dataName);
        if (this.mInvLogDir != null && !this.mInvLogDir.exists()) {
            this.mInvLogDir.mkdirs();
        }
        File logFile = FileUtil.createTempFile(saneDataName + "_", "." + ext, this.mInvLogDir);
        FileUtil.writeToFile(dataStream, logFile);
        LogUtil.CLog.i("Saved log file %s. [size=%s, elapsed=%sms]", logFile.getAbsolutePath(), logFile.length(), System.currentTimeMillis() - startTime);
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAndGZipLogData(String dataName, LogDataType dataType, InputStream dataStream) throws IOException {
        File file2;
        if (dataType.isCompressed()) {
            LogUtil.CLog.d("Log data for %s is already compressed, skipping compression", dataName);
            return this.saveLogData(dataName, dataType, dataStream);
        }
        long startTime = System.currentTimeMillis();
        BufferedInputStream bufInput = null;
        OutputStream outStream = null;
        try {
            String saneDataName = LogFileSaver.sanitizeFilename(dataName);
            File logFile = this.createCompressedLogFile(saneDataName, dataType);
            bufInput = new BufferedInputStream(dataStream);
            outStream = this.createGZipLogStream(logFile);
            StreamUtil.copyStreams(bufInput, outStream);
            LogUtil.CLog.i("Saved gzip log file %s. [size=%s, elapsed=%sms]", logFile.getAbsolutePath(), logFile.length(), System.currentTimeMillis() - startTime);
            file2 = logFile;
        }
        catch (Throwable throwable) {
            StreamUtil.close(bufInput);
            StreamUtil.close(outStream);
            throw throwable;
        }
        StreamUtil.close(bufInput);
        StreamUtil.close(outStream);
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAndGZipLogFile(String dataName, LogDataType dataType, File fileToLog) throws IOException {
        File file2;
        if (dataType.isCompressed() || fileToLog.getName().endsWith(".gz")) {
            LogUtil.CLog.d("Log data for %s is already compressed, skipping compression", dataName);
            return this.saveLogFile(dataName, dataType, fileToLog);
        }
        long startTime = System.currentTimeMillis();
        BufferedInputStream bufInput = null;
        OutputStream outStream = null;
        try {
            String saneDataName = LogFileSaver.sanitizeFilename(dataName);
            File logFile = this.createCompressedLogFile(saneDataName, dataType);
            bufInput = new BufferedInputStream(new FileInputStream(fileToLog));
            outStream = this.createGZipLogStream(logFile);
            StreamUtil.copyStreams(bufInput, outStream);
            LogUtil.CLog.i("Saved gzip log file %s. [size=%s, elapsed=%sms]", logFile.getAbsolutePath(), logFile.length(), System.currentTimeMillis() - startTime);
            file2 = logFile;
        }
        catch (Throwable throwable) {
            StreamUtil.close(bufInput);
            StreamUtil.close(outStream);
            throw throwable;
        }
        StreamUtil.close(bufInput);
        StreamUtil.close(outStream);
        return file2;
    }

    public File createCompressedLogFile(String dataName, LogDataType origDataType) throws IOException {
        if (this.mInvLogDir != null && !this.mInvLogDir.exists()) {
            this.mInvLogDir.mkdirs();
        }
        return FileUtil.createTempFile(dataName + "_", String.format(".%s.%s", origDataType.getFileExt(), LogDataType.GZIP.getFileExt()), this.mInvLogDir);
    }

    public OutputStream createGZipLogStream(File logFile) throws IOException {
        return new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(logFile)), 65536);
    }

    public InputStream createInputStreamFromFile(File logFile) throws IOException {
        return new BufferedInputStream(new FileInputStream(logFile), 65536);
    }

    public List<String> getInvocationLogPathSegments() {
        return new ArrayList<String>(this.mInvLogPathSegments);
    }
}

