/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.log.StdoutLogger;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationSummaryHelper;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SystemUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class LogSaverResultForwarder
extends ResultForwarder
implements ILogSaverListener {
    ILogSaver mLogSaver;

    public LogSaverResultForwarder(ILogSaver logSaver, List<ITestInvocationListener> listeners) {
        super(listeners);
        this.mLogSaver = logSaver;
        for (ITestInvocationListener listener : listeners) {
            if (!(listener instanceof ILogSaverListener)) continue;
            ((ILogSaverListener)listener).setLogSaver(this.mLogSaver);
        }
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        try {
            this.mLogSaver.invocationStarted(context);
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Caught runtime exception from log saver: %s", this.mLogSaver.getClass().getName());
            LogUtil.CLog.e(e);
        }
        InvocationSummaryHelper.reportInvocationStarted(this.getListeners(), context);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        InvocationSummaryHelper.reportInvocationEnded(this.getListeners(), elapsedTime);
        try {
            this.mLogSaver.invocationEnded(elapsedTime);
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Caught runtime exception from log saver: %s", this.mLogSaver.getClass().getName());
            LogUtil.CLog.e(e);
        }
        LogSaverResultForwarder.reportEndHostLog(this.getListeners(), this.mLogSaver, "end_host_log");
    }

    public static void logFile(List<ITestInvocationListener> listeners, ILogSaver saver, InputStreamSource source, String name, LogDataType type) {
        try (InputStream stream = source.createInputStream();){
            LogFile logFile = saver.saveLogData(name, type, stream);
            for (ITestInvocationListener listener : listeners) {
                try {
                    if (!(listener instanceof ILogSaverListener)) continue;
                    ((ILogSaverListener)listener).testLogSaved(name, type, source, logFile);
                    ((ILogSaverListener)listener).logAssociation(name, logFile);
                }
                catch (Exception e) {
                    LogUtil.CLog.logAndDisplay(Log.LogLevel.ERROR, e.getMessage());
                    LogUtil.CLog.e(e);
                }
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    public static void reportEndHostLog(List<ITestInvocationListener> listeners, ILogSaver saver, String name) {
        block17: {
            LogRegistry registry = (LogRegistry)LogRegistry.getLogRegistry();
            try (InputStreamSource source = registry.getLogger().getLog();){
                if (source == null) {
                    if (!(registry.getLogger() instanceof StdoutLogger)) {
                        LogUtil.CLog.e("%s stream was null, skip saving it.", name);
                    }
                    return;
                }
                LogSaverResultForwarder.logFile(listeners, saver, source, name, LogDataType.HOST_LOG);
                if (!SystemUtil.isRemoteEnvironment()) break block17;
                try (InputStream stream = source.createInputStream();){
                    System.out.println(String.format("===== Result Reporters =====\n%s", StreamUtil.getStringFromStream(stream)));
                }
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        this.testLogForward(dataName, dataType, dataStream);
        try {
            if (dataStream == null) {
                LogUtil.CLog.w("Skip forwarding of '%s', data stream is null.", dataName);
                return;
            }
            long startTime = System.currentTimeMillis();
            LogFile logFile = null;
            try {
                logFile = dataStream instanceof FileInputStreamSource ? this.mLogSaver.saveLogFile(dataName, dataType, ((FileInputStreamSource)dataStream).getFile()) : this.mLogSaver.saveLogData(dataName, dataType, dataStream.createInputStream());
            }
            finally {
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.LOG_SAVING_TIME, System.currentTimeMillis() - startTime);
                InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.LOG_SAVING_COUNT, 1L);
            }
            for (ITestInvocationListener listener : this.getListeners()) {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).testLogSaved(dataName, dataType, dataStream, logFile);
                ((ILogSaverListener)listener).logAssociation(dataName, logFile);
            }
        }
        catch (IOException | RuntimeException e) {
            LogUtil.CLog.e("Failed to save log data");
            LogUtil.CLog.e(e);
        }
    }

    public void testLogForward(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        super.testLog(dataName, dataType, dataStream);
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        try {
            for (ITestInvocationListener listener : this.getListeners()) {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).testLogSaved(dataName, dataType, dataStream, logFile);
            }
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to save log data");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        for (ITestInvocationListener listener : this.getListeners()) {
            try {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(dataName, logFile);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Failed to provide the log association");
                LogUtil.CLog.e(e);
            }
        }
    }
}

