/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.loganalysis.item.JavaCrashItem;
import com.android.loganalysis.item.LogcatItem;
import com.android.loganalysis.item.MiscLogcatItem;
import com.android.loganalysis.item.NativeCrashItem;
import com.android.loganalysis.parser.LogcatParser;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;

public class LogcatCrashResultForwarder
extends ResultForwarder {
    public static final String ERROR_MESSAGE = "Process crashed.";
    public static final String SYSTEM_CRASH_MESSAGE = "System has crashed.";
    public static final String INCOMPLETE_MESSAGE = "Test run failed to complete";
    public static final List<String> TIMEOUT_MESSAGES = ImmutableList.of("Failed to receive adb shell test output", "TimeoutException when running tests", "TestTimedOutException: test timed out after");
    public static final int MAX_NUMBER_CRASH = 3;
    private static final int MAX_CRASH_SIZE = 250000;
    private static final String MAX_CRASH_SIZE_MESSAGE = "\n<Truncated>";
    private static final String FILTER_NOT_FOUND = "java.lang.IllegalArgumentException: testfile not found:";
    private static final String FILTER_NOT_READ = "java.lang.IllegalArgumentException: Could not read test file";
    private static final String LOW_MEMORY_KILLER_TAG = "lowmemorykiller";
    private Long mStartTime = null;
    private Long mLastStartTime = null;
    private ITestDevice mDevice;
    private LogcatItem mLogcatItem = null;
    private String mPackageName = null;

    public LogcatCrashResultForwarder(ITestDevice device, ITestInvocationListener ... listeners) {
        super(listeners);
        this.mDevice = device;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        this.mStartTime = startTime;
        super.testStarted(test, startTime);
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        this.testFailed(test, FailureDescription.create(trace));
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        if (TestRecordProto.FailureStatus.NOT_EXECUTED.equals(failure.getFailureStatus())) {
            super.testFailed(test, failure);
            return;
        }
        String trace = this.extractCrashAndAddToMessage(failure.getErrorMessage(), this.mStartTime);
        if (trace.contains(LOW_MEMORY_KILLER_TAG)) {
            failure.setErrorIdentifier(DeviceErrorIdentifier.INSTRUMENTATION_LOWMEMORYKILLER);
        } else if (this.isCrash(failure.getErrorMessage())) {
            failure.setErrorIdentifier(DeviceErrorIdentifier.INSTRUMENTATION_CRASH);
        } else if (this.isTimeout(failure.getErrorMessage())) {
            failure.setErrorIdentifier(TestErrorIdentifier.INSTRUMENTATION_TIMED_OUT);
        }
        failure.setErrorMessage(trace);
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.TEST_CRASH_FAILURES, 1L);
        if (failure.getFailureStatus() == null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.UNCAUGHT_TEST_CRASH_FAILURES, 1L);
        }
        super.testFailed(test, failure);
    }

    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        super.testEnded(test, endTime, testMetrics);
        this.mLastStartTime = this.mStartTime;
        this.mStartTime = null;
    }

    @Override
    public void testRunFailed(String errorMessage) {
        this.testRunFailed(FailureDescription.create(errorMessage, TestRecordProto.FailureStatus.TEST_FAILURE));
    }

    @Override
    public void testRunFailed(FailureDescription error) {
        String errorMessage = error.getErrorMessage();
        if (this.mLogcatItem != null) {
            errorMessage = this.addCrashesToString(this.mLogcatItem, errorMessage);
            this.mLogcatItem = null;
        } else {
            errorMessage = this.extractCrashAndAddToMessage(errorMessage, this.mLastStartTime);
        }
        if (this.isCrash(errorMessage)) {
            error.setErrorIdentifier(DeviceErrorIdentifier.INSTRUMENTATION_CRASH);
            if (errorMessage.contains(FILTER_NOT_FOUND) || errorMessage.contains(FILTER_NOT_READ)) {
                LogUtil.CLog.d("Detected a permission error with filters.");
                error.setRetriable(false);
                error.setErrorIdentifier(TestErrorIdentifier.TEST_FILTER_NEEDS_UPDATE);
                errorMessage = "See go/iae-testfile-not-found \n" + errorMessage;
            }
        }
        error.setErrorMessage(errorMessage.trim());
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CRASH_FAILURES, 1L);
        if (error.getFailureStatus() == null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.UNCAUGHT_CRASH_FAILURES, 1L);
        }
        super.testRunFailed(error);
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        super.testRunEnded(elapsedTime, runMetrics);
        this.mLastStartTime = null;
    }

    private String extractCrashAndAddToMessage(String errorMessage, Long startTime) {
        if (startTime == null) {
            startTime = System.currentTimeMillis() - 60000L;
        }
        if (this.isCrash(errorMessage) && startTime != null) {
            this.mLogcatItem = this.extractLogcat(this.mDevice, startTime);
            errorMessage = this.addCrashesToString(this.mLogcatItem, errorMessage);
        }
        return errorMessage;
    }

    private boolean isCrash(String errorMessage) {
        return errorMessage.contains(ERROR_MESSAGE) || errorMessage.contains(SYSTEM_CRASH_MESSAGE) || errorMessage.contains(INCOMPLETE_MESSAGE);
    }

    private boolean isTimeout(String errorMessage) {
        for (String timeoutMessage : TIMEOUT_MESSAGES) {
            if (!errorMessage.contains(timeoutMessage)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LogcatItem extractLogcat(ITestDevice device, long startTime) {
        if (!TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) {
            LogUtil.CLog.w("Device is in state '%s' skip attempt to extract crash.", new Object[]{device.getDeviceState()});
            return null;
        }
        try (InputStreamSource logSource = device.getLogcatSince(startTime);){
            if (logSource == null) {
                LogcatItem logcatItem = null;
                return logcatItem;
            }
            if (logSource.size() == 0L) {
                LogcatItem logcatItem = null;
                return logcatItem;
            }
            LogcatParser parser = new LogcatParser();
            if (this.mPackageName != null) {
                parser.addPattern(Pattern.compile(String.format("Kill '%s'.*", this.mPackageName)), null, LOW_MEMORY_KILLER_TAG, LOW_MEMORY_KILLER_TAG);
            }
            LogcatItem result = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(logSource.createInputStream()));){
                result = parser.parse(reader);
            }
            LogcatItem logcatItem = result;
            return logcatItem;
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            return null;
        }
    }

    private String addCrashesToString(LogcatItem item, String errorMsg) {
        List lowMemKiller;
        if (item == null) {
            return errorMsg;
        }
        List<String> javaCrashes = this.dedupJavaCrash(item.getJavaCrashes());
        Collections.reverse(javaCrashes);
        int displayed = Math.min(javaCrashes.size(), 3);
        if (!javaCrashes.isEmpty()) {
            errorMsg = String.format("%s\nJava Crash Messages sorted from most recent:\n", errorMsg);
            for (int i = 0; i < displayed; ++i) {
                errorMsg = String.format("%s%s\n", errorMsg, this.truncateLargeCrash(javaCrashes.get(i)));
            }
        }
        List<String> nativeCrashes = this.dedupNativeCrash(item.getNativeCrashes());
        Collections.reverse(nativeCrashes);
        displayed = Math.min(nativeCrashes.size(), 3);
        if (!nativeCrashes.isEmpty()) {
            errorMsg = String.format("%s\nNative Crash Messages sorted from most recent:\n", errorMsg);
            for (int i = 0; i < displayed; ++i) {
                errorMsg = String.format("%s%s\n", errorMsg, nativeCrashes.get(i));
            }
        }
        if (!(lowMemKiller = item.getMiscEvents(LOW_MEMORY_KILLER_TAG)).isEmpty()) {
            errorMsg = String.format("%s\nInstrumentation was killed by lowmemorykiller: %s", errorMsg, ((MiscLogcatItem)lowMemKiller.get(0)).getStack());
        }
        return errorMsg;
    }

    private String truncateLargeCrash(String stack) {
        if (stack.length() > 250000) {
            return stack.substring(0, 250000) + MAX_CRASH_SIZE_MESSAGE;
        }
        return stack;
    }

    private List<String> dedupJavaCrash(List<JavaCrashItem> origList) {
        LinkedHashSet<String> dedupList = new LinkedHashSet<String>();
        for (JavaCrashItem item : origList) {
            dedupList.add(String.format("%s\n%s", item.getMessage(), item.getStack()));
        }
        return new ArrayList<String>(dedupList);
    }

    private List<String> dedupNativeCrash(List<NativeCrashItem> origList) {
        LinkedHashSet<String> dedupList = new LinkedHashSet<String>();
        for (NativeCrashItem item : origList) {
            dedupList.add(String.format("fingerprint: %s\napp: %s\n%s", item.getFingerprint(), item.getApp(), item.getStack()));
        }
        return new ArrayList<String>(dedupList);
    }
}

