/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.kxml2.io.KXmlSerializer;

@OptionClass(alias="metricsreporter")
public class MetricsXMLResultReporter
extends CollectingTestListener {
    private static final String METRICS_PREFIX = "metrics-";
    private static final String TAG_TESTSUITE = "testsuite";
    private static final String TAG_TESTCASE = "testcase";
    private static final String TAG_RUN_METRIC = "runmetric";
    private static final String TAG_TEST_METRIC = "testmetric";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_TESTNAME = "testname";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_TESTS = "tests";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String NS = null;
    @Option(name="metrics-folder", description="The folder to save metrics files")
    private File mFolder;
    private File mLog;

    @Override
    public void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        if (this.mFolder == null) {
            LogUtil.CLog.w("metrics-folder not specified, unable to record metrics");
            return;
        }
        this.generateResults(elapsedTime);
    }

    private void generateResults(long elapsedTime) {
        String timestamp = this.getTimeStamp();
        OutputStream os = null;
        try {
            os = this.createOutputStream();
            if (os == null) {
                return;
            }
            KXmlSerializer serializer = new KXmlSerializer();
            serializer.setOutput(os, "UTF-8");
            serializer.startDocument("UTF-8", null);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            this.printRunResults(serializer, timestamp, elapsedTime);
            serializer.endDocument();
            if (this.mLog != null) {
                LogUtil.CLog.i("XML metrics report generated at %s. Total tests %d, Failed %d", this.mLog.getPath(), this.getNumTotalTests(), this.getNumAllFailedTests());
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to generate XML metric report");
            throw new RuntimeException(e);
        }
        finally {
            StreamUtil.close(os);
        }
    }

    private void printRunResults(KXmlSerializer serializer, String timestamp, long elapsedTime) throws IOException {
        serializer.startTag(NS, TAG_TESTSUITE);
        serializer.attribute(NS, ATTR_NAME, this.getInvocationContext().getTestTag());
        serializer.attribute(NS, ATTR_TESTS, Integer.toString(this.getNumTotalTests()));
        serializer.attribute(NS, ATTR_FAILURES, Integer.toString(this.getNumAllFailedTests()));
        serializer.attribute(NS, ATTR_TIME, Long.toString(elapsedTime));
        serializer.attribute(NS, ATTR_TIMESTAMP, timestamp);
        for (TestRunResult runResult : this.getMergedTestRunResults()) {
            this.printRunMetrics(serializer, runResult.getRunMetrics());
            Map<TestDescription, TestResult> testResults = runResult.getTestResults();
            for (TestDescription test : testResults.keySet()) {
                this.printTestResults(serializer, test, testResults.get(test));
            }
        }
        serializer.endTag(NS, TAG_TESTSUITE);
    }

    private void printTestResults(KXmlSerializer serializer, TestDescription testId, TestResult testResult) throws IOException {
        serializer.startTag(NS, TAG_TESTCASE);
        serializer.attribute(NS, ATTR_TESTNAME, testId.getTestName());
        serializer.attribute(NS, ATTR_CLASSNAME, testId.getClassName());
        long elapsedTime = testResult.getEndTime() - testResult.getStartTime();
        serializer.attribute(NS, ATTR_TIME, Long.toString(elapsedTime));
        this.printTestMetrics(serializer, testResult.getMetrics());
        if (!TestResult.TestStatus.PASSED.equals((Object)testResult.getStatus())) {
            String result = testResult.getStatus().name();
            serializer.startTag(NS, result);
            String stackText = this.sanitize(testResult.getStackTrace());
            serializer.text(stackText);
            serializer.endTag(NS, result);
        }
        serializer.endTag(NS, TAG_TESTCASE);
    }

    private void printRunMetrics(KXmlSerializer serializer, Map<String, String> metrics) throws IOException {
        for (String key : metrics.keySet()) {
            serializer.startTag(NS, TAG_RUN_METRIC);
            serializer.attribute(NS, ATTR_NAME, key);
            serializer.attribute(NS, ATTR_VALUE, metrics.get(key));
            serializer.endTag(NS, TAG_RUN_METRIC);
        }
    }

    private void printTestMetrics(KXmlSerializer serializer, Map<String, String> metrics) throws IOException {
        for (String key : metrics.keySet()) {
            serializer.startTag(NS, TAG_TEST_METRIC);
            serializer.attribute(NS, ATTR_NAME, key);
            serializer.attribute(NS, ATTR_VALUE, metrics.get(key));
            serializer.endTag(NS, TAG_TEST_METRIC);
        }
    }

    @VisibleForTesting
    public OutputStream createOutputStream() throws IOException {
        if (!this.mFolder.exists() && !this.mFolder.mkdirs()) {
            throw new IOException(String.format("Unable to create metrics directory: %s", this.mFolder));
        }
        this.mLog = FileUtil.createTempFile(METRICS_PREFIX, ".xml", this.mFolder);
        return new BufferedOutputStream(new FileOutputStream(this.mLog));
    }

    private String sanitize(String text) {
        return text == null ? "" : text.replace("\u0000", "<\\0>");
    }

    @VisibleForTesting
    public String getTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.setLenient(true);
        return dateFormat.format(new Date());
    }
}

