/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class MultiFailureDescription
extends FailureDescription {
    private List<FailureDescription> mFailures = new ArrayList<FailureDescription>();

    public MultiFailureDescription(List<FailureDescription> failures) {
        this.addMultiFailures(failures);
    }

    public MultiFailureDescription(FailureDescription ... failures) {
        this(Arrays.asList(failures));
    }

    public MultiFailureDescription addFailure(FailureDescription failure) {
        if (failure instanceof MultiFailureDescription) {
            this.addMultiFailures(((MultiFailureDescription)failure).getFailures());
        } else {
            this.mFailures.add(failure);
        }
        return this;
    }

    public List<FailureDescription> getFailures() {
        return this.mFailures;
    }

    @Override
    @Nullable
    public TestRecordProto.FailureStatus getFailureStatus() {
        if (this.mFailures.isEmpty()) {
            return null;
        }
        return this.mFailures.get(0).getFailureStatus();
    }

    @Override
    public String getErrorMessage() {
        if (this.mFailures.isEmpty()) {
            return null;
        }
        return this.toString();
    }

    @Override
    public ErrorIdentifier getErrorIdentifier() {
        if (this.mFailures.isEmpty()) {
            return null;
        }
        return this.mFailures.get(0).getErrorIdentifier();
    }

    @Override
    public String getOrigin() {
        if (this.mFailures.isEmpty()) {
            return null;
        }
        return this.mFailures.get(0).getOrigin();
    }

    @Override
    public boolean isRetriable() {
        for (FailureDescription desc : this.mFailures) {
            if (!desc.isRetriable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.mFailures.size() == 1) {
            return this.mFailures.get(0).toString();
        }
        StringBuilder sb = new StringBuilder(String.format("There were %d failures:", this.mFailures.size()));
        for (FailureDescription f : this.mFailures) {
            sb.append(String.format("\n  %s", f.toString()));
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiFailureDescription other = (MultiFailureDescription)obj;
        if (other.mFailures.size() != this.mFailures.size()) {
            return false;
        }
        for (int i = 0; i < this.mFailures.size(); ++i) {
            if (this.mFailures.get(i).equals(other.mFailures.get(i))) continue;
            return false;
        }
        return true;
    }

    private void addMultiFailures(List<FailureDescription> failures) {
        for (FailureDescription failure : failures) {
            if (failure instanceof MultiFailureDescription) {
                this.addMultiFailures(((MultiFailureDescription)failure).getFailures());
                continue;
            }
            this.mFailures.add(failure);
        }
    }
}

