/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestSummary;
import java.util.HashMap;

public abstract class NameMangleListener
implements ITestInvocationListener {
    private final ITestInvocationListener mListener;

    public NameMangleListener(ITestInvocationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.mListener = listener;
    }

    protected TestDescription mangleTestId(TestDescription test) {
        return test;
    }

    protected String mangleTestRunName(String name) {
        return name;
    }

    @Override
    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        TestDescription mangledTestId = this.mangleTestId(test);
        this.mListener.testEnded(mangledTestId, testMetrics);
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        TestDescription mangledTestId = this.mangleTestId(test);
        this.mListener.testFailed(mangledTestId, trace);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, String trace) {
        TestDescription mangledTestId = this.mangleTestId(test);
        this.mListener.testAssumptionFailure(mangledTestId, trace);
    }

    @Override
    public void testIgnored(TestDescription test) {
        TestDescription mangledTestId = this.mangleTestId(test);
        this.mListener.testIgnored(mangledTestId);
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        this.mListener.testRunEnded(elapsedTime, runMetrics);
    }

    @Override
    public void testRunFailed(String errorMessage) {
        this.mListener.testRunFailed(errorMessage);
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        String mangledName = this.mangleTestRunName(runName);
        this.mListener.testRunStarted(mangledName, testCount);
    }

    @Override
    public void testRunStopped(long elapsedTime) {
        this.mListener.testRunStopped(elapsedTime);
    }

    @Override
    public void testStarted(TestDescription test) {
        TestDescription mangledTestId = this.mangleTestId(test);
        this.mListener.testStarted(mangledTestId);
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        this.mListener.invocationStarted(context);
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        this.mListener.testLog(dataName, dataType, dataStream);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        this.mListener.invocationEnded(elapsedTime);
    }

    @Override
    public void invocationFailed(Throwable cause) {
        this.mListener.invocationFailed(cause);
    }

    @Override
    public TestSummary getSummary() {
        return this.mListener.getSummary();
    }
}

