/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.retry.ISupportGranularResults;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ReportPassedTests
extends CollectingTestListener
implements IConfigurationReceiver,
ISupportGranularResults {
    private static final String PASSED_TEST_LOG = "passed_tests";
    private boolean mInvocationFailed = false;
    private ITestLogger mLogger;
    private boolean mModuleInProgress;
    private IInvocationContext mContextForEmptyModule;
    private Integer mShardIndex;
    private File mPassedTests;

    public void setLogger(ITestLogger logger) {
        this.mLogger = logger;
    }

    @Override
    public boolean supportGranularResults() {
        return false;
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        super.invocationStarted(context);
        try {
            this.mPassedTests = FileUtil.createTempFile(PASSED_TEST_LOG, ".txt");
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        if (configuration.getCommandOptions().getShardIndex() != null) {
            this.mShardIndex = configuration.getCommandOptions().getShardIndex();
        }
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        super.testModuleStarted(moduleContext);
        this.mModuleInProgress = true;
        this.mContextForEmptyModule = moduleContext;
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        this.mContextForEmptyModule = null;
        super.testRunEnded(elapsedTime, runMetrics);
        if (!this.mModuleInProgress) {
            this.gatherPassedTests(this.getCurrentRunResults(), this.getBaseName(this.getCurrentRunResults()), this.mInvocationFailed);
            this.clearResultsForName(this.getCurrentRunResults().getName());
            this.getCurrentRunResults().resetRunFailure();
        }
    }

    @Override
    public void testModuleEnded() {
        if (this.mContextForEmptyModule != null) {
            String moduleId = this.mContextForEmptyModule.getAttributes().getUniqueMap().get("module-id");
            if (moduleId != null) {
                super.testRunStarted(moduleId, 0);
                super.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
            }
            this.mContextForEmptyModule = null;
        }
        super.testModuleEnded();
        this.gatherPassedTests(this.getCurrentRunResults(), this.getBaseName(this.getCurrentRunResults()), this.mInvocationFailed);
        this.clearResultsForName(this.getCurrentRunResults().getName());
        this.getCurrentRunResults().resetRunFailure();
        this.mModuleInProgress = false;
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        super.invocationFailed(failure);
        this.mInvocationFailed = true;
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        try {
            super.invocationEnded(elapsedTime);
            this.createPassedLog();
        }
        finally {
            FileUtil.deleteFile(this.mPassedTests);
        }
    }

    private void createPassedLog() {
        if (this.mLogger == null || this.mPassedTests == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (TestRunResult result : this.getMergedTestRunResults()) {
            sb.append(this.createFilters(result, this.getBaseName(result), false));
        }
        if (sb.length() > 0) {
            try {
                FileUtil.writeToFile(sb.toString(), this.mPassedTests, true);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
        if (this.mPassedTests.length() == 0L) {
            LogUtil.CLog.d("No new filter for passed_test");
            return;
        }
        this.testLog(this.mPassedTests);
    }

    @VisibleForTesting
    void testLog(File toBeLogged) {
        try (FileInputStreamSource source = new FileInputStreamSource(toBeLogged);){
            this.mLogger.testLog(PASSED_TEST_LOG, LogDataType.PASSED_TESTS, source);
        }
    }

    private String getBaseName(TestRunResult runResult) {
        IInvocationContext context = this.getModuleContextForRunResult(runResult.getName());
        if (context != null) {
            return context.getAttributes().getUniqueMap().get("module-id");
        }
        return runResult.getName();
    }

    private String createFilters(TestRunResult runResult, String baseName, boolean invocationFailure) {
        if (this.mShardIndex != null) {
            baseName = "shard_" + this.mShardIndex + " " + baseName;
        }
        StringBuilder sb = new StringBuilder();
        if (!(runResult.hasFailedTests() || runResult.isRunFailure() || invocationFailure)) {
            sb.append(baseName);
            sb.append("\n");
            return sb.toString();
        }
        for (Map.Entry<TestDescription, TestResult> res : runResult.getTestResults().entrySet()) {
            if (TestResult.TestStatus.FAILURE.equals((Object)res.getValue().getStatus())) continue;
            sb.append(baseName + " " + res.getKey().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void gatherPassedTests(TestRunResult runResult, String baseName, boolean invocationFailure) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createFilters(runResult, baseName, invocationFailure));
        if ((long)sb.length() == 0L) {
            return;
        }
        try {
            FileUtil.writeToFile(sb.toString(), this.mPassedTests, true);
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }
}

