/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationSummaryHelper;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.ResultForwarder;
import java.util.List;

public class ResultAndLogForwarder
extends ResultForwarder
implements ILogSaverListener {
    public ResultAndLogForwarder(List<ITestInvocationListener> listeners) {
        super(listeners);
    }

    public ResultAndLogForwarder(ITestInvocationListener ... listeners) {
        super(listeners);
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        InvocationSummaryHelper.reportInvocationStarted(this.getListeners(), context);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        InvocationSummaryHelper.reportInvocationEnded(this.getListeners(), elapsedTime);
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        try {
            for (ITestInvocationListener listener : this.getListeners()) {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).testLogSaved(dataName, dataType, dataStream, logFile);
            }
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to save log data");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        for (ITestInvocationListener listener : this.getListeners()) {
            try {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(dataName, logFile);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Failed to provide the log association");
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void setLogSaver(ILogSaver logSaver) {
        for (ITestInvocationListener listener : this.getListeners()) {
            try {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).setLogSaver(logSaver);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Failed to setLogSaver");
                LogUtil.CLog.e(e);
            }
        }
    }
}

