/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationSummaryHelper;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestSummary;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ResultForwarder
implements ITestInvocationListener {
    private List<ITestInvocationListener> mListeners;

    protected ResultForwarder() {
        this.mListeners = Collections.emptyList();
    }

    public ResultForwarder(List<ITestInvocationListener> listeners) {
        this.mListeners = listeners;
    }

    public ResultForwarder(ITestInvocationListener ... listeners) {
        this.mListeners = Arrays.asList(listeners);
    }

    protected void setListeners(List<ITestInvocationListener> listeners) {
        this.mListeners = listeners;
    }

    protected void setListeners(ITestInvocationListener ... listeners) {
        this.mListeners = Arrays.asList(listeners);
    }

    protected List<ITestInvocationListener> getListeners() {
        return this.mListeners;
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.invocationStarted(context);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#invocationStarted", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void invocationFailed(Throwable cause) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.invocationFailed(cause);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#invocationFailed", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.invocationFailed(failure);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#invocationFailed", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        InvocationSummaryHelper.reportInvocationEnded(this.mListeners, elapsedTime);
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testLog(dataName, dataType, dataStream);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testLog", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testRunStarted(runName, testCount);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testRunStarted", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testRunStarted(String runName, int testCount, int attemptNumber) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testRunStarted(runName, testCount, attemptNumber);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testRunStarted", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testRunStarted(String runName, int testCount, int attemptNumber, long startTime) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testRunStarted(runName, testCount, attemptNumber, startTime);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testRunStarted", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testRunFailed(String errorMessage) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testRunFailed(errorMessage);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testRunFailed", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testRunFailed(failure);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testRunFailed", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testRunStopped(long elapsedTime) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testRunStopped(elapsedTime);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testRunStopped", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testRunEnded(elapsedTime, runMetrics);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testRunEnded", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testStarted(TestDescription test) {
        this.testStarted(test, System.currentTimeMillis());
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testStarted(test, startTime);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testStarted", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testFailed(test, trace);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testFailed", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testFailed(test, failure);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testFailed", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.testEnded(test, System.currentTimeMillis(), testMetrics);
    }

    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testEnded(test, endTime, testMetrics);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testEnded", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testAssumptionFailure(TestDescription test, String trace) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testAssumptionFailure(test, trace);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testAssumptionFailure", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testAssumptionFailure(test, failure);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testAssumptionFailure", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testIgnored(TestDescription test) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testIgnored(test);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking %s#testIgnored", listener.getClass().getName());
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testModuleStarted(moduleContext);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking testModuleStarted");
                LogUtil.CLog.e(e);
            }
        }
    }

    @Override
    public void testModuleEnded() {
        for (ITestInvocationListener listener : this.mListeners) {
            try {
                listener.testModuleEnded();
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while invoking testModuleEnded");
                LogUtil.CLog.e(e);
            }
        }
    }
}

