/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RetentionFileSaver {
    public static final String RETENTION_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss zzz";
    public static final String RETENTION_FILE_NAME = ".retention";

    public void writeRetentionFile(File dir, int logRetentionDays) {
        try {
            long deleteTimeEpoch = System.currentTimeMillis() + (long)logRetentionDays * 24L * 60L * 60L * 1000L;
            Date date = new Date(deleteTimeEpoch);
            File retentionFile = new File(dir, RETENTION_FILE_NAME);
            FileUtil.writeToFile(new SimpleDateFormat(RETENTION_DATE_FORMAT).format(date), retentionFile);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Unable to create retention file in directory in %s", dir.getAbsolutePath());
            LogUtil.CLog.e(e);
        }
    }

    public boolean shouldDelete(File retentionFile) {
        if (!retentionFile.isFile() || !retentionFile.getName().equals(RETENTION_FILE_NAME)) {
            LogUtil.CLog.w("%s is not a retention file", retentionFile.getAbsolutePath());
            return false;
        }
        try {
            String timestamp = FileUtil.readStringFromFile(retentionFile);
            Date retentionDate = new SimpleDateFormat(RETENTION_DATE_FORMAT).parse(timestamp);
            return new Date().after(retentionDate);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Unable to read retention file %s", retentionFile.getAbsolutePath());
            LogUtil.CLog.e(e);
        }
        catch (ParseException e) {
            LogUtil.CLog.e("Unable to read timestamp in retention file %s", retentionFile.getAbsolutePath());
            LogUtil.CLog.e(e);
        }
        return false;
    }
}

