/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SnapshotInputStreamSource
implements InputStreamSource {
    private File mBackingFile;
    private boolean mIsCancelled = false;

    public SnapshotInputStreamSource(String name, InputStream stream) {
        if (stream == null) {
            throw new NullPointerException();
        }
        try {
            this.mBackingFile = this.createBackingFile(name, stream);
        }
        catch (IOException e) {
            LogUtil.CLog.e("Received IOException while trying to wrap a stream");
            LogUtil.CLog.e(e);
            this.close();
        }
    }

    File createBackingFile(String name, InputStream stream) throws IOException {
        File backingFile = FileUtil.createTempFile(name + "_" + this.getClass().getSimpleName() + "_", ".txt");
        FileUtil.writeToFile(stream, backingFile);
        return backingFile;
    }

    @Override
    public synchronized InputStream createInputStream() {
        if (this.mIsCancelled) {
            return null;
        }
        try {
            return new FileInputStream(this.mBackingFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public synchronized void close() {
        this.mIsCancelled = true;
        FileUtil.deleteFile(this.mBackingFile);
        this.mBackingFile = null;
    }

    @Override
    public long size() {
        return this.mBackingFile.length();
    }
}

