/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.result.retry.ISupportGranularResults;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SubprocessEventHelper;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class SubprocessResultsReporter
implements ITestInvocationListener,
ILogSaverListener,
AutoCloseable,
ISupportGranularResults {
    @Option(name="enable-granular-attempts", description="Whether to allow SubprocessResultsReporter receiving granular attempts.")
    private boolean mGranularAttempts = true;
    @Option(name="subprocess-report-file", description="the file where to log the events.")
    private File mReportFile = null;
    @Option(name="subprocess-report-port", description="the port where to connect to send theevents.")
    private Integer mReportPort = null;
    @Option(name="output-test-log", description="Option to report test logs to parent process.")
    private boolean mOutputTestlog = false;
    private IInvocationContext mContext = null;
    private Socket mReportSocket = null;
    private Object mLock = new Object();
    private PrintWriter mPrintWriter = null;
    private boolean mPrintWarning = true;
    private boolean mCancelled = false;

    @Override
    public boolean supportGranularResults() {
        return this.mGranularAttempts;
    }

    @Override
    public void testAssumptionFailure(TestDescription testId, String trace) {
        SubprocessEventHelper.FailedTestEventInfo info = new SubprocessEventHelper.FailedTestEventInfo(testId.getClassName(), testId.getTestName(), trace);
        this.printEvent("TEST_ASSUMPTION_FAILURE", info);
    }

    @Override
    public void testAssumptionFailure(TestDescription testId, FailureDescription failure) {
        SubprocessEventHelper.FailedTestEventInfo info = new SubprocessEventHelper.FailedTestEventInfo(testId.getClassName(), testId.getTestName(), failure);
        this.printEvent("TEST_ASSUMPTION_FAILURE", info);
    }

    @Override
    public void testEnded(TestDescription testId, HashMap<String, MetricMeasurement.Metric> metrics) {
        this.testEnded(testId, System.currentTimeMillis(), metrics);
    }

    @Override
    public void testEnded(TestDescription testId, long endTime, HashMap<String, MetricMeasurement.Metric> metrics) {
        SubprocessEventHelper.TestEndedEventInfo info = new SubprocessEventHelper.TestEndedEventInfo(testId.getClassName(), testId.getTestName(), endTime, TfMetricProtoUtil.compatibleConvert(metrics));
        this.printEvent("TEST_ENDED", info);
    }

    @Override
    public void testFailed(TestDescription testId, String reason) {
        SubprocessEventHelper.FailedTestEventInfo info = new SubprocessEventHelper.FailedTestEventInfo(testId.getClassName(), testId.getTestName(), reason);
        this.printEvent("TEST_FAILED", info);
    }

    @Override
    public void testFailed(TestDescription testId, FailureDescription failure) {
        SubprocessEventHelper.FailedTestEventInfo info = new SubprocessEventHelper.FailedTestEventInfo(testId.getClassName(), testId.getTestName(), failure);
        this.printEvent("TEST_FAILED", info);
    }

    @Override
    public void testIgnored(TestDescription testId) {
        SubprocessEventHelper.BaseTestEventInfo info = new SubprocessEventHelper.BaseTestEventInfo(testId.getClassName(), testId.getTestName());
        this.printEvent("TEST_IGNORED", info);
    }

    @Override
    public void testRunEnded(long time, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        SubprocessEventHelper.TestRunEndedEventInfo info = new SubprocessEventHelper.TestRunEndedEventInfo(time, TfMetricProtoUtil.compatibleConvert(runMetrics));
        this.printEvent("TEST_RUN_ENDED", info);
    }

    @Override
    public void testRunFailed(String reason) {
        SubprocessEventHelper.TestRunFailedEventInfo info = new SubprocessEventHelper.TestRunFailedEventInfo(reason);
        this.printEvent("TEST_RUN_FAILED", info);
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        SubprocessEventHelper.TestRunFailedEventInfo info = new SubprocessEventHelper.TestRunFailedEventInfo(failure);
        this.printEvent("TEST_RUN_FAILED", info);
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        this.testRunStarted(runName, testCount, 0);
    }

    @Override
    public void testRunStarted(String runName, int testCount, int attemptNumber) {
        this.testRunStarted(runName, testCount, attemptNumber, System.currentTimeMillis());
    }

    @Override
    public void testRunStarted(String runName, int testCount, int attemptNumber, long startTime) {
        SubprocessEventHelper.TestRunStartedEventInfo info = new SubprocessEventHelper.TestRunStartedEventInfo(runName, testCount, attemptNumber, startTime);
        this.printEvent("TEST_RUN_STARTED", info);
    }

    @Override
    public void testRunStopped(long arg0) {
    }

    @Override
    public void testStarted(TestDescription testId) {
        this.testStarted(testId, System.currentTimeMillis());
    }

    @Override
    public void testStarted(TestDescription testId, long startTime) {
        SubprocessEventHelper.TestStartedEventInfo info = new SubprocessEventHelper.TestStartedEventInfo(testId.getClassName(), testId.getTestName(), startTime);
        this.printEvent("TEST_STARTED", info);
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        SubprocessEventHelper.InvocationStartedEventInfo info = new SubprocessEventHelper.InvocationStartedEventInfo(context.getTestTag(), System.currentTimeMillis());
        this.printEvent("INVOCATION_STARTED", info);
        this.mContext = context;
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        if (!this.mOutputTestlog || this.mReportPort == null && this.mReportFile == null) {
            return;
        }
        if (dataStream != null && dataStream.size() != 0L) {
            File tmpFile = null;
            try {
                tmpFile = FileUtil.createTempFile("subprocess-" + dataName, "." + dataType.getFileExt());
                FileUtil.writeToFile(dataStream.createInputStream(), tmpFile);
                SubprocessEventHelper.TestLogEventInfo info = new SubprocessEventHelper.TestLogEventInfo(dataName, dataType, tmpFile);
                this.printEvent("TEST_LOG", info);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
                FileUtil.deleteFile(tmpFile);
            }
        }
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        SubprocessEventHelper.LogAssociationEventInfo info = new SubprocessEventHelper.LogAssociationEventInfo(dataName, logFile);
        this.printEvent("LOG_ASSOCIATION", info);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        if (this.mContext == null) {
            return;
        }
        Map<String, String> metrics = this.mContext.getAttributes().getUniqueMap();
        SubprocessEventHelper.InvocationEndedEventInfo eventEnd = new SubprocessEventHelper.InvocationEndedEventInfo(metrics);
        this.printEvent("INVOCATION_ENDED", eventEnd);
        SocketFinisher thread = new SocketFinisher();
        Runtime.getRuntime().addShutdownHook(thread);
    }

    @Override
    public void invocationFailed(Throwable cause) {
        SubprocessEventHelper.InvocationFailedEventInfo info = new SubprocessEventHelper.InvocationFailedEventInfo(cause);
        this.printEvent("INVOCATION_FAILED", info);
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        SubprocessEventHelper.InvocationFailedEventInfo info = new SubprocessEventHelper.InvocationFailedEventInfo(failure);
        this.printEvent("INVOCATION_FAILED", info);
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        SubprocessEventHelper.TestModuleStartedEventInfo info = new SubprocessEventHelper.TestModuleStartedEventInfo(moduleContext);
        this.printEvent("TEST_MODULE_STARTED", info);
    }

    @Override
    public void testModuleEnded() {
        this.printEvent("TEST_MODULE_ENDED", new JSONObject());
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printEvent(String key, Object event) {
        String eventLog;
        block19: {
            if (this.mReportFile != null) {
                if (this.mReportFile.canWrite()) {
                    try (FileWriter fw = new FileWriter(this.mReportFile, true);){
                        eventLog = String.format("%s %s\n", key, event.toString());
                        fw.append(eventLog);
                        fw.flush();
                        break block19;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(String.format("report file: %s is not writable", this.mReportFile.getAbsolutePath()));
            }
        }
        if (this.mReportPort != null) {
            try {
                if (this.mCancelled) {
                    return;
                }
                Object e = this.mLock;
                synchronized (e) {
                    if (this.mReportSocket == null) {
                        this.mReportSocket = new Socket("localhost", (int)this.mReportPort);
                        this.mPrintWriter = new PrintWriter(this.mReportSocket.getOutputStream(), true);
                    }
                    if (!this.mReportSocket.isConnected()) {
                        throw new RuntimeException("Reporter Socket is not connected");
                    }
                    eventLog = String.format("%s %s\n", key, event.toString());
                    this.mPrintWriter.print(eventLog);
                    this.mPrintWriter.flush();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.mReportFile == null && this.mReportPort == null && this.mPrintWarning) {
            this.mPrintWarning = false;
            LogUtil.CLog.w("No report file or socket has been configured, skipping this reporter.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.mCancelled = true;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPrintWriter != null) {
                this.mPrintWriter.flush();
            }
            StreamUtil.close(this.mPrintWriter);
            this.mPrintWriter = null;
            StreamUtil.close(this.mReportSocket);
            this.mReportSocket = null;
        }
    }

    public void setOutputTestLog(boolean outputTestLog) {
        this.mOutputTestlog = outputTestLog;
    }

    private class SocketFinisher
    extends Thread {
        public SocketFinisher() {
            this.setName("SubprocessResultsReporter-socket-finisher");
        }

        @Override
        public void run() {
            SubprocessResultsReporter.this.close();
        }
    }
}

