/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestIdentifier;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TestDescription
implements Serializable,
Comparable<TestDescription> {
    public static final Pattern PARAMETERIZED_TEST_REGEX = Pattern.compile("([^\\[]+)\\[(.*)\\]$");
    private final String mClassName;
    private final String mTestName;
    private final String mTestNameNoParams;
    private Annotation[] mAnnotations;

    public TestDescription(String className, String testName) {
        if (className == null || testName == null) {
            throw new IllegalArgumentException("className and testName must be non-null");
        }
        this.mClassName = className;
        this.mTestName = testName;
        this.mAnnotations = new Annotation[0];
        Matcher m = PARAMETERIZED_TEST_REGEX.matcher(testName);
        this.mTestNameNoParams = m.find() ? m.group(1) : testName;
    }

    public TestDescription(String className, String testName, Annotation ... annotations) {
        this(className, testName);
        this.mAnnotations = annotations;
    }

    public TestDescription(String className, String testName, Collection<Annotation> annotations) {
        this(className, testName, annotations.toArray(new Annotation[annotations.size()]));
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation each : this.mAnnotations) {
            if (!each.annotationType().equals(annotationType)) continue;
            return (T)((Annotation)annotationType.cast(each));
        }
        return null;
    }

    public Collection<Annotation> getAnnotations() {
        return Arrays.asList(this.mAnnotations);
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getTestName() {
        return this.mTestName;
    }

    public String getTestNameWithoutParams() {
        return this.mTestNameNoParams;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mClassName == null ? 0 : this.mClassName.hashCode());
        result = 31 * result + (this.mTestName == null ? 0 : this.mTestName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestDescription other = (TestDescription)obj;
        return this.mClassName.equals(other.mClassName) && this.mTestName.equals(other.mTestName);
    }

    @Override
    public int compareTo(TestDescription o) {
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return String.format("%s#%s", this.getClassName(), this.getTestName());
    }

    public static TestDescription fromString(String data) {
        String[] segments = data.split("#");
        if (segments.length == 2) {
            return new TestDescription(segments[0], segments[1]);
        }
        return null;
    }

    public static TestDescription createFromTestIdentifier(TestIdentifier testId) {
        return new TestDescription(testId.getClassName(), testId.getTestName());
    }

    public static TestIdentifier convertToIdentifier(TestDescription desc) {
        return new TestIdentifier(desc.getClassName(), desc.getTestName());
    }
}

