/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.tradefed.result.TestDescription;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class TestDescriptionsFile {
    private static final int BUFFER_SIZE = 32768;
    private File mTestFile = null;
    private Set<TestDescription> mTests = null;

    public TestDescriptionsFile() {
    }

    public TestDescriptionsFile(File file2) {
        this.mTestFile = file2;
    }

    public static TestDescriptionsFile fromTests(List<TestDescription> shardTests) {
        TestDescriptionsFile testDescriptionsFile = new TestDescriptionsFile();
        testDescriptionsFile.addAll(shardTests);
        return testDescriptionsFile;
    }

    public File getFile() {
        if (this.mTestFile == null) {
            try {
                File testFile = File.createTempFile("testfile", ".txt");
                this.populateTestFile(testFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mTestFile;
    }

    public void populateTestFile(File testfile) {
        TestDescriptionsFile.populateTestFile(this.getTests(), testfile);
        this.mTestFile = testfile;
    }

    private static void populateTestFile(List<TestDescription> tests, File testFile) {
        Collections.sort(tests);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(testFile), 32768);){
            for (TestDescription test : tests) {
                writer.write(test.toString());
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TestDescription> getTests() {
        return new ArrayList<TestDescription>(this.getOrBuildTests());
    }

    public void add(TestDescription test) {
        this.getOrBuildTests().add(test);
        this.mTestFile = null;
    }

    public void addAll(List<TestDescription> test) {
        this.getOrBuildTests().addAll(test);
        this.mTestFile = null;
    }

    public int size() {
        return this.getOrBuildTests().size();
    }

    public void remove(TestDescription test) {
        this.getOrBuildTests().remove(test);
        this.mTestFile = null;
    }

    private Collection<TestDescription> getOrBuildTests() {
        if (this.mTests == null) {
            this.mTests = new LinkedHashSet<TestDescription>();
            if (this.mTestFile != null) {
                TestDescriptionsFile.readTestsFromFile(this.mTests, this.mTestFile);
            }
        }
        return this.mTests;
    }

    private static void readTestsFromFile(Collection<TestDescription> tests, File testFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(testFile), 32768);){
            String line;
            while ((line = reader.readLine()) != null) {
                TestDescription test = TestDescription.fromString(line);
                if (test == null) continue;
                tests.add(test);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

