/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.MultiFailureDescription;
import com.android.tradefed.retry.MergeStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TestResult {
    public static final String IS_FLAKY = "is_flaky";
    private TestResult.TestStatus mStatus = TestResult.TestStatus.INCOMPLETE;
    private FailureDescription mFailureDescription;
    private Map<String, String> mMetrics;
    private HashMap<String, MetricMeasurement.Metric> mProtoMetrics;
    private Map<String, LogFile> mLoggedFiles;
    private long mStartTime = System.currentTimeMillis();
    private long mEndTime = 0L;

    public TestResult() {
        this.mLoggedFiles = new LinkedHashMap<String, LogFile>();
        this.mMetrics = new HashMap<String, String>();
        this.mProtoMetrics = new HashMap();
    }

    public TestResult.TestStatus getStatus() {
        return this.mStatus;
    }

    public String getStackTrace() {
        if (this.mFailureDescription == null) {
            return null;
        }
        return this.mFailureDescription.toString();
    }

    public FailureDescription getFailure() {
        return this.mFailureDescription;
    }

    public Map<String, String> getMetrics() {
        return this.mMetrics;
    }

    public HashMap<String, MetricMeasurement.Metric> getProtoMetrics() {
        return this.mProtoMetrics;
    }

    public void setMetrics(Map<String, String> metrics) {
        this.mMetrics = metrics;
    }

    public void setProtoMetrics(HashMap<String, MetricMeasurement.Metric> metrics) {
        this.mProtoMetrics = metrics;
    }

    public void addLoggedFile(String dataName, LogFile loggedFile) {
        this.mLoggedFiles.put(dataName, loggedFile);
    }

    public Map<String, LogFile> getLoggedFiles() {
        return new LinkedHashMap<String, LogFile>(this.mLoggedFiles);
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(long startTime) {
        this.mStartTime = startTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public TestResult setStatus(TestResult.TestStatus status) {
        this.mStatus = status;
        return this;
    }

    public void setStackTrace(String stackTrace) {
        this.mFailureDescription = FailureDescription.create(stackTrace);
    }

    public void setFailure(FailureDescription failureDescription) {
        this.mFailureDescription = failureDescription;
    }

    public void setEndTime(long currentTimeMillis) {
        this.mEndTime = currentTimeMillis;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mMetrics, this.mFailureDescription, this.mStatus});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestResult other = (TestResult)obj;
        return Objects.equals(this.mMetrics, other.mMetrics) && Objects.equals(String.valueOf(this.mFailureDescription), String.valueOf(other.mFailureDescription)) && Objects.equals((Object)this.mStatus, (Object)other.mStatus);
    }

    private void markFlaky() {
        this.mProtoMetrics.put(IS_FLAKY, MetricMeasurement.Metric.newBuilder().setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleString("true").build()).build());
    }

    public static TestResult merge(List<TestResult> results, MergeStrategy strategy) {
        if (results.isEmpty()) {
            return null;
        }
        if (MergeStrategy.NO_MERGE.equals((Object)strategy)) {
            throw new IllegalArgumentException("TestResult#merge cannot be called with NO_MERGE strategy.");
        }
        TestResult mergedResult = new TestResult();
        long earliestStartTime = Long.MAX_VALUE;
        long latestEndTime = Long.MIN_VALUE;
        ArrayList<FailureDescription> errors = new ArrayList<FailureDescription>();
        int pass = 0;
        int fail = 0;
        int assumption_failure = 0;
        int ignored = 0;
        int incomplete = 0;
        TestResult.TestStatus lastStatus = null;
        for (TestResult attempt : results) {
            mergedResult.mProtoMetrics.putAll(attempt.getProtoMetrics());
            mergedResult.mMetrics.putAll(attempt.getMetrics());
            mergedResult.mLoggedFiles.putAll(attempt.getLoggedFiles());
            earliestStartTime = Math.min(attempt.getStartTime(), earliestStartTime);
            latestEndTime = Math.max(attempt.getEndTime(), latestEndTime);
            switch (attempt.getStatus()) {
                case PASSED: {
                    ++pass;
                    break;
                }
                case FAILURE: {
                    ++fail;
                    if (attempt.getFailure() == null) break;
                    errors.add(attempt.getFailure());
                    break;
                }
                case INCOMPLETE: {
                    ++incomplete;
                    errors.add(FailureDescription.create("incomplete test case result."));
                    break;
                }
                case ASSUMPTION_FAILURE: {
                    ++assumption_failure;
                    if (attempt.getFailure() == null) break;
                    errors.add(attempt.getFailure());
                    break;
                }
                case IGNORED: {
                    ++ignored;
                }
            }
            lastStatus = attempt.getStatus();
        }
        switch (strategy) {
            case ANY_PASS_IS_PASS: 
            case ONE_TESTCASE_PASS_IS_PASS: {
                if (pass > 0) {
                    mergedResult.setStatus(TestResult.TestStatus.PASSED);
                    if (fail <= 0) break;
                    mergedResult.markFlaky();
                    break;
                }
                if (fail == 0) {
                    if (ignored > 0) {
                        mergedResult.setStatus(TestResult.TestStatus.IGNORED);
                        break;
                    }
                    if (assumption_failure > 0) {
                        mergedResult.setStatus(TestResult.TestStatus.ASSUMPTION_FAILURE);
                        break;
                    }
                    if (incomplete <= 0) break;
                    mergedResult.setStatus(TestResult.TestStatus.INCOMPLETE);
                    break;
                }
                if (TestResult.TestStatus.ASSUMPTION_FAILURE.equals((Object)lastStatus)) {
                    mergedResult.setStatus(TestResult.TestStatus.ASSUMPTION_FAILURE);
                    break;
                }
                if (TestResult.TestStatus.IGNORED.equals((Object)lastStatus)) {
                    mergedResult.setStatus(TestResult.TestStatus.IGNORED);
                    break;
                }
                mergedResult.setStatus(TestResult.TestStatus.FAILURE);
                break;
            }
            default: {
                if (fail > 0) {
                    mergedResult.setStatus(TestResult.TestStatus.FAILURE);
                    break;
                }
                if (ignored > 0) {
                    mergedResult.setStatus(TestResult.TestStatus.IGNORED);
                    break;
                }
                if (assumption_failure > 0) {
                    mergedResult.setStatus(TestResult.TestStatus.ASSUMPTION_FAILURE);
                    break;
                }
                if (incomplete > 0) {
                    mergedResult.setStatus(TestResult.TestStatus.INCOMPLETE);
                    break;
                }
                mergedResult.setStatus(TestResult.TestStatus.PASSED);
            }
        }
        mergedResult.mFailureDescription = errors.isEmpty() ? null : (errors.size() == 1 ? (FailureDescription)errors.get(0) : new MultiFailureDescription(errors));
        mergedResult.setStartTime(earliestStartTime);
        mergedResult.setEndTime(latestEndTime);
        return mergedResult;
    }
}

