/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestLifeCycleReceiver;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import java.util.HashMap;
import java.util.Map;

public abstract class TestResultListener
implements ITestLifeCycleReceiver {
    private TestDescription mCurrentTest;
    private TestResult mCurrentResult;

    public abstract void testResult(TestDescription var1, TestResult var2);

    @Override
    public final void testStarted(TestDescription test, long startTime) {
        if (this.mCurrentTest != null) {
            this.reportTestFinish(null);
        }
        this.mCurrentTest = test;
        this.mCurrentResult = new TestResult();
        this.mCurrentResult.setStartTime(startTime);
    }

    @Override
    public final void testStarted(TestDescription test) {
        this.testStarted(test, System.currentTimeMillis());
    }

    @Override
    public final void testFailed(TestDescription test, String trace) {
        this.mCurrentResult.setStatus(TestResult.TestStatus.FAILURE);
        this.mCurrentResult.setStackTrace(trace);
    }

    @Override
    public final void testAssumptionFailure(TestDescription test, String trace) {
        this.mCurrentResult.setStatus(TestResult.TestStatus.ASSUMPTION_FAILURE);
        this.mCurrentResult.setStackTrace(trace);
    }

    @Override
    public final void testIgnored(TestDescription test) {
        this.mCurrentResult.setStatus(TestResult.TestStatus.IGNORED);
    }

    @Override
    public final void testEnded(TestDescription test, Map<String, String> testMetrics) {
        this.mCurrentResult.setMetrics(testMetrics);
        this.reportTestFinish(test);
    }

    @Override
    public final void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.mCurrentResult.setProtoMetrics(testMetrics);
        this.reportTestFinish(test);
    }

    @Override
    public final void testEnded(TestDescription test, long endTime, Map<String, String> testMetrics) {
        this.mCurrentResult.setMetrics(testMetrics);
        this.reportTestFinish(test, endTime);
    }

    @Override
    public final void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.mCurrentResult.setProtoMetrics(testMetrics);
        this.reportTestFinish(test, endTime);
    }

    @Override
    public void testRunEnded(long elapsedTimeMillis, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        if (this.mCurrentTest != null) {
            this.mCurrentResult.setEndTime(System.currentTimeMillis());
            this.testResult(this.mCurrentTest, this.mCurrentResult);
            this.mCurrentTest = null;
            this.mCurrentResult = null;
        }
    }

    private void reportTestFinish(TestDescription test) {
        this.reportTestFinish(test, System.currentTimeMillis());
    }

    private void reportTestFinish(TestDescription test, long endTime) {
        if (this.mCurrentTest != null && this.mCurrentTest.equals(test) && this.mCurrentResult.getStatus() == TestResult.TestStatus.INCOMPLETE) {
            this.mCurrentResult.setStatus(TestResult.TestStatus.PASSED);
        }
        this.mCurrentResult.setEndTime(endTime);
        this.testResult(this.mCurrentTest, this.mCurrentResult);
        this.mCurrentTest = null;
        this.mCurrentResult = null;
    }
}

