/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.MultiFailureDescription;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.retry.MergeStrategy;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestRunResult {
    public static final String ERROR_DIVIDER = "\n====Next Error====\n";
    private String mTestRunName = "not started";
    private Map<TestDescription, TestResult> mTestResults = new LinkedHashMap<TestDescription, TestResult>();
    private Map<String, String> mRunMetrics = new HashMap<String, String>();
    private HashMap<String, MetricMeasurement.Metric> mRunProtoMetrics = new HashMap();
    private MultiMap<String, LogFile> mRunLoggedFiles;
    private boolean mIsRunComplete = false;
    private long mElapsedTime = 0L;
    private long mStartTime = 0L;
    private TestResult mCurrentTestResult;
    private int[] mStatusCounts = new int[TestResult.TestStatus.values().length];
    private boolean mIsCountDirty = true;
    private FailureDescription mRunFailureError = null;
    private boolean mAggregateMetrics = false;
    private int mExpectedTestCount = 0;

    public TestRunResult() {
        this.mRunLoggedFiles = new MultiMap();
    }

    public void setAggregateMetrics(boolean metricAggregation) {
        this.mAggregateMetrics = metricAggregation;
    }

    public String getName() {
        return this.mTestRunName;
    }

    public Map<TestDescription, TestResult> getTestResults() {
        return this.mTestResults;
    }

    public Map<String, String> getRunMetrics() {
        return this.mRunMetrics;
    }

    public HashMap<String, MetricMeasurement.Metric> getRunProtoMetrics() {
        return this.mRunProtoMetrics;
    }

    public Set<TestDescription> getCompletedTests() {
        ArrayList<TestResult.TestStatus> completedStatuses = new ArrayList<TestResult.TestStatus>();
        for (TestResult.TestStatus s : TestResult.TestStatus.values()) {
            if (s.equals((Object)TestResult.TestStatus.INCOMPLETE)) continue;
            completedStatuses.add(s);
        }
        return this.getTestsInState(completedStatuses);
    }

    public Set<TestDescription> getFailedTests() {
        return this.getTestsInState(Arrays.asList(TestResult.TestStatus.FAILURE));
    }

    public Set<TestDescription> getPassedTests() {
        return this.getTestsInState(Arrays.asList(TestResult.TestStatus.PASSED));
    }

    public Set<TestDescription> getTestsInState(List<TestResult.TestStatus> statuses) {
        LinkedHashSet<TestDescription> tests = new LinkedHashSet<TestDescription>();
        for (Map.Entry<TestDescription, TestResult> testEntry : this.getTestResults().entrySet()) {
            TestResult.TestStatus status = testEntry.getValue().getStatus();
            if (!statuses.contains((Object)status)) continue;
            tests.add(testEntry.getKey());
        }
        return tests;
    }

    public boolean isRunFailure() {
        return this.mRunFailureError != null;
    }

    public boolean isRunComplete() {
        return this.mIsRunComplete;
    }

    private static boolean isRunComplete(boolean isAtLeastOneCompleted, boolean areAllCompleted, MergeStrategy strategy) {
        switch (strategy) {
            case ANY_PASS_IS_PASS: 
            case ONE_TESTRUN_PASS_IS_PASS: {
                return isAtLeastOneCompleted;
            }
        }
        return areAllCompleted;
    }

    public void setRunComplete(boolean runComplete) {
        this.mIsRunComplete = runComplete;
    }

    public int getExpectedTestCount() {
        return this.mExpectedTestCount;
    }

    public int getNumTestsInState(TestResult.TestStatus status) {
        if (this.mIsCountDirty) {
            for (int i = 0; i < this.mStatusCounts.length; ++i) {
                this.mStatusCounts[i] = 0;
            }
            for (TestResult r : this.mTestResults.values()) {
                int n = r.getStatus().ordinal();
                this.mStatusCounts[n] = this.mStatusCounts[n] + 1;
            }
            this.mIsCountDirty = false;
        }
        return this.mStatusCounts[status.ordinal()];
    }

    public List<TestResult> getTestsResultsInState(TestResult.TestStatus status) {
        ArrayList<TestResult> results = new ArrayList<TestResult>();
        for (TestResult r : this.mTestResults.values()) {
            if (!r.getStatus().equals((Object)status)) continue;
            results.add(r);
        }
        return results;
    }

    public int getNumTests() {
        return this.mTestResults.size();
    }

    public int getNumCompleteTests() {
        return this.getNumTests() - this.getNumTestsInState(TestResult.TestStatus.INCOMPLETE);
    }

    public boolean hasFailedTests() {
        return this.getNumAllFailedTests() > 0;
    }

    public int getNumAllFailedTests() {
        return this.getNumTestsInState(TestResult.TestStatus.FAILURE);
    }

    public long getElapsedTime() {
        return this.mElapsedTime;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public String getRunFailureMessage() {
        if (this.mRunFailureError == null) {
            return null;
        }
        return this.mRunFailureError.getErrorMessage();
    }

    public FailureDescription getRunFailureDescription() {
        return this.mRunFailureError;
    }

    public void resetRunFailure() {
        this.mRunFailureError = null;
    }

    public void testRunStarted(String runName, int testCount) {
        this.testRunStarted(runName, testCount, System.currentTimeMillis());
    }

    public void testRunStarted(String runName, int testCount, long startTime) {
        if (this.mExpectedTestCount == 0) {
            this.mExpectedTestCount = testCount;
        } else {
            LogUtil.CLog.w("%s calls testRunStarted more than once. Previous expected count: %s. New Expected count: %s", runName, this.mExpectedTestCount, this.mExpectedTestCount + testCount);
            this.mExpectedTestCount += testCount;
        }
        this.mTestRunName = runName;
        this.mIsRunComplete = false;
        if (this.mStartTime == 0L) {
            this.mStartTime = startTime;
        }
    }

    public void testStarted(TestDescription test) {
        this.testStarted(test, System.currentTimeMillis());
    }

    public void testStarted(TestDescription test, long startTime) {
        this.mCurrentTestResult = new TestResult();
        this.mCurrentTestResult.setStartTime(startTime);
        this.addTestResult(test, this.mCurrentTestResult);
    }

    private void addTestResult(TestDescription test, TestResult testResult) {
        this.mIsCountDirty = true;
        this.mTestResults.put(test, testResult);
    }

    private void updateTestResult(TestDescription test, TestResult.TestStatus status, FailureDescription failure) {
        TestResult r = this.mTestResults.get(test);
        if (r == null) {
            LogUtil.CLog.d("received test event without test start for %s", test);
            r = new TestResult();
        }
        r.setStatus(status);
        if (failure != null) {
            r.setFailure(failure);
        }
        this.addTestResult(test, r);
    }

    public void testFailed(TestDescription test, String trace) {
        this.updateTestResult(test, TestResult.TestStatus.FAILURE, FailureDescription.create(trace));
    }

    public void testFailed(TestDescription test, FailureDescription failure) {
        this.updateTestResult(test, TestResult.TestStatus.FAILURE, failure);
    }

    public void testAssumptionFailure(TestDescription test, String trace) {
        this.updateTestResult(test, TestResult.TestStatus.ASSUMPTION_FAILURE, FailureDescription.create(trace));
    }

    public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        this.updateTestResult(test, TestResult.TestStatus.ASSUMPTION_FAILURE, failure);
    }

    public void testIgnored(TestDescription test) {
        this.updateTestResult(test, TestResult.TestStatus.IGNORED, null);
    }

    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.testEnded(test, System.currentTimeMillis(), testMetrics);
    }

    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        TestResult result = this.mTestResults.get(test);
        if (result == null) {
            result = new TestResult();
        }
        if (result.getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) {
            result.setStatus(TestResult.TestStatus.PASSED);
        }
        result.setEndTime(endTime);
        result.setMetrics(TfMetricProtoUtil.compatibleConvert(testMetrics));
        result.setProtoMetrics(testMetrics);
        this.addTestResult(test, result);
        this.mCurrentTestResult = null;
    }

    public void testRunFailed(String errorMessage) {
        if (errorMessage == null) {
            this.testRunFailed((FailureDescription)null);
        } else {
            this.testRunFailed(FailureDescription.create(errorMessage));
        }
    }

    public void testRunFailed(FailureDescription failureDescription) {
        if (failureDescription == null) {
            failureDescription = FailureDescription.create("testRunFailed(null) was called.");
        }
        if (this.mRunFailureError != null) {
            if (this.mRunFailureError instanceof MultiFailureDescription) {
                ((MultiFailureDescription)this.mRunFailureError).addFailure(failureDescription);
            } else {
                MultiFailureDescription aggregatedFailure = new MultiFailureDescription(this.mRunFailureError, failureDescription);
                this.mRunFailureError = aggregatedFailure;
            }
        } else {
            this.mRunFailureError = failureDescription;
        }
    }

    public void testRunStopped(long elapsedTime) {
        this.mElapsedTime += elapsedTime;
        this.mIsRunComplete = true;
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.mAggregateMetrics) {
            for (Map.Entry<String, String> entry : runMetrics.entrySet()) {
                String existingValue = this.mRunMetrics.get(entry.getKey());
                String combinedValue = this.combineValues(existingValue, entry.getValue());
                this.mRunMetrics.put(entry.getKey(), combinedValue);
            }
        } else {
            this.mRunMetrics.putAll(runMetrics);
        }
        this.mRunProtoMetrics.putAll(TfMetricProtoUtil.upgradeConvert(runMetrics));
        this.mElapsedTime += elapsedTime;
        this.mIsRunComplete = true;
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        this.testRunEnded(elapsedTime, TfMetricProtoUtil.compatibleConvert(runMetrics));
        this.mRunProtoMetrics.putAll(runMetrics);
    }

    private String combineValues(String existingValue, String newValue) {
        if (existingValue != null) {
            try {
                long existingLong = Long.parseLong(existingValue);
                long newLong = Long.parseLong(newValue);
                return Long.toString(existingLong + newLong);
            }
            catch (NumberFormatException existingLong) {
                try {
                    double existingDouble = Double.parseDouble(existingValue);
                    double newDouble = Double.parseDouble(newValue);
                    return Double.toString(existingDouble + newDouble);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return newValue;
    }

    public String getTextSummary() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Total tests %d, ", this.getNumTests()));
        for (TestResult.TestStatus status : TestResult.TestStatus.values()) {
            int count = this.getNumTestsInState(status);
            if (count <= 0) continue;
            builder.append(String.format("%s %d, ", status.toString().toLowerCase(), count));
        }
        return builder.toString();
    }

    public void testLogSaved(String dataName, LogFile logFile) {
        if (this.mCurrentTestResult != null) {
            this.mCurrentTestResult.addLoggedFile(dataName, logFile);
        } else {
            this.mRunLoggedFiles.put(dataName, logFile);
        }
    }

    public MultiMap<String, LogFile> getRunLoggedFiles() {
        return new MultiMap<String, LogFile>(this.mRunLoggedFiles);
    }

    public static TestRunResult merge(List<TestRunResult> testRunResults) {
        return TestRunResult.merge(testRunResults, MergeStrategy.ONE_TESTCASE_PASS_IS_PASS);
    }

    public static TestRunResult merge(List<TestRunResult> testRunResults, MergeStrategy strategy) {
        if (testRunResults.isEmpty()) {
            return null;
        }
        if (MergeStrategy.NO_MERGE.equals((Object)strategy)) {
            throw new IllegalArgumentException("TestRunResult#merge cannot be called with NO_MERGE strategy.");
        }
        if (testRunResults.size() == 1) {
            return testRunResults.get(0);
        }
        TestRunResult finalRunResult = new TestRunResult();
        String testRunName = testRunResults.get(0).getName();
        HashMap<String, String> finalRunMetrics = new HashMap<String, String>();
        HashMap<String, MetricMeasurement.Metric> finalRunProtoMetrics = new HashMap<String, MetricMeasurement.Metric>();
        MultiMap<String, LogFile> finalRunLoggedFiles = new MultiMap<String, LogFile>();
        LinkedHashMap<TestDescription, List<TestResult>> testResultsAttempts = new LinkedHashMap<TestDescription, List<TestResult>>();
        boolean isAtLeastOneCompleted = false;
        boolean areAllCompleted = true;
        ArrayList<FailureDescription> runErrors = new ArrayList<FailureDescription>();
        boolean atLeastOneFailure = false;
        boolean allFailure = true;
        long elapsedTime = 0L;
        int maxExpectedTestCount = 0;
        for (TestRunResult eachRunResult : testRunResults) {
            if (!testRunName.equals(eachRunResult.getName())) {
                throw new IllegalArgumentException(String.format("Unabled to merge TestRunResults: The run results names are different (%s, %s)", testRunName, eachRunResult.getName()));
            }
            elapsedTime += eachRunResult.getElapsedTime();
            if (eachRunResult.isRunFailure()) {
                atLeastOneFailure = true;
                FailureDescription currentFailure = eachRunResult.getRunFailureDescription();
                if (currentFailure instanceof MultiFailureDescription) {
                    runErrors.addAll(((MultiFailureDescription)currentFailure).getFailures());
                } else {
                    runErrors.add(currentFailure);
                }
            } else {
                allFailure = false;
            }
            if (eachRunResult.isRunComplete()) {
                isAtLeastOneCompleted = true;
            } else {
                areAllCompleted = false;
            }
            maxExpectedTestCount = Math.max(maxExpectedTestCount, eachRunResult.getExpectedTestCount());
            finalRunMetrics.putAll(eachRunResult.getRunMetrics());
            finalRunProtoMetrics.putAll(eachRunResult.getRunProtoMetrics());
            finalRunLoggedFiles.putAll(eachRunResult.getRunLoggedFiles());
            for (Map.Entry<TestDescription, TestResult> testResultEntry : eachRunResult.getTestResults().entrySet()) {
                if (!testResultsAttempts.containsKey(testResultEntry.getKey())) {
                    testResultsAttempts.put(testResultEntry.getKey(), new ArrayList());
                }
                List results = (List)testResultsAttempts.get(testResultEntry.getKey());
                results.add(testResultEntry.getValue());
            }
        }
        finalRunResult.mTestResults = TestRunResult.evaluateTestCases(testResultsAttempts, strategy);
        boolean isRunFailure = TestRunResult.isRunFailed(atLeastOneFailure, allFailure, strategy);
        if (isRunFailure) {
            finalRunResult.mRunFailureError = runErrors.size() == 1 ? (FailureDescription)runErrors.get(0) : new MultiFailureDescription(runErrors);
        }
        finalRunResult.mIsRunComplete = TestRunResult.isRunComplete(isAtLeastOneCompleted, areAllCompleted, strategy);
        finalRunResult.mTestRunName = testRunName;
        finalRunResult.mRunMetrics = finalRunMetrics;
        finalRunResult.mRunProtoMetrics = finalRunProtoMetrics;
        finalRunResult.mRunLoggedFiles = finalRunLoggedFiles;
        finalRunResult.mExpectedTestCount = maxExpectedTestCount;
        finalRunResult.mElapsedTime = elapsedTime;
        return finalRunResult;
    }

    private static Map<TestDescription, TestResult> evaluateTestCases(Map<TestDescription, List<TestResult>> results, MergeStrategy strategy) {
        LinkedHashMap<TestDescription, TestResult> finalTestResults = new LinkedHashMap<TestDescription, TestResult>();
        for (TestDescription description : results.keySet()) {
            List<TestResult> attemptRes = results.get(description);
            TestResult aggResult = TestResult.merge(attemptRes, strategy);
            finalTestResults.put(description, aggResult);
        }
        return finalTestResults;
    }

    private static boolean isRunFailed(boolean atLeastOneFailure, boolean allFailures, MergeStrategy strategy) {
        switch (strategy) {
            case ANY_PASS_IS_PASS: 
            case ONE_TESTRUN_PASS_IS_PASS: {
                return allFailures;
            }
        }
        return atLeastOneFailure;
    }
}

