/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.InvocationToJUnitResultForwarder;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import java.util.HashMap;
import junit.textui.ResultPrinter;

@OptionClass(alias="stdout")
public class TextResultReporter
extends InvocationToJUnitResultForwarder
implements ITestInvocationListener,
ILogSaverListener {
    public TextResultReporter() {
        super(new ResultPrinter(System.out));
    }

    @Override
    public void testFailed(TestDescription testId, String trace) {
        super.testFailed(testId, trace);
    }

    @Override
    public void testAssumptionFailure(TestDescription testId, String trace) {
        super.testAssumptionFailure(testId, trace);
    }

    @Override
    public void testEnded(TestDescription testId, HashMap<String, MetricMeasurement.Metric> metrics) {
        super.testEnded(testId, metrics);
        if (!metrics.isEmpty()) {
            ResultPrinter printer = (ResultPrinter)this.getJUnitListener();
            printer.getWriter().format("\n%s metrics: %s\n", testId, metrics);
        }
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> metrics) {
        super.testRunEnded(elapsedTime, metrics);
        if (!metrics.isEmpty()) {
            ResultPrinter printer = (ResultPrinter)this.getJUnitListener();
            printer.getWriter().format("\nMetrics: %s\n", metrics);
        }
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "Saved %s log to %s", dataName, logFile.getPath());
    }
}

