/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.kxml2.io.KXmlSerializer;

@OptionClass(alias="xml")
public class XmlResultReporter
extends CollectingTestListener
implements ILogSaverListener {
    private static final String TEST_RESULT_FILE_PREFIX = "test_result_";
    private static final String TESTSUITE = "testsuite";
    private static final String TESTCASE = "testcase";
    private static final String ERROR = "error";
    private static final String FAILURE = "failure";
    private static final String IGNORED = "ignored";
    private static final String ASSUMPTION_FAILURE = "assumption_failure";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_ERRORS = "errors";
    private static final String ATTR_FAILURES = "failures";
    private static final String ATTR_TESTS = "tests";
    private static final String PROPERTIES = "properties";
    private static final String ATTR_CLASSNAME = "classname";
    private static final String TIMESTAMP = "timestamp";
    private static final String HOSTNAME = "hostname";
    private static final String NS = null;
    private ILogSaver mLogSaver;

    @Override
    public void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        this.generateSummary(elapsedTime);
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        super.testFailed(test, trace);
        LogUtil.CLog.d("%s : %s", test, trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSummary(long elapsedTime) {
        block5: {
            String timestamp = this.getTimestamp();
            ByteArrayOutputStream outputStream = null;
            ByteArrayInputStream inputStream = null;
            try {
                outputStream = this.createOutputStream();
                KXmlSerializer serializer = new KXmlSerializer();
                serializer.setOutput(outputStream, "UTF-8");
                serializer.startDocument("UTF-8", null);
                serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                this.printTestResults(serializer, timestamp, elapsedTime);
                serializer.endDocument();
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                LogFile log = this.mLogSaver.saveLogData(TEST_RESULT_FILE_PREFIX, LogDataType.XML, inputStream);
                LogUtil.CLog.i("XML test result file generated at %s. Total tests %d, Failed %d", log.getPath(), this.getNumTotalTests(), this.getNumAllFailedTests());
                StreamUtil.close(outputStream);
            }
            catch (IOException e) {
                LogUtil.CLog.e("Failed to generate report data");
                break block5;
            }
            finally {
                StreamUtil.close(outputStream);
                StreamUtil.close(inputStream);
            }
            StreamUtil.close(inputStream);
        }
    }

    String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone gmt = TimeZone.getTimeZone("UTC");
        dateFormat.setTimeZone(gmt);
        dateFormat.setLenient(true);
        String timestamp = dateFormat.format(new Date());
        return timestamp;
    }

    ByteArrayOutputStream createOutputStream() {
        return new ByteArrayOutputStream();
    }

    void printTestResults(KXmlSerializer serializer, String timestamp, long elapsedTime) throws IOException {
        serializer.startTag(NS, TESTSUITE);
        serializer.attribute(NS, ATTR_NAME, this.getInvocationContext().getTestTag());
        serializer.attribute(NS, ATTR_TESTS, Integer.toString(this.getNumTotalTests()));
        serializer.attribute(NS, ATTR_FAILURES, Integer.toString(this.getNumTestsInState(TestResult.TestStatus.FAILURE)));
        serializer.attribute(NS, ATTR_ERRORS, "0");
        serializer.attribute(NS, ATTR_TIME, Long.toString(elapsedTime));
        serializer.attribute(NS, TIMESTAMP, timestamp);
        serializer.attribute(NS, HOSTNAME, "localhost");
        serializer.startTag(NS, PROPERTIES);
        serializer.endTag(NS, PROPERTIES);
        for (TestRunResult runResult : this.getMergedTestRunResults()) {
            Map<TestDescription, TestResult> testResults = runResult.getTestResults();
            for (Map.Entry<TestDescription, TestResult> testEntry : testResults.entrySet()) {
                this.print(serializer, testEntry.getKey(), testEntry.getValue());
            }
        }
        serializer.endTag(NS, TESTSUITE);
    }

    void print(KXmlSerializer serializer, TestDescription testId, TestResult testResult) throws IOException {
        serializer.startTag(NS, TESTCASE);
        serializer.attribute(NS, ATTR_NAME, testId.getTestName());
        serializer.attribute(NS, ATTR_CLASSNAME, testId.getClassName());
        serializer.attribute(NS, ATTR_TIME, "0");
        if (TestResult.TestStatus.IGNORED.equals((Object)testResult.getStatus())) {
            String result = IGNORED;
            serializer.startTag(NS, result);
            serializer.endTag(NS, result);
        } else if (!TestResult.TestStatus.PASSED.equals((Object)testResult.getStatus())) {
            String result = ERROR;
            if (TestResult.TestStatus.FAILURE.equals((Object)testResult.getStatus())) {
                result = FAILURE;
            } else if (TestResult.TestStatus.ASSUMPTION_FAILURE.equals((Object)testResult.getStatus())) {
                result = ASSUMPTION_FAILURE;
            }
            serializer.startTag(NS, result);
            String stackText = this.sanitize(testResult.getStackTrace());
            serializer.text(stackText);
            serializer.endTag(NS, result);
        }
        serializer.endTag(NS, TESTCASE);
    }

    private String sanitize(String text) {
        return text == null ? "" : text.replace("\u0000", "<\\0>");
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        LogUtil.CLog.i("Saved %s log to %s", dataName, logFile.getPath());
    }

    @Override
    public void setLogSaver(ILogSaver logSaver) {
        this.mLogSaver = logSaver;
    }
}

