/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.ddmlib;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestLifeCycleReceiver;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class TestRunToTestInvocationForwarder
implements ITestRunListener {
    private static final Set<String> INVALID_METHODS = ImmutableSet.of("null", "initializationError");
    public static final String ERROR_MESSAGE_FORMAT = "Runner reported an invalid method '%s' (%s). Something went wrong, Skipping its reporting.";
    private Collection<ITestLifeCycleReceiver> mListeners;
    private Long mStartTime;
    private TestIdentifier mInvalidMethod = null;
    private boolean mNullMethodIsIgnored = false;
    private String mNullStack = null;

    public TestRunToTestInvocationForwarder(Collection<ITestLifeCycleReceiver> listeners) {
        this.mListeners = listeners;
        this.mStartTime = null;
    }

    public TestRunToTestInvocationForwarder(ITestLifeCycleReceiver listener) {
        this(Arrays.asList(listener));
    }

    @Override
    public void testStarted(TestIdentifier testId) {
        if (INVALID_METHODS.contains(testId.getTestName())) {
            this.mInvalidMethod = testId;
            return;
        }
        this.mNullMethodIsIgnored = false;
        this.mInvalidMethod = null;
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testStarted(TestDescription.createFromTestIdentifier(testId));
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testStarted", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }

    @Override
    public void testAssumptionFailure(TestIdentifier testId, String trace) {
        if (this.mInvalidMethod != null && this.mInvalidMethod.equals(testId)) {
            return;
        }
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testAssumptionFailure(TestDescription.createFromTestIdentifier(testId), trace);
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testAssumptionFailure", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }

    @Override
    public void testFailed(TestIdentifier testId, String trace) {
        if (this.mInvalidMethod != null && this.mInvalidMethod.equals(testId)) {
            this.mNullStack = trace;
            return;
        }
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testFailed(TestDescription.createFromTestIdentifier(testId), FailureDescription.create(trace));
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testFailed", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }

    @Override
    public void testIgnored(TestIdentifier testId) {
        if (this.mInvalidMethod != null && this.mInvalidMethod.equals(testId)) {
            this.mNullMethodIsIgnored = true;
            return;
        }
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testIgnored(TestDescription.createFromTestIdentifier(testId));
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testIgnored", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }

    @Override
    public void testEnded(TestIdentifier testId, Map<String, String> testMetrics) {
        if (this.mInvalidMethod != null && this.mInvalidMethod.equals(testId)) {
            if (this.mNullMethodIsIgnored) {
                LogUtil.CLog.d("ignored null method reported, most likely an @ignored class");
                for (ITestLifeCycleReceiver listener : this.mListeners) {
                    listener.testStarted(TestDescription.createFromTestIdentifier(testId));
                    listener.testIgnored(TestDescription.createFromTestIdentifier(testId));
                }
            } else {
                String message2 = String.format(ERROR_MESSAGE_FORMAT, this.mInvalidMethod.getTestName(), this.mInvalidMethod);
                if (this.mNullStack != null) {
                    message2 = String.format("%s Stack:%s", message2, this.mNullStack);
                }
                FailureDescription failure = FailureDescription.create(message2, TestRecordProto.FailureStatus.TEST_FAILURE).setErrorIdentifier(TestErrorIdentifier.INSTRUMENTATION_NULL_METHOD);
                for (ITestLifeCycleReceiver listener : this.mListeners) {
                    listener.testRunFailed(failure);
                }
                this.mNullStack = null;
                return;
            }
        }
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testEnded(TestDescription.createFromTestIdentifier(testId), TfMetricProtoUtil.upgradeConvert(testMetrics));
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testEnded", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }

    @Override
    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.mStartTime != null) {
            elapsedTime = System.currentTimeMillis() - this.mStartTime;
        }
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testRunEnded(elapsedTime, TfMetricProtoUtil.upgradeConvert(runMetrics));
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testRunEnded", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }

    @Override
    public void testRunFailed(String failure) {
        FailureDescription failureDescription = FailureDescription.create(failure);
        failureDescription.setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE);
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testRunFailed(failureDescription);
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testRunFailed", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        this.mStartTime = System.currentTimeMillis();
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testRunStarted(runName, testCount);
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testRunStarted", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }

    @Override
    @Deprecated
    public void testRunStopped(long elapsedTime) {
        for (ITestLifeCycleReceiver listener : this.mListeners) {
            try {
                listener.testRunStopped(elapsedTime);
            }
            catch (RuntimeException any) {
                LogUtil.CLog.e("RuntimeException when invoking %s#testRunStopped", listener.getClass().getName());
                LogUtil.CLog.e(any);
            }
        }
    }
}

