/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.proto;

import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.proto.ProtoResultReporter;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileProtoResultReporter
extends ProtoResultReporter {
    public static final String USE_DELIMITED_API = "use-delimited-api";
    @Option(name="use-delimited-api", description="Use Proto.useDelimitedApi to save proto, otherwise use default api.")
    private boolean mUseDelimitedApi = true;
    public static final String PROTO_OUTPUT_FILE = "proto-output-file";
    @Option(name="proto-output-file", description="File where the proto output will be saved. If unset, reporter will be inop.")
    private File mOutputFile = null;
    public static final String PERIODIC_PROTO_WRITING_OPTION = "periodic-proto-writing";
    @Option(name="periodic-proto-writing", description="Whether or not to output intermediate proto per module following a numbered sequence.")
    private boolean mPeriodicWriting = false;
    private int mIndex = 0;

    @Override
    public void processStartInvocation(TestRecordProto.TestRecord invocationStartRecord, IInvocationContext invocationContext) {
        this.writeProto(invocationStartRecord);
    }

    @Override
    public void processTestModuleEnd(TestRecordProto.TestRecord moduleRecord) {
        this.writeProto(moduleRecord);
    }

    @Override
    public void processTestRunEnded(TestRecordProto.TestRecord runRecord, boolean moduleInProgress) {
        if (!moduleInProgress) {
            this.writeProto(runRecord);
        }
    }

    @Override
    public void processFinalProto(TestRecordProto.TestRecord finalRecord) {
        this.writeProto(finalRecord);
    }

    @Override
    protected TestRecordProto.ChildReference createModuleChildReference(TestRecordProto.TestRecord record) {
        if (this.isPeriodicWriting()) {
            return null;
        }
        return super.createModuleChildReference(record);
    }

    public void setFileOutput(File output) {
        this.mOutputFile = output;
    }

    public void setPeriodicWriting(boolean enabled) {
        this.mPeriodicWriting = enabled;
    }

    public boolean isPeriodicWriting() {
        return this.mPeriodicWriting;
    }

    private void writeProto(TestRecordProto.TestRecord record) {
        if (this.mOutputFile == null) {
            return;
        }
        FileOutputStream output = null;
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile("tmp-proto", "", this.mOutputFile.getParentFile());
            File outputFile = this.mOutputFile;
            if (this.mPeriodicWriting) {
                outputFile = new File(this.mOutputFile.getAbsolutePath() + this.mIndex);
            }
            output = new FileOutputStream(tmpFile);
            if (this.mUseDelimitedApi) {
                record.writeDelimitedTo(output);
            } else {
                record.writeTo(output);
            }
            if (this.mPeriodicWriting) {
                this.nextOutputFile();
            }
            tmpFile.renameTo(outputFile);
        }
        catch (IOException e) {
            try {
                LogUtil.CLog.e(e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.close(output);
                throw throwable;
            }
        }
        StreamUtil.close(output);
    }

    private void nextOutputFile() {
        ++this.mIndex;
    }

    public void setOutputFile(File outputFile) {
        this.mOutputFile = outputFile;
    }

    public File getOutputFile() {
        return this.mOutputFile;
    }

    public void setDelimitedOutput(boolean delimitedOutput) {
        this.mUseDelimitedApi = delimitedOutput;
    }
}

