/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.proto;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.internal.protobuf.Any;
import com.android.tradefed.internal.protobuf.InvalidProtocolBufferException;
import com.android.tradefed.internal.protobuf.Timestamp;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.logger.TfObjectTracker;
import com.android.tradefed.invoker.proto.InvocationContext;
import com.android.tradefed.invoker.tracing.TracingLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ActionInProgress;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.proto.LogFileProto;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.SerializationUtil;
import com.android.tradefed.util.proto.TestRecordProtoUtil;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ProtoResultParser {
    private ITestInvocationListener mListener;
    private String mCurrentRunName = null;
    private TestDescription mCurrentTestCase = null;
    private boolean mReportInvocation = false;
    private boolean mReportLogs = true;
    private String mFilePrefix;
    private IInvocationContext mMainContext;
    private boolean mQuietParsing = true;
    private boolean mSkipParsingAccounting = false;
    private boolean mInvocationStarted = false;
    private boolean mInvocationFailed = false;
    private boolean mInvocationEnded = false;
    private boolean mFirstModule = true;
    private String mModuleInProgress = null;
    private IInvocationContext mModuleContext = null;
    private boolean mMergeInvocationContext = true;

    public ProtoResultParser(ITestInvocationListener listener, IInvocationContext context, boolean reportInvocation) {
        this(listener, context, reportInvocation, "subprocess-");
    }

    public ProtoResultParser(ITestInvocationListener listener, IInvocationContext context, boolean reportInvocation, String prefixForFile) {
        this.mListener = listener;
        this.mMainContext = context;
        this.mReportInvocation = reportInvocation;
        this.mFilePrefix = prefixForFile;
    }

    public void setQuiet(boolean quiet) {
        this.mQuietParsing = quiet;
    }

    public void setSkipParsingAccounting(boolean skip) {
        this.mSkipParsingAccounting = skip;
    }

    public void setReportLogs(boolean reportLogs) {
        this.mReportLogs = reportLogs;
    }

    public boolean setMergeInvocationContext(boolean enabled) {
        boolean previousContext = this.mMergeInvocationContext;
        this.mMergeInvocationContext = enabled;
        return previousContext;
    }

    public void processFinalizedProto(TestRecordProto.TestRecord finalProto) {
        if (!finalProto.getParentTestRecordId().isEmpty()) {
            throw new IllegalArgumentException("processFinalizedProto only expect a root proto.");
        }
        this.handleInvocationStart(finalProto);
        this.evalChildrenProto(finalProto.getChildrenList(), false);
        this.handleInvocationEnded(finalProto);
    }

    public TestLevel processNewProto(TestRecordProto.TestRecord currentProto) {
        if (currentProto.getParentTestRecordId().isEmpty()) {
            this.handleRootProto(currentProto);
            return TestLevel.INVOCATION;
        }
        if (currentProto.hasDescription()) {
            this.handleModuleProto(currentProto);
            return TestLevel.MODULE;
        }
        if (this.mCurrentRunName == null || currentProto.getTestRecordId().equals(this.mCurrentRunName)) {
            this.handleTestRun(currentProto);
            return TestLevel.TEST_RUN;
        }
        this.handleTestCase(currentProto);
        return TestLevel.TEST_CASE;
    }

    public void processFileProto(File protoFile) throws IOException {
        TestRecordProto.TestRecord record = null;
        try {
            record = TestRecordProtoUtil.readFromFile(protoFile);
        }
        catch (InvalidProtocolBufferException e) {
            try (FileInputStreamSource protoFail = new FileInputStreamSource(protoFile, true);){
                this.mListener.testLog("failed-result-protobuf", LogDataType.PB, protoFail);
            }
            throw e;
        }
        if (!this.mInvocationStarted) {
            this.handleInvocationStart(record);
            this.mInvocationStarted = true;
        } else if (record.getParentTestRecordId().isEmpty()) {
            this.handleInvocationEnded(record);
        } else {
            this.evalProto(record, false);
        }
    }

    public boolean invocationEndedReached() {
        return this.mInvocationEnded;
    }

    public String getModuleInProgress() {
        return this.mModuleInProgress;
    }

    public boolean hasInvocationFailed() {
        return this.mInvocationFailed;
    }

    public void completeModuleEvents() {
        FailureDescription failure;
        if (this.mCurrentRunName == null && this.getModuleInProgress() != null) {
            this.mListener.testRunStarted(this.getModuleInProgress(), 0);
        }
        if (this.mCurrentTestCase != null) {
            failure = FailureDescription.create("Run was interrupted after starting, results are incomplete.");
            this.mListener.testFailed(this.mCurrentTestCase, failure);
            this.mListener.testEnded(this.mCurrentTestCase, new HashMap<String, MetricMeasurement.Metric>());
        }
        if (this.getModuleInProgress() != null || this.mCurrentRunName != null) {
            failure = FailureDescription.create("Module was interrupted after starting, results are incomplete.", TestRecordProto.FailureStatus.INFRA_FAILURE);
            this.mListener.testRunFailed(failure);
            this.mListener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
            this.mCurrentRunName = null;
        }
        if (this.getModuleInProgress() != null) {
            this.mListener.testModuleEnded();
        }
    }

    private void evalChildrenProto(List<TestRecordProto.ChildReference> children, boolean isInRun) {
        for (TestRecordProto.ChildReference child : children) {
            TestRecordProto.TestRecord childProto = child.getInlineTestRecord();
            this.evalProto(childProto, isInRun);
        }
    }

    private void evalProto(TestRecordProto.TestRecord childProto, boolean isInRun) {
        if (isInRun) {
            String[] info = childProto.getTestRecordId().split("#");
            TestDescription description = new TestDescription(info[0], info[1]);
            this.mListener.testStarted(description, this.timeStampToMillis(childProto.getStartTime()));
            this.handleTestCaseEnd(description, childProto);
        } else {
            boolean inRun = false;
            if (childProto.hasDescription()) {
                this.handleModuleStart(childProto);
            } else {
                this.handleTestRunStart(childProto);
                inRun = true;
            }
            this.evalChildrenProto(childProto.getChildrenList(), inRun);
            if (childProto.hasDescription()) {
                this.handleModuleProto(childProto);
            } else {
                this.handleTestRunEnd(childProto);
            }
        }
    }

    private void handleRootProto(TestRecordProto.TestRecord rootProto) {
        if (rootProto.hasEndTime()) {
            this.handleInvocationEnded(rootProto);
        } else {
            this.handleInvocationStart(rootProto);
        }
    }

    private void handleInvocationStart(TestRecordProto.TestRecord startInvocationProto) {
        InvocationContext receivedContext;
        Any anyDescription = startInvocationProto.getDescription();
        if (!anyDescription.is(InvocationContext.Context.class)) {
            throw new RuntimeException("Expected Any description of type Context");
        }
        try {
            receivedContext = InvocationContext.fromProto(anyDescription.unpack(InvocationContext.Context.class));
            this.mergeInvocationContext(this.mMainContext, receivedContext);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        this.log("Invocation started proto", new Object[0]);
        if (!this.mReportInvocation) {
            LogUtil.CLog.d("Skipping invocation start reporting.");
            return;
        }
        this.mListener.invocationStarted(receivedContext);
    }

    private void handleInvocationEnded(TestRecordProto.TestRecord endInvocationProto) {
        this.handleLogs(endInvocationProto);
        if (this.mInvocationEnded) {
            LogUtil.CLog.d("Re-entry in invocationEnded, most likely for subprocess final logs.");
            return;
        }
        Any anyDescription = endInvocationProto.getDescription();
        if (!anyDescription.is(InvocationContext.Context.class)) {
            throw new RuntimeException(String.format("Expected Any description of type Context, was %s", anyDescription));
        }
        try {
            InvocationContext context = InvocationContext.fromProto(anyDescription.unpack(InvocationContext.Context.class));
            this.mergeInvocationContext(this.mMainContext, context);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        if (endInvocationProto.hasDebugInfo()) {
            String errorType;
            TestRecordProto.DebugInfo debugInfo = endInvocationProto.getDebugInfo();
            FailureDescription failure = FailureDescription.create(debugInfo.getErrorMessage());
            if (!TestRecordProto.FailureStatus.UNSET.equals(endInvocationProto.getDebugInfo().getFailureStatus())) {
                failure.setFailureStatus(debugInfo.getFailureStatus());
            }
            this.parseDebugInfoContext(endInvocationProto.getDebugInfo(), failure);
            if (endInvocationProto.getDebugInfo().hasDebugInfoContext() && !Strings.isNullOrEmpty(errorType = endInvocationProto.getDebugInfo().getDebugInfoContext().getErrorType())) {
                try {
                    Throwable invocationError = (Throwable)SerializationUtil.deserialize(errorType);
                    failure.setCause(invocationError);
                    if (invocationError instanceof OutOfMemoryError) {
                        failure.setErrorIdentifier(InfraErrorIdentifier.OUT_OF_MEMORY_ERROR);
                    }
                }
                catch (IOException e) {
                    LogUtil.CLog.e("Failed to deserialize the invocation exception:");
                    LogUtil.CLog.e(e);
                    failure.setCause(new RuntimeException(failure.getErrorMessage()));
                }
            }
            LogUtil.CLog.d("Invocation failed with: %s", failure);
            this.mListener.invocationFailed(failure);
            this.mInvocationFailed = true;
        }
        this.log("Invocation ended proto", new Object[0]);
        this.mInvocationEnded = true;
        if (!this.mReportInvocation) {
            LogUtil.CLog.d("Skipping invocation ended reporting.");
            return;
        }
        long elapsedTime = this.timeStampToMillis(endInvocationProto.getEndTime()) - this.timeStampToMillis(endInvocationProto.getStartTime());
        this.mListener.invocationEnded(elapsedTime);
    }

    private void handleModuleProto(TestRecordProto.TestRecord moduleProto) {
        if (moduleProto.hasEndTime()) {
            this.handleModuleEnded(moduleProto);
        } else {
            this.handleModuleStart(moduleProto);
        }
    }

    private void handleModuleStart(TestRecordProto.TestRecord moduleProto) {
        Any anyDescription = moduleProto.getDescription();
        if (!anyDescription.is(InvocationContext.Context.class)) {
            throw new RuntimeException("Expected Any description of type Context");
        }
        try {
            InvocationContext moduleContext = InvocationContext.fromProto(anyDescription.unpack(InvocationContext.Context.class));
            String message2 = "Test module started proto";
            if (moduleContext.getAttributes().containsKey("module-id")) {
                String moduleId = moduleContext.getAttributes().getUniqueMap().get("module-id");
                message2 = message2 + ": " + moduleId;
                this.mModuleInProgress = moduleId;
            }
            this.log(message2, new Object[0]);
            this.mModuleContext = moduleContext;
            this.mListener.testModuleStarted(moduleContext);
            if (this.mFirstModule) {
                this.mFirstModule = false;
                this.mergeBuildInfo(this.mMainContext, moduleContext);
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleModuleEnded(TestRecordProto.TestRecord moduleProto) {
        this.handleLogs(moduleProto);
        this.log("Test module ended proto", new Object[0]);
        try {
            Any anyDescription = moduleProto.getDescription();
            InvocationContext moduleContext = InvocationContext.fromProto(anyDescription.unpack(InvocationContext.Context.class));
            this.mModuleContext.addInvocationAttributes(moduleContext.getAttributes());
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        this.mListener.testModuleEnded();
        this.mModuleInProgress = null;
        this.mModuleContext = null;
    }

    private void handleTestRun(TestRecordProto.TestRecord runProto) {
        if (runProto.hasEndTime()) {
            this.handleTestRunEnd(runProto);
            this.mCurrentRunName = null;
        } else {
            this.mCurrentRunName = runProto.getTestRecordId();
            this.handleTestRunStart(runProto);
        }
    }

    private void handleTestRunStart(TestRecordProto.TestRecord runProto) {
        String id = runProto.getTestRecordId();
        this.log("Test run started proto: %s. Expected tests: %s. Attempt: %s", id, runProto.getNumExpectedChildren(), runProto.getAttemptId());
        this.mListener.testRunStarted(id, (int)runProto.getNumExpectedChildren(), (int)runProto.getAttemptId(), this.timeStampToMillis(runProto.getStartTime()));
    }

    private void handleTestRunEnd(TestRecordProto.TestRecord runProto) {
        if (runProto.hasDebugInfo()) {
            TestRecordProto.DebugInfo debugInfo = runProto.getDebugInfo();
            FailureDescription failure = FailureDescription.create(debugInfo.getErrorMessage());
            if (!TestRecordProto.FailureStatus.UNSET.equals(runProto.getDebugInfo().getFailureStatus())) {
                failure.setFailureStatus(debugInfo.getFailureStatus());
            }
            this.parseDebugInfoContext(debugInfo, failure);
            this.mListener.testRunFailed(failure);
            this.log("Test run failure proto: %s", failure.toString());
        }
        this.handleLogs(runProto);
        this.log("Test run ended proto: %s", runProto.getTestRecordId());
        long elapsedTime = this.timeStampToMillis(runProto.getEndTime()) - this.timeStampToMillis(runProto.getStartTime());
        HashMap<String, MetricMeasurement.Metric> metrics = new HashMap<String, MetricMeasurement.Metric>(runProto.getMetricsMap());
        this.mListener.testRunEnded(elapsedTime, metrics);
    }

    private void handleTestCase(TestRecordProto.TestRecord testcaseProto) {
        String[] info = testcaseProto.getTestRecordId().split("#");
        TestDescription description = new TestDescription(info[0], info[1]);
        if (testcaseProto.hasEndTime()) {
            if (this.mCurrentTestCase == null) {
                this.log("Test case started proto: %s", description.toString());
                this.mListener.testStarted(description, this.timeStampToMillis(testcaseProto.getStartTime()));
            }
            this.handleTestCaseEnd(description, testcaseProto);
            this.mCurrentTestCase = null;
        } else {
            this.log("Test case started proto: %s", description.toString());
            this.mListener.testStarted(description, this.timeStampToMillis(testcaseProto.getStartTime()));
            this.mCurrentTestCase = description;
        }
    }

    private void handleTestCaseEnd(TestDescription description, TestRecordProto.TestRecord testcaseProto) {
        TestRecordProto.DebugInfo debugInfo = testcaseProto.getDebugInfo();
        switch (testcaseProto.getStatus()) {
            case FAIL: {
                FailureDescription failure = FailureDescription.create(testcaseProto.getDebugInfo().getErrorMessage());
                if (!TestRecordProto.FailureStatus.UNSET.equals(testcaseProto.getDebugInfo().getFailureStatus())) {
                    failure.setFailureStatus(testcaseProto.getDebugInfo().getFailureStatus());
                }
                this.parseDebugInfoContext(debugInfo, failure);
                this.mListener.testFailed(description, failure);
                this.log("Test case failed proto: %s - %s", description.toString(), failure.toString());
                break;
            }
            case ASSUMPTION_FAILURE: {
                FailureDescription assumption = FailureDescription.create(testcaseProto.getDebugInfo().getErrorMessage());
                if (!TestRecordProto.FailureStatus.UNSET.equals(testcaseProto.getDebugInfo().getFailureStatus())) {
                    assumption.setFailureStatus(testcaseProto.getDebugInfo().getFailureStatus());
                }
                this.parseDebugInfoContext(debugInfo, assumption);
                this.mListener.testAssumptionFailure(description, assumption);
                this.log("Test case assumption failure proto: %s - %s", description.toString(), testcaseProto.getDebugInfo().getTrace());
                break;
            }
            case IGNORED: {
                this.mListener.testIgnored(description);
                this.log("Test case ignored proto: %s", description.toString());
                break;
            }
            case PASS: {
                break;
            }
            default: {
                throw new RuntimeException(String.format("Received unexpected test status %s.", testcaseProto.getStatus()));
            }
        }
        this.handleLogs(testcaseProto);
        HashMap<String, MetricMeasurement.Metric> metrics = new HashMap<String, MetricMeasurement.Metric>(testcaseProto.getMetricsMap());
        this.log("Test case ended proto: %s", description.toString());
        this.mListener.testEnded(description, this.timeStampToMillis(testcaseProto.getEndTime()), metrics);
    }

    private long timeStampToMillis(Timestamp stamp) {
        return stamp.getSeconds() * 1000L + (long)stamp.getNanos() / 1000000L;
    }

    private void handleLogs(TestRecordProto.TestRecord proto) {
        if (!(this.mListener instanceof ILogSaverListener)) {
            return;
        }
        ILogSaverListener logger = (ILogSaverListener)this.mListener;
        for (Map.Entry<String, Any> entry : proto.getArtifactsMap().entrySet()) {
            try {
                LogFileProto.LogFileInfo info = entry.getValue().unpack(LogFileProto.LogFileInfo.class);
                LogDataType dataType = null;
                try {
                    dataType = LogDataType.valueOf(info.getLogType());
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    dataType = LogDataType.TEXT;
                }
                LogFile file2 = new LogFile(info.getPath(), info.getUrl(), info.getIsCompressed(), dataType, info.getSize());
                if (Strings.isNullOrEmpty(file2.getPath())) {
                    LogUtil.CLog.e("Log '%s' was registered but without a path.", entry.getKey());
                    continue;
                }
                File path = new File(file2.getPath());
                if (Strings.isNullOrEmpty(file2.getUrl()) && path.exists()) {
                    LogDataType type = file2.getType();
                    if (this.mReportLogs) {
                        try (FileInputStreamSource source = new FileInputStreamSource(path);){
                            this.log("Logging %s [type: %s]from subprocess: %s ", new Object[]{entry.getKey(), type, file2.getPath()});
                            logger.testLog(this.mFilePrefix + entry.getKey(), type, source);
                        }
                    }
                    if (!entry.getKey().startsWith("invocation-trace") || !LogDataType.PERFETTO.equals((Object)type)) continue;
                    LogUtil.CLog.d("Log the subprocess trace");
                    TracingLogger.getActiveTrace().addSubprocessTrace(path);
                    FileUtil.deleteFile(path);
                    continue;
                }
                if (entry.getKey().startsWith("invocation-trace") && LogDataType.PERFETTO.equals((Object)file2.getType()) && path.exists()) {
                    LogUtil.CLog.d("Log the subprocess trace");
                    TracingLogger.getActiveTrace().addSubprocessTrace(path);
                }
                if (!this.mReportLogs) continue;
                this.log("Logging %s [type: %s] from subprocess. url: %s, path: %s [exists: %s]", new Object[]{entry.getKey(), file2.getType(), file2.getUrl(), file2.getPath(), path.exists()});
                logger.logAssociation(this.mFilePrefix + entry.getKey(), file2);
            }
            catch (InvalidProtocolBufferException e) {
                LogUtil.CLog.e("Couldn't unpack %s as a LogFileInfo", entry.getKey());
                LogUtil.CLog.e(e);
            }
        }
    }

    private void mergeBuildInfo(IInvocationContext receiverContext, IInvocationContext endInvocationContext) {
        if (receiverContext == null) {
            return;
        }
        for (IBuildInfo info : receiverContext.getBuildInfos()) {
            String name = receiverContext.getBuildInfoName(info);
            IBuildInfo endInvocationInfo = endInvocationContext.getBuildInfo(name);
            if (endInvocationInfo == null) {
                LogUtil.CLog.e("No build info named: %s", name);
                continue;
            }
            info.addBuildAttributes(endInvocationInfo.getBuildAttributes());
        }
    }

    private void mergeInvocationContext(IInvocationContext receiverContext, IInvocationContext endInvocationContext) {
        if (!this.mMergeInvocationContext) {
            LogUtil.CLog.d("Skipping merging invocation context");
            return;
        }
        if (receiverContext == null) {
            return;
        }
        this.mergeBuildInfo(receiverContext, endInvocationContext);
        try {
            Method unlock = InvocationContext.class.getDeclaredMethod("unlock", new Class[0]);
            unlock.setAccessible(true);
            unlock.invoke((Object)receiverContext, new Object[0]);
            unlock.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LogUtil.CLog.e("Couldn't unlock the main context. Skip copying attributes");
            return;
        }
        MultiMap<String, String> attributes = endInvocationContext.getAttributes();
        for (InvocationMetricLogger.InvocationGroupMetricKey invocationGroupMetricKey : InvocationMetricLogger.InvocationGroupMetricKey.values()) {
            HashSet<String> attKeys = new HashSet<String>(attributes.keySet());
            for (String attKey : attKeys) {
                if (!attKey.startsWith(invocationGroupMetricKey.toString() + ":") || attributes.get(attKey) == null) continue;
                List<String> values2 = attributes.get(attKey);
                attributes.remove(attKey);
                if (this.mSkipParsingAccounting) continue;
                String group = attKey.split(":", 2)[1];
                for (String val : values2) {
                    if (invocationGroupMetricKey.shouldAdd()) {
                        try {
                            InvocationMetricLogger.addInvocationMetrics(invocationGroupMetricKey, group, Long.parseLong(val));
                        }
                        catch (NumberFormatException e) {
                            LogUtil.CLog.d("Key %s doesn't have a number value, was: %s.", new Object[]{invocationGroupMetricKey, val});
                            InvocationMetricLogger.addInvocationMetrics(invocationGroupMetricKey, group, val);
                        }
                        continue;
                    }
                    InvocationMetricLogger.addInvocationMetrics(invocationGroupMetricKey, group, val);
                }
            }
        }
        for (Enum enum_ : InvocationMetricLogger.InvocationMetricKey.values()) {
            if (!attributes.containsKey(((InvocationMetricLogger.InvocationMetricKey)enum_).toString())) continue;
            List<String> values3 = attributes.get(((InvocationMetricLogger.InvocationMetricKey)enum_).toString());
            attributes.remove(((InvocationMetricLogger.InvocationMetricKey)enum_).toString());
            if (this.mSkipParsingAccounting || values3 == null) continue;
            for (String val : values3) {
                if (((InvocationMetricLogger.InvocationMetricKey)enum_).shouldAdd()) {
                    try {
                        InvocationMetricLogger.addInvocationMetrics((InvocationMetricLogger.InvocationMetricKey)enum_, Long.parseLong(val));
                    }
                    catch (NumberFormatException e) {
                        LogUtil.CLog.d("Key %s doesn't have a number value, was: %s.", enum_, val);
                        InvocationMetricLogger.addInvocationMetrics((InvocationMetricLogger.InvocationMetricKey)enum_, val);
                    }
                    continue;
                }
                InvocationMetricLogger.addInvocationMetrics((InvocationMetricLogger.InvocationMetricKey)enum_, val);
            }
        }
        if (attributes.containsKey("tf_objects_tracking")) {
            List<String> values4 = attributes.remove("tf_objects_tracking");
            if (!this.mSkipParsingAccounting) {
                for (String val : values4) {
                    for (String pair : Splitter.on(",").split(val)) {
                        if (!pair.contains("=")) continue;
                        String[] pairSplit = pair.split("=");
                        try {
                            TfObjectTracker.directCount(pairSplit[0], Long.parseLong(pairSplit[1]));
                        }
                        catch (NumberFormatException e) {
                            LogUtil.CLog.e(e);
                        }
                    }
                }
            }
        }
        LogUtil.CLog.d("Adding following properties: %s", attributes.entries());
        receiverContext.addInvocationAttributes(attributes);
    }

    private void log(String format, Object ... obj) {
        if (!this.mQuietParsing) {
            LogUtil.CLog.d(format, obj);
        }
    }

    private void parseDebugInfoContext(TestRecordProto.DebugInfo debugInfo, final FailureDescription failure) {
        if (!debugInfo.hasDebugInfoContext()) {
            return;
        }
        TestRecordProto.DebugInfoContext debugContext = debugInfo.getDebugInfoContext();
        if (!Strings.isNullOrEmpty(debugContext.getActionInProgress())) {
            try {
                ActionInProgress value = ActionInProgress.valueOf(debugContext.getActionInProgress());
                failure.setActionInProgress(value);
            }
            catch (IllegalArgumentException parseError) {
                LogUtil.CLog.e(parseError);
            }
        }
        if (!Strings.isNullOrEmpty(debugContext.getDebugHelpMessage())) {
            failure.setDebugHelpMessage(debugContext.getDebugHelpMessage());
        }
        if (!Strings.isNullOrEmpty(debugContext.getOrigin())) {
            failure.setOrigin(debugContext.getOrigin());
        }
        final String errorName = debugContext.getErrorName();
        final long errorCode = debugContext.getErrorCode();
        if (!Strings.isNullOrEmpty(errorName)) {
            ErrorIdentifier errorId = new ErrorIdentifier(){

                @Override
                public String name() {
                    return errorName;
                }

                @Override
                public long code() {
                    return errorCode;
                }

                @Override
                @Nonnull
                public TestRecordProto.FailureStatus status() {
                    TestRecordProto.FailureStatus status = failure.getFailureStatus();
                    return status == null ? TestRecordProto.FailureStatus.UNSET : status;
                }
            };
            failure.setErrorIdentifier(errorId);
        }
    }

    public static enum TestLevel {
        INVOCATION,
        MODULE,
        TEST_RUN,
        TEST_CASE;

    }
}

