/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.proto;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.error.HarnessException;
import com.android.tradefed.internal.protobuf.Any;
import com.android.tradefed.internal.protobuf.Timestamp;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.LogFileProto;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.result.retry.ISupportGranularResults;
import com.android.tradefed.util.SerializationUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import java.util.UUID;

@OptionClass(alias="proto-reporter")
public abstract class ProtoResultReporter
implements ITestInvocationListener,
ILogSaverListener,
ISupportGranularResults {
    @Option(name="enable-granular-attempts", description="Whether or not to allow this reporter receiving granular attempts. Feature flag.")
    private boolean mReportGranularResults = true;
    private Stack<TestRecordProto.TestRecord.Builder> mLatestChild;
    private TestRecordProto.TestRecord.Builder mInvocationRecordBuilder;
    private long mInvocationStartTime;
    private IInvocationContext mContext;
    private FailureDescription mInvocationFailureDescription = null;
    private boolean mModuleInProgress = false;
    private IInvocationContext mModuleContext;
    private boolean mInvocationEnded = false;
    private boolean mInlineRecordOfChildren = true;

    @Override
    public boolean supportGranularResults() {
        return this.mReportGranularResults;
    }

    public void setGranularResults(boolean granularResults) {
        this.mReportGranularResults = granularResults;
    }

    public void setInlineRecordOfChildren(boolean inline) {
        this.mInlineRecordOfChildren = inline;
    }

    public void processStartInvocation(TestRecordProto.TestRecord invocationStartRecord, IInvocationContext invocationContext) {
    }

    public void processFinalProto(TestRecordProto.TestRecord finalRecord) {
    }

    public void processTestModuleStarted(TestRecordProto.TestRecord moduleStartRecord) {
    }

    public void processTestModuleEnd(TestRecordProto.TestRecord moduleRecord) {
    }

    public void processTestRunStarted(TestRecordProto.TestRecord runStartedRecord) {
    }

    public void processTestRunEnded(TestRecordProto.TestRecord runRecord, boolean moduleInProgress) {
    }

    public void processTestCaseStarted(TestRecordProto.TestRecord testCaseStartedRecord) {
    }

    public void processTestCaseEnded(TestRecordProto.TestRecord testCaseRecord) {
    }

    public void processFinalInvocationLogs(TestRecordProto.TestRecord invocationLogs) {
    }

    @Override
    public final void invocationStarted(IInvocationContext context) {
        this.mLatestChild = new Stack();
        this.mInvocationRecordBuilder = TestRecordProto.TestRecord.newBuilder();
        this.mInvocationRecordBuilder.setTestRecordId(UUID.randomUUID().toString());
        this.mInvocationStartTime = System.currentTimeMillis();
        Timestamp startTime = this.createTimeStamp(this.mInvocationStartTime);
        this.mInvocationRecordBuilder.setStartTime(startTime);
        this.mInvocationRecordBuilder.setDescription(Any.pack(context.toProto()));
        this.mContext = context;
        this.mLatestChild.add(this.mInvocationRecordBuilder);
        TestRecordProto.TestRecord startInvocationProto = this.mInvocationRecordBuilder.build();
        try {
            this.processStartInvocation(startInvocationProto, context);
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to process invocation started:");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public void invocationFailed(Throwable cause) {
        this.mInvocationFailureDescription = FailureDescription.create(cause.getMessage()).setCause(cause);
        if (cause instanceof HarnessException) {
            this.mInvocationFailureDescription.setErrorIdentifier(((HarnessException)cause).getErrorId());
            this.mInvocationFailureDescription.setOrigin(((HarnessException)cause).getOrigin());
        }
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        this.mInvocationFailureDescription = failure;
    }

    @Override
    public final void invocationEnded(long elapsedTime) {
        if (this.mModuleInProgress) {
            this.testModuleEnded();
        }
        Timestamp endTime = this.createTimeStamp(this.mInvocationStartTime + elapsedTime);
        this.mInvocationRecordBuilder.setEndTime(endTime);
        this.mInvocationRecordBuilder.setDescription(Any.pack(this.mContext.toProto()));
        TestRecordProto.DebugInfo invocationFailure = this.handleInvocationFailure();
        if (invocationFailure != null) {
            this.mInvocationRecordBuilder.setDebugInfo(invocationFailure);
            this.mInvocationRecordBuilder.setStatus(TestRecordProto.TestStatus.FAIL);
        } else {
            this.mInvocationRecordBuilder.setStatus(TestRecordProto.TestStatus.PASS);
        }
        TestRecordProto.TestRecord record = this.mInvocationRecordBuilder.build();
        try {
            this.processFinalProto(record);
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to process invocation ended:");
            LogUtil.CLog.e(e);
        }
        this.mInvocationEnded = true;
    }

    @Override
    public final void testModuleStarted(IInvocationContext moduleContext) {
        if (this.mModuleInProgress) {
            this.testModuleEnded();
        }
        TestRecordProto.TestRecord.Builder moduleBuilder = TestRecordProto.TestRecord.newBuilder();
        moduleBuilder.setParentTestRecordId(this.mInvocationRecordBuilder.getTestRecordId());
        moduleBuilder.setTestRecordId(moduleContext.getAttributes().get("module-id").get(0));
        moduleBuilder.setStartTime(this.createTimeStamp(System.currentTimeMillis()));
        moduleBuilder.setDescription(Any.pack(moduleContext.toProto()));
        this.mLatestChild.add(moduleBuilder);
        this.mModuleInProgress = true;
        this.mModuleContext = moduleContext;
        try {
            this.processTestModuleStarted(moduleBuilder.build());
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to process invocation ended:");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public final void testModuleEnded() {
        TestRecordProto.TestRecord.Builder moduleBuilder = this.mLatestChild.pop();
        this.mModuleInProgress = false;
        moduleBuilder.setEndTime(this.createTimeStamp(System.currentTimeMillis()));
        moduleBuilder.setStatus(TestRecordProto.TestStatus.PASS);
        moduleBuilder.setDescription(Any.pack(this.mModuleContext.toProto()));
        TestRecordProto.TestRecord.Builder parentBuilder = this.mLatestChild.peek();
        this.mModuleContext = null;
        TestRecordProto.TestRecord moduleRecord = moduleBuilder.build();
        TestRecordProto.ChildReference moduleReference = this.createModuleChildReference(moduleRecord);
        if (moduleReference != null) {
            parentBuilder.addChildren(moduleReference);
        }
        try {
            this.processTestModuleEnd(moduleRecord);
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to process test module end:");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public final void testRunStarted(String runName, int testCount) {
        this.testRunStarted(runName, testCount, 0);
    }

    @Override
    public void testRunStarted(String runName, int testCount, int attemptNumber) {
        this.testRunStarted(runName, testCount, attemptNumber, System.currentTimeMillis());
    }

    @Override
    public void testRunStarted(String runName, int testCount, int attemptNumber, long startTime) {
        TestRecordProto.TestRecord.Builder runBuilder = TestRecordProto.TestRecord.newBuilder();
        TestRecordProto.TestRecord.Builder parent = this.mLatestChild.peek();
        runBuilder.setParentTestRecordId(parent.getTestRecordId());
        runBuilder.setTestRecordId(runName);
        runBuilder.setNumExpectedChildren(testCount);
        runBuilder.setStartTime(this.createTimeStamp(startTime));
        runBuilder.setAttemptId(attemptNumber);
        this.mLatestChild.add(runBuilder);
        try {
            this.processTestRunStarted(runBuilder.build());
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to process invocation ended:");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public final void testRunFailed(String errorMessage) {
        TestRecordProto.TestRecord.Builder current = this.mLatestChild.peek();
        TestRecordProto.DebugInfo.Builder debugBuilder = TestRecordProto.DebugInfo.newBuilder();
        debugBuilder.setErrorMessage(errorMessage);
        if (TestRecordProto.TestStatus.UNKNOWN.equals(current.getStatus())) {
            current.setDebugInfo(debugBuilder.build());
            current.setStatus(TestRecordProto.TestStatus.FAIL);
        } else {
            TestRecordProto.TestRecord.Builder test = this.mLatestChild.pop();
            TestRecordProto.TestRecord.Builder run = this.mLatestChild.peek();
            run.setDebugInfo(debugBuilder.build());
            run.setStatus(TestRecordProto.TestStatus.FAIL);
            this.mLatestChild.add(test);
        }
    }

    @Override
    public final void testRunFailed(FailureDescription failure) {
        TestRecordProto.TestRecord.Builder current = this.mLatestChild.peek();
        TestRecordProto.DebugInfo.Builder debugBuilder = TestRecordProto.DebugInfo.newBuilder();
        debugBuilder.setErrorMessage(failure.toString());
        if (failure.getFailureStatus() != null) {
            debugBuilder.setFailureStatus(failure.getFailureStatus());
        }
        TestRecordProto.DebugInfoContext.Builder debugContext = TestRecordProto.DebugInfoContext.newBuilder();
        if (failure.getActionInProgress() != null) {
            debugContext.setActionInProgress(failure.getActionInProgress().toString());
        }
        if (!Strings.isNullOrEmpty(failure.getDebugHelpMessage())) {
            debugContext.setDebugHelpMessage(failure.getDebugHelpMessage());
        }
        if (!Strings.isNullOrEmpty(failure.getOrigin())) {
            debugContext.setOrigin(failure.getOrigin());
        }
        if (failure.getErrorIdentifier() != null) {
            debugContext.setErrorName(failure.getErrorIdentifier().name());
            debugContext.setErrorCode(failure.getErrorIdentifier().code());
            debugBuilder.setFailureStatus(failure.getErrorIdentifier().status());
        }
        debugBuilder.setDebugInfoContext(debugContext.build());
        if (TestRecordProto.TestStatus.UNKNOWN.equals(current.getStatus())) {
            current.setDebugInfo(debugBuilder.build());
            current.setStatus(TestRecordProto.TestStatus.FAIL);
        } else {
            TestRecordProto.TestRecord.Builder test = this.mLatestChild.pop();
            TestRecordProto.TestRecord.Builder run = this.mLatestChild.peek();
            run.setDebugInfo(debugBuilder.build());
            run.setStatus(TestRecordProto.TestStatus.FAIL);
            this.mLatestChild.add(test);
        }
    }

    @Override
    public final void testRunEnded(long elapsedTimeMillis, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        TestRecordProto.TestRecord.Builder runBuilder = this.mLatestChild.pop();
        long startTime = this.timeStampToMillis(runBuilder.getStartTime());
        runBuilder.setEndTime(this.createTimeStamp(startTime + elapsedTimeMillis));
        runBuilder.putAllMetrics(runMetrics);
        TestRecordProto.TestRecord.Builder parentBuilder = this.mLatestChild.peek();
        if (!runBuilder.hasDebugInfo()) {
            runBuilder.setStatus(TestRecordProto.TestStatus.PASS);
        }
        TestRecordProto.TestRecord runRecord = runBuilder.build();
        parentBuilder.addChildren(this.createChildReference(runRecord));
        try {
            this.processTestRunEnded(runRecord, this.mModuleInProgress);
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to process test run end:");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public final void testStarted(TestDescription test) {
        this.testStarted(test, System.currentTimeMillis());
    }

    @Override
    public final void testStarted(TestDescription test, long startTime) {
        TestRecordProto.TestRecord.Builder testBuilder = TestRecordProto.TestRecord.newBuilder();
        TestRecordProto.TestRecord.Builder parent = this.mLatestChild.peek();
        testBuilder.setParentTestRecordId(parent.getTestRecordId());
        testBuilder.setTestRecordId(test.toString());
        testBuilder.setStartTime(this.createTimeStamp(startTime));
        testBuilder.setStatus(TestRecordProto.TestStatus.PASS);
        this.mLatestChild.add(testBuilder);
        try {
            this.processTestCaseStarted(testBuilder.build());
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to process invocation ended:");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.testEnded(test, System.currentTimeMillis(), testMetrics);
    }

    @Override
    public final void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        TestRecordProto.TestRecord.Builder testBuilder = this.mLatestChild.pop();
        testBuilder.setEndTime(this.createTimeStamp(endTime));
        testBuilder.putAllMetrics(testMetrics);
        TestRecordProto.TestRecord.Builder parentBuilder = this.mLatestChild.peek();
        TestRecordProto.TestRecord testCaseRecord = testBuilder.build();
        parentBuilder.addChildren(this.createChildReference(testCaseRecord));
        try {
            this.processTestCaseEnded(testCaseRecord);
        }
        catch (RuntimeException e) {
            LogUtil.CLog.e("Failed to process test case end:");
            LogUtil.CLog.e(e);
        }
    }

    @Override
    public final void testFailed(TestDescription test, String trace) {
        TestRecordProto.TestRecord.Builder testBuilder = this.mLatestChild.peek();
        testBuilder.setStatus(TestRecordProto.TestStatus.FAIL);
        TestRecordProto.DebugInfo.Builder debugBuilder = TestRecordProto.DebugInfo.newBuilder();
        debugBuilder.setErrorMessage(trace);
        debugBuilder.setTrace(trace);
        testBuilder.setDebugInfo(debugBuilder.build());
    }

    @Override
    public final void testFailed(TestDescription test, FailureDescription failure) {
        TestRecordProto.TestRecord.Builder testBuilder = this.mLatestChild.peek();
        testBuilder.setStatus(TestRecordProto.TestStatus.FAIL);
        TestRecordProto.DebugInfo.Builder debugBuilder = TestRecordProto.DebugInfo.newBuilder();
        debugBuilder.setErrorMessage(failure.toString());
        debugBuilder.setTrace(failure.toString());
        if (failure.getFailureStatus() != null) {
            debugBuilder.setFailureStatus(failure.getFailureStatus());
        }
        TestRecordProto.DebugInfoContext.Builder debugContext = TestRecordProto.DebugInfoContext.newBuilder();
        if (failure.getActionInProgress() != null) {
            debugContext.setActionInProgress(failure.getActionInProgress().toString());
        }
        if (!Strings.isNullOrEmpty(failure.getDebugHelpMessage())) {
            debugContext.setDebugHelpMessage(failure.getDebugHelpMessage());
        }
        debugBuilder.setDebugInfoContext(debugContext.build());
        testBuilder.setDebugInfo(debugBuilder.build());
    }

    @Override
    public final void testIgnored(TestDescription test) {
        TestRecordProto.TestRecord.Builder testBuilder = this.mLatestChild.peek();
        testBuilder.setStatus(TestRecordProto.TestStatus.IGNORED);
    }

    @Override
    public final void testAssumptionFailure(TestDescription test, String trace) {
        TestRecordProto.TestRecord.Builder testBuilder = this.mLatestChild.peek();
        testBuilder.setStatus(TestRecordProto.TestStatus.ASSUMPTION_FAILURE);
        TestRecordProto.DebugInfo.Builder debugBuilder = TestRecordProto.DebugInfo.newBuilder();
        debugBuilder.setErrorMessage(trace);
        debugBuilder.setTrace(trace);
        testBuilder.setDebugInfo(debugBuilder.build());
    }

    @Override
    public final void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        TestRecordProto.TestRecord.Builder testBuilder = this.mLatestChild.peek();
        testBuilder.setStatus(TestRecordProto.TestStatus.ASSUMPTION_FAILURE);
        TestRecordProto.DebugInfo.Builder debugBuilder = TestRecordProto.DebugInfo.newBuilder();
        debugBuilder.setErrorMessage(failure.toString());
        debugBuilder.setTrace(failure.toString());
        if (failure.getFailureStatus() != null) {
            debugBuilder.setFailureStatus(failure.getFailureStatus());
        }
        testBuilder.setDebugInfo(debugBuilder.build());
    }

    @Override
    public final void logAssociation(String dataName, LogFile logFile) {
        String key;
        if (this.mLatestChild == null || this.mLatestChild.isEmpty()) {
            LogUtil.CLog.w("Skip logging '%s' logAssociation called out of sequence.", dataName);
            return;
        }
        TestRecordProto.TestRecord.Builder current = this.mLatestChild.peek();
        if (this.mInvocationEnded) {
            current.clearArtifacts();
            current.clearChildren();
        }
        HashMap<String, Any> fullmap = new HashMap<String, Any>();
        fullmap.putAll(current.getArtifactsMap());
        Any any = Any.pack(this.createFileProto(logFile));
        int count = 0;
        do {
            key = String.format("%s%s", dataName, count == 0 ? "" : Integer.valueOf(count));
            ++count;
        } while (fullmap.containsKey(key));
        fullmap.put(key, any);
        current.putAllArtifacts(fullmap);
        if (this.mInvocationEnded) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "process final logs: %s", logFile.getPath());
            this.processFinalInvocationLogs(current.build());
        }
    }

    protected TestRecordProto.ChildReference createModuleChildReference(TestRecordProto.TestRecord record) {
        return this.createChildReference(record);
    }

    private TestRecordProto.ChildReference createChildReference(TestRecordProto.TestRecord record) {
        TestRecordProto.ChildReference.Builder child = TestRecordProto.ChildReference.newBuilder();
        child.setTestRecordId(record.getTestRecordId());
        if (this.mInlineRecordOfChildren) {
            child.setInlineTestRecord(record);
        }
        return child.build();
    }

    private Timestamp createTimeStamp(long currentTimeMs) {
        return Timestamp.newBuilder().setSeconds(currentTimeMs / 1000L).setNanos((int)(currentTimeMs % 1000L * 1000000L)).build();
    }

    private long timeStampToMillis(Timestamp stamp) {
        return stamp.getSeconds() * 1000L + (long)stamp.getNanos() / 1000000L;
    }

    private LogFileProto.LogFileInfo createFileProto(LogFile logFile) {
        LogFileProto.LogFileInfo.Builder logFileBuilder = LogFileProto.LogFileInfo.newBuilder();
        logFileBuilder.setPath(logFile.getPath()).setIsText(logFile.isText()).setLogType(logFile.getType().toString()).setIsCompressed(logFile.isCompressed()).setSize(logFile.getSize());
        if (logFile.getUrl() != null) {
            logFileBuilder.setUrl(logFile.getUrl());
        }
        return logFileBuilder.build();
    }

    private TestRecordProto.DebugInfo handleInvocationFailure() {
        TestRecordProto.DebugInfo.Builder debugBuilder = TestRecordProto.DebugInfo.newBuilder();
        if (this.mInvocationFailureDescription == null) {
            return null;
        }
        Throwable baseException = this.mInvocationFailureDescription.getCause();
        if (this.mInvocationFailureDescription.getErrorMessage() != null) {
            debugBuilder.setErrorMessage(this.mInvocationFailureDescription.getErrorMessage());
        }
        debugBuilder.setTrace(StreamUtil.getStackTrace(baseException));
        if (this.mInvocationFailureDescription != null && this.mInvocationFailureDescription.getFailureStatus() != null) {
            debugBuilder.setFailureStatus(this.mInvocationFailureDescription.getFailureStatus());
        }
        TestRecordProto.DebugInfoContext.Builder debugContext = TestRecordProto.DebugInfoContext.newBuilder();
        if (this.mInvocationFailureDescription != null) {
            if (this.mInvocationFailureDescription.getActionInProgress() != null) {
                debugContext.setActionInProgress(this.mInvocationFailureDescription.getActionInProgress().toString());
            }
            if (!Strings.isNullOrEmpty(this.mInvocationFailureDescription.getDebugHelpMessage())) {
                debugContext.setDebugHelpMessage(this.mInvocationFailureDescription.getDebugHelpMessage());
            }
            if (!Strings.isNullOrEmpty(this.mInvocationFailureDescription.getOrigin())) {
                debugContext.setOrigin(this.mInvocationFailureDescription.getOrigin());
            }
            if (this.mInvocationFailureDescription.getErrorIdentifier() != null) {
                debugContext.setErrorName(this.mInvocationFailureDescription.getErrorIdentifier().name());
                debugContext.setErrorCode(this.mInvocationFailureDescription.getErrorIdentifier().code());
            }
        }
        try {
            debugContext.setErrorType(SerializationUtil.serializeToString(baseException));
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to serialize the invocation failure:");
            LogUtil.CLog.e(e);
        }
        debugBuilder.setDebugInfoContext(debugContext);
        return debugBuilder.build();
    }
}

