/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.proto;

import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.proto.ProtoResultParser;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TimeUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class StreamProtoReceiver
implements Closeable {
    private static final int DEFAULT_AVAILABLE_PORT = 0;
    private static final long PER_MODULE_EXTRA_WAIT_TIME_MS = 5000L;
    private EventReceiverThread mEventReceiver;
    private ITestInvocationListener mListener;
    private ProtoResultParser mParser;
    private Throwable mError;
    private long mExtraWaitTimeForEvents = 0L;
    private AtomicBoolean mJoinStarted = new AtomicBoolean(false);
    private AtomicBoolean mStopParsing = new AtomicBoolean(false);

    public StreamProtoReceiver(ITestInvocationListener listener, IInvocationContext mainContext, boolean reportInvocation) throws IOException {
        this(listener, mainContext, reportInvocation, true);
    }

    public StreamProtoReceiver(ITestInvocationListener listener, IInvocationContext mainContext, boolean reportInvocation, boolean quietParsing) throws IOException {
        this(listener, mainContext, reportInvocation, quietParsing, true, "subprocess-");
    }

    public StreamProtoReceiver(ITestInvocationListener listener, IInvocationContext mainContext, boolean reportInvocation, boolean quietParsing, String logNamePrefix) throws IOException {
        this(listener, mainContext, reportInvocation, quietParsing, true, logNamePrefix);
    }

    public StreamProtoReceiver(ITestInvocationListener listener, IInvocationContext mainContext, boolean reportInvocation, boolean quietParsing, boolean reportLogs, String logNamePrefix) throws IOException {
        this(listener, mainContext, reportInvocation, quietParsing, reportLogs, logNamePrefix, true);
    }

    public StreamProtoReceiver(ITestInvocationListener listener, IInvocationContext mainContext, boolean reportInvocation, boolean quietParsing, boolean reportLogs, String logNamePrefix, boolean mergeInvocationMetrics) throws IOException {
        this.mListener = listener;
        this.mParser = new ProtoResultParser(this.mListener, mainContext, reportInvocation, logNamePrefix);
        this.mParser.setReportLogs(reportLogs);
        this.mParser.setQuiet(quietParsing);
        this.mParser.setMergeInvocationContext(mergeInvocationMetrics);
        this.mEventReceiver = new EventReceiverThread();
        this.mEventReceiver.start();
    }

    public int getSocketServerPort() {
        if (this.mEventReceiver != null) {
            return this.mEventReceiver.getLocalPort();
        }
        return -1;
    }

    public Throwable getError() {
        return this.mError;
    }

    @Override
    public void close() throws IOException {
        if (this.mEventReceiver != null) {
            this.mEventReceiver.cancel();
        }
    }

    public boolean joinReceiver(long millis) {
        if (this.mEventReceiver != null) {
            this.mJoinStarted.set(true);
            try {
                long waitTime = this.getJoinTimeout(millis);
                LogUtil.CLog.i("Waiting for events to finish being processed for %s", TimeUtil.formatElapsedTime(waitTime));
                if (!this.mEventReceiver.getCountDown().await(waitTime, TimeUnit.MILLISECONDS)) {
                    LogUtil.CLog.e("Event receiver thread did not complete. Some events may be missing.");
                    this.mEventReceiver.interrupt();
                    boolean bl = false;
                    return bl;
                }
            }
            catch (InterruptedException e) {
                LogUtil.CLog.e(e);
                throw new RuntimeException(e);
            }
            finally {
                this.mStopParsing.set(true);
            }
        }
        return true;
    }

    public void completeModuleEvents() {
        this.mParser.completeModuleEvents();
    }

    public boolean hasInvocationFailed() {
        return this.mParser.hasInvocationFailed();
    }

    @VisibleForTesting
    protected long getJoinTimeout(long millis) {
        return millis + this.mExtraWaitTimeForEvents;
    }

    private void parse(TestRecordProto.TestRecord receivedRecord) {
        if (this.mStopParsing.get()) {
            LogUtil.CLog.i("Skip parsing of %s. It came after joinReceiver.", receivedRecord.getTestRecordId());
            return;
        }
        try {
            ProtoResultParser.TestLevel level = this.mParser.processNewProto(receivedRecord);
            if (ProtoResultParser.TestLevel.MODULE.equals((Object)level) && !this.mJoinStarted.get()) {
                this.mExtraWaitTimeForEvents += 5000L;
            }
        }
        catch (Throwable e) {
            LogUtil.CLog.e(e);
            this.mError = e;
            throw e;
        }
    }

    private class EventReceiverThread
    extends Thread {
        private ServerSocket mSocket;
        private CountDownLatch mCountDown;

        public EventReceiverThread() throws IOException {
            super("ProtoEventReceiverThread");
            this.setDaemon(true);
            this.mSocket = new ServerSocket(0);
            this.mCountDown = new CountDownLatch(1);
        }

        protected int getLocalPort() {
            return this.mSocket.getLocalPort();
        }

        protected CountDownLatch getCountDown() {
            return this.mCountDown;
        }

        public void cancel() throws IOException {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }

        @Override
        public void run() {
            Socket client = null;
            try {
                client = this.mSocket.accept();
                TestRecordProto.TestRecord received = null;
                while ((received = TestRecordProto.TestRecord.parseDelimitedFrom(client.getInputStream())) != null) {
                    StreamProtoReceiver.this.parse(received);
                }
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
            finally {
                StreamUtil.close(client);
                this.mCountDown.countDown();
            }
            LogUtil.CLog.d("ProtoEventReceiverThread done.");
        }
    }
}

