/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.proto;

import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.proto.ProtoResultReporter;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StreamProtoResultReporter
extends ProtoResultReporter {
    public static final String PROTO_REPORT_PORT_OPTION = "proto-report-port";
    @Option(name="proto-report-port", description="the port where to connect to send the protos.")
    private Integer mReportPort = null;
    private Socket mReportSocket = null;
    private boolean mPrintedMessage = false;
    private ResultWriterThread mResultWriterThread;
    private ConcurrentLinkedQueue<TestRecordProto.TestRecord> mToBeSent = new ConcurrentLinkedQueue();

    public StreamProtoResultReporter() {
        this.setInlineRecordOfChildren(false);
    }

    public void setProtoReportPort(Integer portValue) {
        this.mReportPort = portValue;
    }

    public Integer getProtoReportPort() {
        return this.mReportPort;
    }

    @Override
    public void processStartInvocation(TestRecordProto.TestRecord invocationStartRecord, IInvocationContext context) {
        this.mResultWriterThread = new ResultWriterThread();
        this.mResultWriterThread.start();
        this.mToBeSent.add(invocationStartRecord);
    }

    @Override
    public void processTestModuleStarted(TestRecordProto.TestRecord moduleStartRecord) {
        this.mToBeSent.add(moduleStartRecord);
    }

    @Override
    public void processTestModuleEnd(TestRecordProto.TestRecord moduleRecord) {
        this.mToBeSent.add(moduleRecord);
    }

    @Override
    public void processTestRunStarted(TestRecordProto.TestRecord runStartedRecord) {
        this.mToBeSent.add(runStartedRecord);
    }

    @Override
    public void processTestRunEnded(TestRecordProto.TestRecord runRecord, boolean moduleInProgress) {
        this.mToBeSent.add(runRecord);
    }

    @Override
    public void processTestCaseStarted(TestRecordProto.TestRecord testCaseStartedRecord) {
        this.mToBeSent.add(testCaseStartedRecord);
    }

    @Override
    public void processTestCaseEnded(TestRecordProto.TestRecord testCaseRecord) {
        this.mToBeSent.add(testCaseRecord);
    }

    @Override
    public void processFinalInvocationLogs(TestRecordProto.TestRecord invocationLogs) {
        if (this.mResultWriterThread.mCancelled.get()) {
            this.writeRecordToSocket(invocationLogs);
        } else {
            this.mToBeSent.add(invocationLogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFinalProto(TestRecordProto.TestRecord finalRecord) {
        try {
            if (this.mResultWriterThread.mCancelled.get()) {
                this.writeRecordToSocket(finalRecord);
            } else {
                this.mToBeSent.add(finalRecord);
            }
        }
        finally {
            SocketFinisher thread = new SocketFinisher();
            Runtime.getRuntime().addShutdownHook(thread);
            this.mResultWriterThread.mCancelled.set(true);
            try {
                this.mResultWriterThread.join();
            }
            catch (InterruptedException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    protected void closeSocket() {
        StreamUtil.close(this.mReportSocket);
    }

    private void writeRecordToSocket(TestRecordProto.TestRecord record) {
        if (this.mReportPort == null) {
            if (!this.mPrintedMessage) {
                LogUtil.CLog.d("No port set. Skipping the reporter.");
                this.mPrintedMessage = true;
            }
            return;
        }
        try {
            if (this.mReportSocket == null) {
                this.mReportSocket = new Socket("localhost", (int)this.mReportPort);
            }
            record.writeDelimitedTo(this.mReportSocket.getOutputStream());
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
    }

    private class ResultWriterThread
    extends Thread {
        private AtomicBoolean mCancelled = new AtomicBoolean(false);

        public ResultWriterThread() {
            this.setName("ResultWriterThread");
        }

        @Override
        public void run() {
            while (!this.mCancelled.get()) {
                this.flushEvents();
                if (this.mCancelled.get()) continue;
                RunUtil.getDefault().sleep(1000L);
            }
            this.flushEvents();
        }

        public void flushEvents() {
            TestRecordProto.TestRecord record = StreamProtoResultReporter.this.mToBeSent.poll();
            while (record != null) {
                StreamProtoResultReporter.this.writeRecordToSocket(record);
                record = StreamProtoResultReporter.this.mToBeSent.poll();
            }
        }
    }

    private class SocketFinisher
    extends Thread {
        public SocketFinisher() {
            this.setName("StreamProtoResultReporter-socket-finisher");
        }

        @Override
        public void run() {
            StreamProtoResultReporter.this.closeSocket();
        }
    }
}

