/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.skipped;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.skipped.SkipReason;
import com.android.tradefed.service.TradefedFeatureClient;
import com.android.tradefed.util.IDisableable;
import com.proto.tradefed.feature.FeatureResponse;
import com.proto.tradefed.feature.PartResponse;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@OptionClass(alias="skip-manager")
public class SkipManager
implements IDisableable {
    @Option(name="disable-skip-manager", description="Disable the skip manager feature.")
    private boolean mIsDisabled = false;
    @Option(name="demotion-filters", description="An option to manually inject demotion filters. Intended for testing and validation, not for production demotion.")
    private Map<String, String> mDemotionFilterOption = new LinkedHashMap<String, String>();
    @Option(name="silent-invocation-skip", description="Only report a property for when we would have skipped the invocation instead of actually skipping.")
    private boolean mSilentInvocationSkip = true;
    private final Map<String, SkipReason> mDemotionFilters = new LinkedHashMap<String, SkipReason>();
    private boolean mNoTestsDiscovered = false;

    public void setup(IConfiguration config, IInvocationContext context) {
        if (TestInvocation.isSubprocess(config)) {
            return;
        }
        for (Map.Entry<String, String> filterReason : this.mDemotionFilterOption.entrySet()) {
            this.mDemotionFilters.put(filterReason.getKey(), new SkipReason(filterReason.getValue(), SkipReason.DemotionTrigger.UNKNOWN_TRIGGER));
        }
        this.fetchDemotionInformation(context);
    }

    public Map<String, SkipReason> getDemotedTests() {
        return this.mDemotionFilters;
    }

    public void reportDiscoveryWithNoTests() {
        LogUtil.CLog.d("Test discovery reported that no tests were found.");
        this.mNoTestsDiscovered = true;
    }

    public boolean shouldSkipInvocation() {
        boolean shouldskip = this.mNoTestsDiscovered;
        if (this.mSilentInvocationSkip && shouldskip) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SILENT_INVOCATION_SKIP_COUNT, 1L);
            return false;
        }
        return shouldskip;
    }

    private void fetchDemotionInformation(IInvocationContext context) {
        if (this.isDisabled()) {
            return;
        }
        if (!"WORK_NODE".equals(context.getAttribute("trigger"))) {
            LogUtil.CLog.d("Skip fetching demotion information in non-presubmit.");
            return;
        }
        try (TradefedFeatureClient client = new TradefedFeatureClient();){
            HashMap<String, String> args = new HashMap<String, String>();
            FeatureResponse response = client.triggerFeature("FetchDemotionInformation", args);
            if (!response.hasErrorInfo()) {
                for (PartResponse part : response.getMultiPartResponse().getResponsePartList()) {
                    String filter = part.getKey();
                    this.mDemotionFilters.put(filter, null);
                }
            }
        }
        if (!this.mDemotionFilters.isEmpty()) {
            LogUtil.CLog.d("Demotion filters size '%s': %s", this.mDemotionFilters.size(), this.mDemotionFilters);
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.DEMOTION_FILTERS_RECEIVED_COUNT, this.mDemotionFilters.size());
        }
    }

    @Override
    public boolean isDisabled() {
        return this.mIsDisabled;
    }

    @Override
    public void setDisable(boolean isDisabled) {
        this.mIsDisabled = isDisabled;
    }
}

