/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.skipped;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SkipReason {
    private final String reason;
    private final String trigger;
    private final String bugId;

    public SkipReason(String message2, DemotionTrigger trigger) {
        this(message2, trigger, "");
    }

    public SkipReason(String message2, DemotionTrigger trigger, String bugId) {
        this.reason = message2;
        this.trigger = trigger.name();
        this.bugId = bugId;
    }

    public String getReason() {
        return this.reason;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public String getBugId() {
        return this.bugId;
    }

    public String toString() {
        return "SkipReason[reason=" + this.reason + ", trigger=" + this.trigger + ", bugId=" + this.bugId + "]";
    }

    public static SkipReason fromString(String skipReasonMessage) {
        Pattern p = Pattern.compile("SkipReason\\[reason=(.*), trigger=(.*), bugId=(.*)\\]");
        Matcher m = p.matcher(skipReasonMessage);
        if (m.find()) {
            String reason = m.group(1);
            String trigger = m.group(2);
            String bugId = m.group(3);
            return new SkipReason(reason, DemotionTrigger.valueOf(trigger), bugId);
        }
        throw new RuntimeException(String.format("Cannot parse '%s' as SkipReason.", skipReasonMessage));
    }

    public static enum DemotionTrigger {
        UNKNOWN_TRIGGER,
        MANUAL,
        LATENCY,
        ERROR_RATE,
        FLAKINESS;

    }
}

