/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.suite;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.suite.IFormatterGenerator;
import com.android.tradefed.result.suite.SuiteResultHolder;
import com.android.tradefed.result.suite.SuiteResultReporter;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.retry.ResultsPlayer;
import com.google.common.base.Strings;

public abstract class FormattedGeneratorReporter
extends SuiteResultReporter
implements IConfigurationReceiver {
    private Throwable mTestHarnessError = null;
    private IConfiguration mConfiguration;

    @Override
    public final void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public final IConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    @Override
    public final void invocationEnded(long elapsedTime) {
        super.invocationEnded(elapsedTime);
        if (this.mTestHarnessError != null) {
            Boolean replaySuccess = null;
            for (IRemoteTest test : this.mConfiguration.getTests()) {
                if (!(test instanceof ResultsPlayer)) continue;
                replaySuccess = ((ResultsPlayer)test).completed();
            }
            String replay = this.getInvocationContext().getBuildInfos().get(0).getBuildAttributes().get("REPLAY_DONE");
            if (!Strings.isNullOrEmpty(replay) && "false".equals(replay)) {
                LogUtil.CLog.e("Invocation failed and previous session results couldn't be copied, skip generating the formatted report due to:");
                LogUtil.CLog.e(this.mTestHarnessError);
                return;
            }
            if (replaySuccess != null && !replaySuccess.booleanValue()) {
                LogUtil.CLog.e("Invocation failed and previous session results couldn't be copied, skip generating the formatted report due to:");
                LogUtil.CLog.e(this.mTestHarnessError);
                return;
            }
        }
        SuiteResultHolder holder = this.generateResultHolder();
        IFormatterGenerator generator = this.createFormatter();
        this.finalizeResults(generator, holder);
    }

    @Override
    public void invocationFailed(Throwable cause) {
        FailureDescription description = FailureDescription.create(cause.getMessage()).setCause(cause);
        if (cause instanceof IHarnessException) {
            description.setErrorIdentifier(((IHarnessException)((Object)cause)).getErrorId());
        }
        this.invocationFailed(description);
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        Throwable cause = failure.getCause();
        if (cause != null && (cause instanceof TargetSetupError || cause instanceof RuntimeException || cause instanceof OutOfMemoryError)) {
            this.mTestHarnessError = cause;
        }
        super.invocationFailed(cause);
    }

    public abstract void finalizeResults(IFormatterGenerator var1, SuiteResultHolder var2);

    public abstract IFormatterGenerator createFormatter();

    private SuiteResultHolder generateResultHolder() {
        SuiteResultHolder holder = new SuiteResultHolder();
        holder.context = this.getInvocationContext();
        holder.runResults = this.getMergedTestRunResults();
        holder.modulesAbi = this.getModulesAbi();
        holder.completeModules = this.getCompleteModules();
        holder.totalModules = this.getTotalModules();
        holder.passedTests = this.getPassedTests();
        holder.failedTests = this.getFailedTests();
        holder.startTime = this.getStartTime();
        holder.endTime = this.getEndTime();
        return holder;
    }
}

