/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.suite;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SuiteResultReporter
extends CollectingTestListener {
    public static final String SUITE_REPORTER_SOURCE = SuiteResultReporter.class.getName();
    private Long mStartTime = null;
    private long mEndTime = 0L;
    private AtomicInteger mTotalModules = new AtomicInteger(0);
    private AtomicInteger mCompleteModules = new AtomicInteger(0);
    private long mTotalTests = 0L;
    private long mPassedTests = 0L;
    private long mFailedTests = 0L;
    private long mSkippedTests = 0L;
    private long mAssumeFailureTests = 0L;
    private long mTotalRetrySuccess = 0L;
    private Map<String, Long> mModuleRetrySuccess = new LinkedHashMap<String, Long>();
    private long mTotalRetryFail = 0L;
    private Map<String, Long> mModuleRetryFail = new LinkedHashMap<String, Long>();
    private long mTotalRetryTime = 0L;
    private Map<String, Long> mModuleRetryTime = new LinkedHashMap<String, Long>();
    private Map<String, String> mFailedModule = new HashMap<String, String>();
    private Map<String, ModulePrepTimes> mPreparationMap = new HashMap<String, ModulePrepTimes>();
    private Map<String, IAbi> mModuleAbi = new LinkedHashMap<String, IAbi>();
    private StringBuilder mSummary;

    public SuiteResultReporter() {
        this.setIsAggregrateMetrics(true);
        this.mSummary = new StringBuilder();
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        super.invocationStarted(context);
        if (this.mStartTime == null) {
            this.mStartTime = this.getCurrentTime();
        }
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        super.testModuleStarted(moduleContext);
        List<String> abiName = moduleContext.getAttributes().get("module-abi");
        if (abiName != null) {
            Abi abi = new Abi(abiName.get(0), AbiUtils.getBitness(abiName.get(0)));
            this.mModuleAbi.put(moduleContext.getAttributes().get("module-id").get(0), abi);
        }
    }

    private List<TestRunResult> extractModuleCheckers(Collection<TestRunResult> results) {
        ArrayList<TestRunResult> moduleCheckers = new ArrayList<TestRunResult>();
        for (TestRunResult t : results) {
            if (!t.getName().startsWith("PostModuleChecker") && !t.getName().startsWith("PreModuleChecker")) continue;
            moduleCheckers.add(t);
        }
        results.removeAll(moduleCheckers);
        return moduleCheckers;
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        this.mEndTime = this.getCurrentTime();
        super.invocationEnded(elapsedTime);
        List<TestRunResult> results = this.getMergedTestRunResults();
        List<TestRunResult> moduleCheckers = this.extractModuleCheckers(results);
        this.mTotalModules.set(results.size());
        for (TestRunResult testRunResult : results) {
            String retryTime;
            String retryFailure;
            String retrySuccess;
            if (!testRunResult.isRunFailure()) {
                this.mCompleteModules.incrementAndGet();
            } else {
                this.mFailedModule.put(testRunResult.getName(), testRunResult.getRunFailureMessage());
            }
            this.mTotalTests += (long)testRunResult.getExpectedTestCount();
            this.mPassedTests += (long)testRunResult.getNumTestsInState(TestResult.TestStatus.PASSED);
            this.mFailedTests += (long)testRunResult.getNumAllFailedTests();
            this.mSkippedTests += (long)testRunResult.getNumTestsInState(TestResult.TestStatus.IGNORED);
            this.mAssumeFailureTests += (long)testRunResult.getNumTestsInState(TestResult.TestStatus.ASSUMPTION_FAILURE);
            String prepTime = testRunResult.getRunMetrics().get("PREP_TIME");
            String tearTime = testRunResult.getRunMetrics().get("TEARDOWN_TIME");
            if (prepTime != null && tearTime != null) {
                this.mPreparationMap.put(testRunResult.getName(), new ModulePrepTimes(Long.parseLong(prepTime), Long.parseLong(tearTime)));
            }
            if ((retrySuccess = testRunResult.getRunMetrics().get("MODULE_RETRY_SUCCESS")) != null) {
                this.mTotalRetrySuccess += Long.parseLong(retrySuccess);
                this.mModuleRetrySuccess.put(testRunResult.getName(), Long.parseLong(retrySuccess));
            }
            if ((retryFailure = testRunResult.getRunMetrics().get("MODULE_RETRY_FAILED")) != null) {
                this.mTotalRetryFail += Long.parseLong(retryFailure);
                this.mModuleRetryFail.put(testRunResult.getName(), Long.parseLong(retryFailure));
            }
            if ((retryTime = testRunResult.getRunMetrics().get("MODULE_RETRY_TIME")) == null) continue;
            this.mTotalRetryTime += Long.parseLong(retryTime);
            this.mModuleRetryTime.put(testRunResult.getName(), Long.parseLong(retryTime));
        }
        this.mSummary.append("\n============================================\n");
        this.mSummary.append("================= Results ==================\n");
        this.printModuleTestTime(results);
        this.printTopSlowModules(results);
        this.printPreparationMetrics(this.mPreparationMap);
        this.printModuleCheckersMetric(moduleCheckers);
        this.printModuleRetriesInformation();
        this.mSummary.append("=============== Summary ===============\n");
        if (this.mStartTime == null) {
            this.mStartTime = 0L;
        }
        this.mSummary.append(String.format("Total Run time: %s\n", TimeUtil.formatElapsedTime(this.mEndTime - this.mStartTime)));
        this.mSummary.append(String.format("%s/%s modules completed\n", this.mCompleteModules, this.mTotalModules));
        if (!this.mFailedModule.isEmpty()) {
            this.mSummary.append("Module(s) with run failure(s):\n");
            for (Map.Entry entry : this.mFailedModule.entrySet()) {
                this.mSummary.append(String.format("    %s: %s\n", entry.getKey(), entry.getValue()));
            }
        }
        this.mSummary.append(String.format("Total Tests       : %s\n", this.mTotalTests));
        this.mSummary.append(String.format("PASSED            : %s\n", this.mPassedTests));
        this.mSummary.append(String.format("FAILED            : %s\n", this.mFailedTests));
        if (this.mSkippedTests > 0L) {
            this.mSummary.append(String.format("IGNORED           : %s\n", this.mSkippedTests));
        }
        if (this.mAssumeFailureTests > 0L) {
            this.mSummary.append(String.format("ASSUMPTION_FAILURE: %s\n", this.mAssumeFailureTests));
        }
        if (this.mCompleteModules.get() != this.mTotalModules.get()) {
            this.mSummary.append("IMPORTANT: Some modules failed to run to completion, tests counts may be inaccurate.\n");
        }
        for (Map.Entry entry : this.getInvocationContext().getShardsSerials().entrySet()) {
            this.mSummary.append(String.format("Shard %s used: %s\n", entry.getKey(), entry.getValue()));
        }
        this.mSummary.append("============== End of Results ==============\n");
        this.mSummary.append("============================================\n");
        LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, this.mSummary.toString());
    }

    private void printModuleTestTime(Collection<TestRunResult> results) {
        ArrayList<TestRunResult> moduleTime = new ArrayList<TestRunResult>();
        moduleTime.addAll(results);
        Collections.sort(moduleTime, new Comparator<TestRunResult>(){

            @Override
            public int compare(TestRunResult o1, TestRunResult o2) {
                return (int)(o2.getElapsedTime() - o1.getElapsedTime());
            }
        });
        long totalRunTime = 0L;
        this.mSummary.append("=============== Consumed Time ==============\n");
        for (int i = 0; i < moduleTime.size(); ++i) {
            this.mSummary.append(String.format("    %s: %s\n", ((TestRunResult)moduleTime.get(i)).getName(), TimeUtil.formatElapsedTime(((TestRunResult)moduleTime.get(i)).getElapsedTime())));
            totalRunTime += ((TestRunResult)moduleTime.get(i)).getElapsedTime();
        }
        this.mSummary.append(String.format("Total aggregated tests run time: %s\n", TimeUtil.formatElapsedTime(totalRunTime)));
    }

    private void printTopSlowModules(Collection<TestRunResult> results) {
        ArrayList<TestRunResult> moduleTime = new ArrayList<TestRunResult>();
        moduleTime.addAll(results);
        for (TestRunResult t : results) {
            if (t.getElapsedTime() >= 5000L) continue;
            moduleTime.remove(t);
        }
        Collections.sort(moduleTime, new Comparator<TestRunResult>(){

            @Override
            public int compare(TestRunResult o1, TestRunResult o2) {
                Float rate1 = Float.valueOf((float)o1.getNumTests() / (float)o1.getElapsedTime());
                Float rate2 = Float.valueOf((float)o2.getNumTests() / (float)o2.getElapsedTime());
                return rate1.compareTo(rate2);
            }
        });
        int maxModuleDisplay = moduleTime.size();
        if (maxModuleDisplay == 0) {
            return;
        }
        this.mSummary.append(String.format("============== TOP %s Slow Modules ==============\n", maxModuleDisplay));
        for (int i = 0; i < maxModuleDisplay; ++i) {
            this.mSummary.append(String.format("    %s: %.02f tests/sec [%s tests / %s msec]\n", ((TestRunResult)moduleTime.get(i)).getName(), Float.valueOf((float)((TestRunResult)moduleTime.get(i)).getNumTests() / ((float)((TestRunResult)moduleTime.get(i)).getElapsedTime() / 1000.0f)), ((TestRunResult)moduleTime.get(i)).getNumTests(), ((TestRunResult)moduleTime.get(i)).getElapsedTime()));
        }
    }

    private void printPreparationMetrics(Map<String, ModulePrepTimes> metrics) {
        if (metrics.isEmpty()) {
            return;
        }
        this.mSummary.append("============== Modules Preparation Times ==============\n");
        long totalPrep = 0L;
        long totalTear = 0L;
        for (String moduleName : metrics.keySet()) {
            this.mSummary.append(String.format("    %s => %s\n", moduleName, metrics.get(moduleName).toString()));
            totalPrep += metrics.get((Object)moduleName).mPrepTime;
            totalTear += metrics.get((Object)moduleName).mTearDownTime;
        }
        this.mSummary.append(String.format("Total preparation time: %s  ||  Total tear down time: %s\n", TimeUtil.formatElapsedTime(totalPrep), TimeUtil.formatElapsedTime(totalTear)));
        this.mSummary.append("=======================================================\n");
    }

    private void printModuleCheckersMetric(List<TestRunResult> moduleCheckerResults) {
        if (moduleCheckerResults.isEmpty()) {
            return;
        }
        this.mSummary.append("============== Modules Checkers Times ==============\n");
        long totalTime = 0L;
        for (TestRunResult t : moduleCheckerResults) {
            this.mSummary.append(String.format("    %s: %s\n", t.getName(), TimeUtil.formatElapsedTime(t.getElapsedTime())));
            totalTime += t.getElapsedTime();
        }
        this.mSummary.append(String.format("Total module checkers time: %s\n", TimeUtil.formatElapsedTime(totalTime)));
        this.mSummary.append("====================================================\n");
    }

    private void printModuleRetriesInformation() {
        if (this.mModuleRetrySuccess.isEmpty() || this.mTotalRetryTime == 0L) {
            return;
        }
        this.mSummary.append("============== Modules Retries Information ==============\n");
        for (String t : this.mModuleRetrySuccess.keySet()) {
            if (this.mModuleRetryTime.get(t) == 0L) continue;
            this.mSummary.append(String.format("    %s:\n        Retry Success (Failed test became Pass)   = %s\n        Retry Failure (Failed test stayed Failed) = %s\n        Retry Time                                = %s\n", t, this.mModuleRetrySuccess.get(t), this.mModuleRetryFail.get(t), TimeUtil.formatElapsedTime(this.mModuleRetryTime.get(t))));
        }
        this.mSummary.append("Summary:\n");
        this.mSummary.append(String.format("Total Retry Success (Failed test became Pass) = %s\nTotal Retry Failure (Failed test stayed Failed) = %s\nTotal Retry Time                                = %s\n", this.mTotalRetrySuccess, this.mTotalRetryFail, TimeUtil.formatElapsedTime(this.mTotalRetryTime)));
        this.mSummary.append("====================================================\n");
    }

    public Map<String, IAbi> getModulesAbi() {
        return this.mModuleAbi;
    }

    public int getTotalModules() {
        return this.mTotalModules.get();
    }

    public int getCompleteModules() {
        return this.mCompleteModules.get();
    }

    public long getTotalTests() {
        return this.mTotalTests;
    }

    public long getPassedTests() {
        return this.mPassedTests;
    }

    public long getFailedTests() {
        return this.mFailedTests;
    }

    @Override
    public TestSummary getSummary() {
        if (this.mSummary == null || this.mSummary.toString().isEmpty()) {
            return null;
        }
        TestSummary summary = new TestSummary(new TestSummary.TypedString(this.mSummary.toString(), TestSummary.Type.TEXT));
        summary.setSource(SUITE_REPORTER_SOURCE);
        return summary;
    }

    protected long getStartTime() {
        return this.mStartTime;
    }

    protected long getEndTime() {
        return this.mEndTime;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public static class ModulePrepTimes {
        public final long mPrepTime;
        public final long mTearDownTime;

        public ModulePrepTimes(long prepTime, long tearTime) {
            this.mPrepTime = prepTime;
            this.mTearDownTime = tearTime;
        }

        public String toString() {
            return String.format("prep = %s ms || clean = %s ms", this.mPrepTime, this.mTearDownTime);
        }
    }
}

