/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.suite;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.suite.FormattedGeneratorReporter;
import com.android.tradefed.result.suite.IFormatterGenerator;
import com.android.tradefed.result.suite.SuiteResultHolder;
import com.android.tradefed.result.suite.XmlSuiteResultFormatter;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class XmlFormattedGeneratorReporter
extends FormattedGeneratorReporter {
    @Override
    public final void finalizeResults(IFormatterGenerator generator, SuiteResultHolder resultHolder) {
        File resultDir = null;
        try {
            resultDir = this.createResultDir();
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to create the result directory:");
            LogUtil.CLog.e(e);
            return;
        }
        this.preFormattingSetup(generator);
        File resultReportFile = null;
        try {
            resultReportFile = generator.writeResults(resultHolder, resultDir);
            for (String runName : this.getTestRunNames()) {
                this.clearResultsForName(runName);
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e("Failed to generate the formatted report file:");
            LogUtil.CLog.e(e);
            return;
        }
        this.postFormattingStep(resultDir, resultReportFile);
    }

    public void preFormattingSetup(IFormatterGenerator formater) {
    }

    public void postFormattingStep(File resultDir, File reportFile) {
    }

    public File createResultDir() throws IOException {
        return FileUtil.createTempDir("XmlFormattedGeneratorReporter");
    }

    @Override
    public IFormatterGenerator createFormatter() {
        return new XmlSuiteResultFormatter();
    }
}

