/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result.suite;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.suite.IFormatterGenerator;
import com.android.tradefed.result.suite.SuiteResultHolder;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.base.Strings;
import com.google.common.xml.XmlEscapers;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class XmlSuiteResultFormatter
implements IFormatterGenerator {
    private static final int STACK_TRACE_MAX_SIZE = 0x100000;
    private static final String ENCODING = "UTF-8";
    private static final String TYPE = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
    public static final String NS = null;
    public static final String TEST_RESULT_FILE_NAME = "test_result.xml";
    private static final String ABI_ATTR = "abi";
    private static final String BUGREPORT_TAG = "BugReport";
    private static final String BUILD_TAG = "Build";
    private static final String CASE_TAG = "TestCase";
    private static final String COMMAND_LINE_ARGS = "command_line_args";
    private static final String DEVICES_ATTR = "devices";
    private static final String DEVICE_KERNEL_INFO_ATTR = "device_kernel_info";
    private static final String DONE_ATTR = "done";
    private static final String END_DISPLAY_TIME_ATTR = "end_display";
    private static final String END_TIME_ATTR = "end";
    private static final String FAILED_ATTR = "failed";
    private static final String FAILURE_TAG = "Failure";
    private static final String HOST_NAME_ATTR = "host_name";
    private static final String JAVA_VENDOR_ATTR = "java_vendor";
    private static final String JAVA_VERSION_ATTR = "java_version";
    private static final String LOGCAT_TAG = "Logcat";
    private static final String METRIC_TAG = "Metric";
    private static final String METRIC_KEY = "key";
    private static final String MESSAGE_ATTR = "message";
    private static final String MODULE_TAG = "Module";
    private static final String MODULES_DONE_ATTR = "modules_done";
    private static final String MODULES_TOTAL_ATTR = "modules_total";
    private static final String MODULES_NOT_DONE_REASON = "Reason";
    private static final String NAME_ATTR = "name";
    private static final String OS_ARCH_ATTR = "os_arch";
    private static final String OS_NAME_ATTR = "os_name";
    private static final String OS_VERSION_ATTR = "os_version";
    private static final String PASS_ATTR = "pass";
    private static final String RESULT_ATTR = "result";
    private static final String RESULT_TAG = "Result";
    private static final String RUN_HISTORY = "run_history";
    private static final String RUN_HISTORY_TAG = "RunHistory";
    private static final String RUN_TAG = "Run";
    private static final String RUNTIME_ATTR = "runtime";
    private static final String SCREENSHOT_TAG = "Screenshot";
    private static final String SKIPPED_ATTR = "skipped";
    private static final String STACK_TAG = "StackTrace";
    private static final String ERROR_NAME_ATTR = "error_name";
    private static final String ERROR_CODE_ATTR = "error_code";
    private static final String START_DISPLAY_TIME_ATTR = "start_display";
    private static final String START_TIME_ATTR = "start";
    private static final String SUMMARY_TAG = "Summary";
    private static final String SYSTEM_IMG_INFO_ATTR = "system_img_info";
    private static final String TEST_TAG = "Test";
    private static final String TOTAL_TESTS_ATTR = "total_tests";
    private static final String VENDOR_IMG_INFO_ATTR = "vendor_img_info";
    private static final String LOG_FILE_NAME_ATTR = "file_name";

    public void addSuiteAttributes(XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
    }

    public void parseSuiteAttributes(XmlPullParser parser, IInvocationContext context) throws XmlPullParserException {
    }

    public void addBuildInfoAttributes(XmlSerializer serializer, SuiteResultHolder holder) throws IllegalArgumentException, IllegalStateException, IOException {
    }

    public void parseBuildInfoAttributes(XmlPullParser parser, IInvocationContext context) throws XmlPullParserException {
    }

    @Override
    public File writeResults(SuiteResultHolder holder, File resultDir) throws IOException {
        File resultFile = new File(resultDir, TEST_RESULT_FILE_NAME);
        FileOutputStream stream = new FileOutputStream(resultFile);
        XmlSerializer serializer = null;
        try {
            serializer = XmlPullParserFactory.newInstance(TYPE, null).newSerializer();
        }
        catch (XmlPullParserException e) {
            StreamUtil.close(stream);
            throw new IOException(e);
        }
        serializer.setOutput(stream, ENCODING);
        serializer.startDocument(ENCODING, false);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.processingInstruction("xml-stylesheet type=\"text/xsl\" href=\"compatibility_result.xsl\"");
        serializer.startTag(NS, RESULT_TAG);
        serializer.attribute(NS, START_TIME_ATTR, String.valueOf(holder.startTime));
        serializer.attribute(NS, END_TIME_ATTR, String.valueOf(holder.endTime));
        serializer.attribute(NS, START_DISPLAY_TIME_ATTR, XmlSuiteResultFormatter.toReadableDateString(holder.startTime));
        serializer.attribute(NS, END_DISPLAY_TIME_ATTR, XmlSuiteResultFormatter.toReadableDateString(holder.endTime));
        serializer.attribute(NS, COMMAND_LINE_ARGS, Strings.nullToEmpty(holder.context.getAttributes().getUniqueMap().get(COMMAND_LINE_ARGS)));
        this.addSuiteAttributes(serializer);
        Map<Integer, List<String>> serialsShards = holder.context.getShardsSerials();
        String deviceList = "";
        if (serialsShards.isEmpty()) {
            deviceList = String.join((CharSequence)",", holder.context.getSerials());
        } else {
            LinkedHashSet<String> subSet = new LinkedHashSet<String>();
            for (List<String> list2 : serialsShards.values()) {
                subSet.addAll(list2);
            }
            deviceList = String.join((CharSequence)",", subSet);
        }
        serializer.attribute(NS, DEVICES_ATTR, deviceList);
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        serializer.attribute(NS, HOST_NAME_ATTR, hostName);
        serializer.attribute(NS, OS_NAME_ATTR, System.getProperty("os.name"));
        serializer.attribute(NS, OS_VERSION_ATTR, System.getProperty("os.version"));
        serializer.attribute(NS, OS_ARCH_ATTR, System.getProperty("os.arch"));
        serializer.attribute(NS, JAVA_VENDOR_ATTR, System.getProperty("java.vendor"));
        serializer.attribute(NS, JAVA_VERSION_ATTR, System.getProperty("java.version"));
        serializer.startTag(NS, BUILD_TAG);
        for (String key : holder.context.getAttributes().keySet()) {
            serializer.attribute(NS, XmlSuiteResultFormatter.sanitizeAttributesKey(key), String.join((CharSequence)",", holder.context.getAttributes().get(key)));
        }
        if (!holder.context.getBuildInfos().isEmpty()) {
            IBuildInfo buildInfo = holder.context.getBuildInfos().get(0);
            XmlSuiteResultFormatter.addBuildInfoAttributesIfNotNull(serializer, buildInfo, DEVICE_KERNEL_INFO_ATTR);
            XmlSuiteResultFormatter.addBuildInfoAttributesIfNotNull(serializer, buildInfo, SYSTEM_IMG_INFO_ATTR);
            XmlSuiteResultFormatter.addBuildInfoAttributesIfNotNull(serializer, buildInfo, VENDOR_IMG_INFO_ATTR);
        }
        this.addBuildInfoAttributes(serializer, holder);
        serializer.endTag(NS, BUILD_TAG);
        String runHistoryJson = holder.context.getAttributes().getUniqueMap().get(RUN_HISTORY);
        if (runHistoryJson != null) {
            RunHistory[] runHistories;
            serializer.startTag(NS, RUN_HISTORY_TAG);
            Gson gson = new Gson();
            for (RunHistory runHistory : runHistories = gson.fromJson(runHistoryJson, RunHistory[].class)) {
                serializer.startTag(NS, RUN_TAG);
                serializer.attribute(NS, START_TIME_ATTR, String.valueOf(runHistory.startTime));
                serializer.attribute(NS, END_TIME_ATTR, String.valueOf(runHistory.endTime));
                serializer.attribute(NS, PASS_ATTR, Long.toString(runHistory.passedTests));
                serializer.attribute(NS, FAILED_ATTR, Long.toString(runHistory.failedTests));
                serializer.attribute(NS, COMMAND_LINE_ARGS, runHistory.commandLineArgs);
                serializer.attribute(NS, HOST_NAME_ATTR, runHistory.hostName);
                serializer.endTag(NS, RUN_TAG);
            }
            serializer.endTag(NS, RUN_HISTORY_TAG);
        }
        serializer.startTag(NS, SUMMARY_TAG);
        serializer.attribute(NS, PASS_ATTR, Long.toString(holder.passedTests));
        serializer.attribute(NS, FAILED_ATTR, Long.toString(holder.failedTests));
        serializer.attribute(NS, MODULES_DONE_ATTR, Integer.toString(holder.completeModules));
        serializer.attribute(NS, MODULES_TOTAL_ATTR, Integer.toString(holder.totalModules));
        serializer.endTag(NS, SUMMARY_TAG);
        List<TestRunResult> sortedModuleList = this.sortModules(holder.runResults, holder.modulesAbi);
        for (TestRunResult module : sortedModuleList) {
            serializer.startTag(NS, MODULE_TAG);
            if (holder.modulesAbi.get(module.getName()) != null) {
                String moduleAbi = holder.modulesAbi.get(module.getName()).getName();
                String moduleNameStripped = module.getName().replace(moduleAbi + " ", "");
                serializer.attribute(NS, NAME_ATTR, moduleNameStripped);
                serializer.attribute(NS, ABI_ATTR, moduleAbi);
            } else {
                serializer.attribute(NS, NAME_ATTR, module.getName());
            }
            serializer.attribute(NS, RUNTIME_ATTR, String.valueOf(module.getElapsedTime()));
            boolean isDone = module.isRunComplete() && !module.isRunFailure();
            serializer.attribute(NS, DONE_ATTR, Boolean.toString(isDone));
            serializer.attribute(NS, PASS_ATTR, Integer.toString(module.getNumTestsInState(TestResult.TestStatus.PASSED)));
            serializer.attribute(NS, TOTAL_TESTS_ATTR, Integer.toString(module.getNumTests()));
            if (!isDone) {
                String message2 = module.getRunFailureMessage();
                if (message2 == null) {
                    message2 = "Run was incomplete. Some tests might not have finished.";
                }
                FailureDescription failureDescription = module.getRunFailureDescription();
                serializer.startTag(NS, MODULES_NOT_DONE_REASON);
                serializer.attribute(NS, MESSAGE_ATTR, this.sanitizeXmlContent(message2));
                if (failureDescription != null && failureDescription.getErrorIdentifier() != null) {
                    serializer.attribute(NS, ERROR_NAME_ATTR, failureDescription.getErrorIdentifier().name());
                    serializer.attribute(NS, ERROR_CODE_ATTR, Long.toString(failureDescription.getErrorIdentifier().code()));
                }
                serializer.endTag(NS, MODULES_NOT_DONE_REASON);
            }
            this.serializeTestCases(serializer, module.getTestResults());
            serializer.endTag(NS, MODULE_TAG);
        }
        serializer.endDocument();
        return resultFile;
    }

    private void serializeTestCases(XmlSerializer serializer, Map<TestDescription, TestResult> results) throws IllegalArgumentException, IllegalStateException, IOException {
        LinkedHashMap format = new LinkedHashMap();
        for (Map.Entry<TestDescription, TestResult> cr : results.entrySet()) {
            if (format.get(cr.getKey().getClassName()) == null) {
                format.put(cr.getKey().getClassName(), new LinkedHashMap());
            }
            Map methodResult = (Map)format.get(cr.getKey().getClassName());
            methodResult.put(cr.getKey().getTestName(), cr.getValue());
        }
        for (String className : format.keySet()) {
            serializer.startTag(NS, CASE_TAG);
            serializer.attribute(NS, NAME_ATTR, className);
            for (Map.Entry<String, TestResult> entry : ((Map)format.get(className)).entrySet()) {
                TestResult.TestStatus status = ((TestResult)entry.getValue()).getStatus();
                if (status == null) continue;
                serializer.startTag(NS, TEST_TAG);
                serializer.attribute(NS, RESULT_ATTR, XmlSuiteResultFormatter.getTestStatusCompatibilityString(status));
                serializer.attribute(NS, NAME_ATTR, (String)entry.getKey());
                if (TestResult.TestStatus.IGNORED.equals((Object)status)) {
                    serializer.attribute(NS, SKIPPED_ATTR, Boolean.toString(true));
                }
                this.handleTestFailure(serializer, entry);
                XmlSuiteResultFormatter.HandleLoggedFiles(serializer, entry);
                for (Map.Entry<String, String> metric : TfMetricProtoUtil.compatibleConvert(entry.getValue().getProtoMetrics()).entrySet()) {
                    serializer.startTag(NS, METRIC_TAG);
                    serializer.attribute(NS, METRIC_KEY, metric.getKey());
                    serializer.text(this.sanitizeXmlContent(metric.getValue()));
                    serializer.endTag(NS, METRIC_TAG);
                }
                serializer.endTag(NS, TEST_TAG);
            }
            serializer.endTag(NS, CASE_TAG);
        }
    }

    private void handleTestFailure(XmlSerializer serializer, Map.Entry<String, TestResult> testResult) throws IllegalArgumentException, IllegalStateException, IOException {
        String fullStack = testResult.getValue().getStackTrace();
        if (fullStack != null) {
            int index = fullStack.indexOf(10);
            String message2 = index < 0 ? fullStack : fullStack.substring(0, index);
            ErrorIdentifier errorIdentifier = testResult.getValue().getFailure().getErrorIdentifier();
            String truncatedStackTrace = XmlSuiteResultFormatter.getTruncatedStackTrace(fullStack, testResult.getKey());
            serializer.startTag(NS, FAILURE_TAG);
            serializer.attribute(NS, MESSAGE_ATTR, this.sanitizeXmlContent(message2));
            if (errorIdentifier != null) {
                serializer.attribute(NS, ERROR_NAME_ATTR, errorIdentifier.name());
                serializer.attribute(NS, ERROR_CODE_ATTR, Long.toString(errorIdentifier.code()));
            }
            serializer.startTag(NS, STACK_TAG);
            serializer.text(this.sanitizeXmlContent(truncatedStackTrace));
            serializer.endTag(NS, STACK_TAG);
            serializer.endTag(NS, FAILURE_TAG);
        }
    }

    private static String getTruncatedStackTrace(String fullStackTrace, String testCaseName) {
        if (fullStackTrace == null) {
            return null;
        }
        if (fullStackTrace.length() > 0x100000) {
            LogUtil.CLog.i("The stack trace for test case %s contains %d characters, and has been truncated to %d characters in %s.", testCaseName, fullStackTrace.length(), 0x100000, TEST_RESULT_FILE_NAME);
            return fullStackTrace.substring(0, 0x100000);
        }
        return fullStackTrace;
    }

    private static void HandleLoggedFiles(XmlSerializer serializer, Map.Entry<String, TestResult> testResult) throws IllegalArgumentException, IllegalStateException, IOException {
        Map<String, LogFile> loggedFiles = testResult.getValue().getLoggedFiles();
        if (loggedFiles == null || loggedFiles.isEmpty()) {
            return;
        }
        for (String key : loggedFiles.keySet()) {
            switch (loggedFiles.get(key).getType()) {
                case BUGREPORT: {
                    XmlSuiteResultFormatter.addLogIfNotNull(serializer, BUGREPORT_TAG, key, loggedFiles.get(key).getUrl());
                    break;
                }
                case LOGCAT: {
                    XmlSuiteResultFormatter.addLogIfNotNull(serializer, LOGCAT_TAG, key, loggedFiles.get(key).getUrl());
                    break;
                }
                case PNG: 
                case JPEG: {
                    XmlSuiteResultFormatter.addLogIfNotNull(serializer, SCREENSHOT_TAG, key, loggedFiles.get(key).getUrl());
                    break;
                }
            }
        }
    }

    private static void addLogIfNotNull(XmlSerializer serializer, String tag, String key, String text) throws IllegalArgumentException, IllegalStateException, IOException {
        if (text == null) {
            LogUtil.CLog.d("Text for tag '%s' and key '%s' is null. skipping it.", tag, key);
            return;
        }
        serializer.startTag(NS, tag);
        serializer.attribute(NS, LOG_FILE_NAME_ATTR, key);
        serializer.text(text);
        serializer.endTag(NS, tag);
    }

    private static String toReadableDateString(long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        return dateFormat.format(new Date(time));
    }

    private static String getTestStatusCompatibilityString(TestResult.TestStatus status) {
        switch (status) {
            case PASSED: {
                return PASS_ATTR;
            }
            case FAILURE: {
                return "fail";
            }
        }
        return status.toString();
    }

    private static TestResult.TestStatus getStatusFromString(String status) {
        switch (status) {
            case "pass": {
                return TestResult.TestStatus.PASSED;
            }
            case "fail": {
                return TestResult.TestStatus.FAILURE;
            }
        }
        return TestResult.TestStatus.valueOf(status);
    }

    @Override
    public SuiteResultHolder parseResults(File resultDir, boolean shallow) throws IOException {
        File resultFile = new File(resultDir, TEST_RESULT_FILE_NAME);
        if (!resultFile.exists()) {
            LogUtil.CLog.e("Could not find %s for loading the results.", resultFile.getAbsolutePath());
            return null;
        }
        SuiteResultHolder invocation = new SuiteResultHolder();
        InvocationContext context = new InvocationContext();
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = factory.newPullParser();
            parser.setInput(new FileReader(resultFile));
            parser.nextTag();
            parser.require(2, NS, RESULT_TAG);
            invocation.startTime = Long.valueOf(parser.getAttributeValue(NS, START_TIME_ATTR));
            invocation.endTime = Long.valueOf(parser.getAttributeValue(NS, END_TIME_ATTR));
            invocation.hostName = parser.getAttributeValue(NS, HOST_NAME_ATTR);
            context.addInvocationAttribute(COMMAND_LINE_ARGS, parser.getAttributeValue(NS, COMMAND_LINE_ARGS));
            this.parseSuiteAttributes(parser, context);
            String deviceList = parser.getAttributeValue(NS, DEVICES_ATTR);
            int i = 0;
            for (String device : deviceList.split(",")) {
                context.addSerialsFromShard(i, Arrays.asList(device));
                ++i;
            }
            parser.nextTag();
            parser.require(2, NS, BUILD_TAG);
            for (int index = 0; index < parser.getAttributeCount(); ++index) {
                String key = parser.getAttributeName(index);
                String value = parser.getAttributeValue(NS, key);
                context.addInvocationAttribute(key, value);
            }
            this.parseBuildInfoAttributes(parser, context);
            parser.nextTag();
            parser.require(3, NS, BUILD_TAG);
            parser.nextTag();
            boolean hasRunHistoryTag = true;
            try {
                parser.require(2, NS, RUN_HISTORY_TAG);
            }
            catch (XmlPullParserException e) {
                hasRunHistoryTag = false;
            }
            if (hasRunHistoryTag) {
                this.handleRunHistoryLevel(parser);
            }
            parser.require(2, NS, SUMMARY_TAG);
            invocation.completeModules = Integer.parseInt(parser.getAttributeValue(NS, MODULES_DONE_ATTR));
            invocation.totalModules = Integer.parseInt(parser.getAttributeValue(NS, MODULES_TOTAL_ATTR));
            invocation.passedTests = Integer.parseInt(parser.getAttributeValue(NS, PASS_ATTR));
            invocation.failedTests = Integer.parseInt(parser.getAttributeValue(NS, FAILED_ATTR));
            parser.nextTag();
            parser.require(3, NS, SUMMARY_TAG);
            if (!shallow) {
                ArrayList<TestRunResult> results = new ArrayList<TestRunResult>();
                HashMap<String, IAbi> moduleAbis = new HashMap<String, IAbi>();
                this.handleModuleLevel(parser, results, moduleAbis);
                parser.require(3, NS, RESULT_TAG);
                invocation.runResults = results;
                invocation.modulesAbi = moduleAbis;
            }
        }
        catch (XmlPullParserException e) {
            LogUtil.CLog.e(e);
            return null;
        }
        invocation.context = context;
        return invocation;
    }

    List<TestRunResult> sortModules(Collection<TestRunResult> results, final Map<String, IAbi> moduleAbis) {
        ArrayList<TestRunResult> sortedList = new ArrayList<TestRunResult>(results);
        Collections.sort(sortedList, new Comparator<TestRunResult>(){

            @Override
            public int compare(TestRunResult o1, TestRunResult o2) {
                int res;
                String module1NameStripped = o1.getName();
                String module1Abi = "";
                if (moduleAbis.get(module1NameStripped) != null) {
                    module1Abi = ((IAbi)moduleAbis.get(module1NameStripped)).getName();
                    module1NameStripped = module1NameStripped.replace(module1Abi + " ", "");
                }
                String module2NameStripped = o2.getName();
                String module2Abi = "";
                if (moduleAbis.get(module2NameStripped) != null) {
                    module2Abi = ((IAbi)moduleAbis.get(module2NameStripped)).getName();
                    module2NameStripped = module2NameStripped.replace(module2Abi + " ", "");
                }
                if ((res = module1NameStripped.compareTo(module2NameStripped)) != 0) {
                    return res;
                }
                return module1Abi.compareTo(module2Abi);
            }
        });
        return sortedList;
    }

    private void handleRunHistoryLevel(XmlPullParser parser) throws IOException, XmlPullParserException {
        while (parser.nextTag() == 2) {
            parser.require(2, NS, RUN_TAG);
            parser.nextTag();
            parser.require(3, NS, RUN_TAG);
        }
        parser.require(3, NS, RUN_HISTORY_TAG);
        parser.nextTag();
    }

    private void handleModuleLevel(XmlPullParser parser, Collection<TestRunResult> results, Map<String, IAbi> moduleAbis) throws IOException, XmlPullParserException {
        while (parser.nextTag() == 2) {
            parser.require(2, NS, MODULE_TAG);
            TestRunResult module = new TestRunResult();
            results.add(module);
            String name = parser.getAttributeValue(NS, NAME_ATTR);
            String abi = parser.getAttributeValue(NS, ABI_ATTR);
            String moduleId = name;
            if (abi != null) {
                moduleId = AbiUtils.createId(abi, name);
                moduleAbis.put(moduleId, new Abi(abi, AbiUtils.getBitness(abi)));
            }
            long moduleElapsedTime = Long.parseLong(parser.getAttributeValue(NS, RUNTIME_ATTR));
            boolean moduleDone = Boolean.parseBoolean(parser.getAttributeValue(NS, DONE_ATTR));
            int totalTests = Integer.parseInt(parser.getAttributeValue(NS, TOTAL_TESTS_ATTR));
            module.testRunStarted(moduleId, totalTests);
            while (parser.nextTag() == 2) {
                if (parser.getName().equals(MODULES_NOT_DONE_REASON)) {
                    parser.require(2, NS, MODULES_NOT_DONE_REASON);
                    parser.nextTag();
                    parser.require(3, NS, MODULES_NOT_DONE_REASON);
                    continue;
                }
                parser.require(2, NS, CASE_TAG);
                String className = parser.getAttributeValue(NS, NAME_ATTR);
                this.handleTestCaseLevel(parser, module, className);
                parser.require(3, NS, CASE_TAG);
            }
            module.testRunEnded(moduleElapsedTime, new HashMap<String, MetricMeasurement.Metric>());
            module.setRunComplete(moduleDone);
            parser.require(3, NS, MODULE_TAG);
        }
    }

    private void handleTestCaseLevel(XmlPullParser parser, TestRunResult currentModule, String className) throws IOException, XmlPullParserException {
        while (parser.nextTag() == 2) {
            parser.require(2, NS, TEST_TAG);
            String methodName = parser.getAttributeValue(NS, NAME_ATTR);
            TestResult.TestStatus status = XmlSuiteResultFormatter.getStatusFromString(parser.getAttributeValue(NS, RESULT_ATTR));
            TestDescription description = new TestDescription(className, methodName);
            currentModule.testStarted(description);
            if (TestResult.TestStatus.IGNORED.equals((Object)status)) {
                currentModule.testIgnored(description);
            }
            HashMap<String, MetricMeasurement.Metric> metrics = new HashMap<String, MetricMeasurement.Metric>();
            while (parser.nextTag() == 2) {
                if (parser.getName().equals(FAILURE_TAG)) {
                    String failure = parser.getAttributeValue(NS, MESSAGE_ATTR);
                    if (parser.nextTag() == 2) {
                        parser.require(2, NS, STACK_TAG);
                        failure = parser.nextText();
                        parser.require(3, NS, STACK_TAG);
                    }
                    if (TestResult.TestStatus.FAILURE.equals((Object)status)) {
                        currentModule.testFailed(description, failure);
                    } else if (TestResult.TestStatus.ASSUMPTION_FAILURE.equals((Object)status)) {
                        currentModule.testAssumptionFailure(description, failure);
                    }
                    parser.nextTag();
                    parser.require(3, NS, FAILURE_TAG);
                }
                XmlSuiteResultFormatter.parseLoggedFiles(parser, currentModule);
                metrics.putAll(XmlSuiteResultFormatter.parseMetrics(parser));
            }
            currentModule.testEnded(description, metrics);
            parser.require(3, NS, TEST_TAG);
        }
    }

    private static void parseLoggedFiles(XmlPullParser parser, TestRunResult currentModule) throws XmlPullParserException, IOException {
        if (parser.getName().equals(BUGREPORT_TAG)) {
            XmlSuiteResultFormatter.parseSingleFiles(parser, currentModule, BUGREPORT_TAG, LogDataType.BUGREPORTZ);
        } else if (parser.getName().equals(LOGCAT_TAG)) {
            XmlSuiteResultFormatter.parseSingleFiles(parser, currentModule, LOGCAT_TAG, LogDataType.LOGCAT);
        } else if (parser.getName().equals(SCREENSHOT_TAG)) {
            XmlSuiteResultFormatter.parseSingleFiles(parser, currentModule, SCREENSHOT_TAG, LogDataType.PNG);
        }
    }

    private static void parseSingleFiles(XmlPullParser parser, TestRunResult currentModule, String tagName, LogDataType type) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue(NS, LOG_FILE_NAME_ATTR);
        String logFileUrl = parser.nextText();
        currentModule.testLogSaved(name, new LogFile(logFileUrl, logFileUrl, type));
        parser.require(3, NS, tagName);
    }

    private static HashMap<String, MetricMeasurement.Metric> parseMetrics(XmlPullParser parser) throws XmlPullParserException, IOException {
        HashMap<String, MetricMeasurement.Metric> metrics = new HashMap<String, MetricMeasurement.Metric>();
        if (parser.getName().equals(METRIC_TAG)) {
            parser.require(2, NS, METRIC_TAG);
            for (int index = 0; index < parser.getAttributeCount(); ++index) {
                String key = parser.getAttributeValue(index);
                String value = parser.nextText();
                metrics.put(key, TfMetricProtoUtil.stringToMetric(value));
            }
            parser.require(3, NS, METRIC_TAG);
        }
        return metrics;
    }

    protected String sanitizeXmlContent(String s) {
        return XmlEscapers.xmlContentEscaper().escape(s);
    }

    private static String sanitizeAttributesKey(String attribute) {
        return attribute.replace(":", "_");
    }

    private static void addBuildInfoAttributesIfNotNull(XmlSerializer serializer, IBuildInfo buildInfo, String attributeName) throws IOException {
        String attributeValue = buildInfo.getBuildAttributes().get(attributeName);
        if (attributeValue != null) {
            serializer.attribute(NS, attributeName, attributeValue);
        }
    }

    public static final class RunHistory {
        public long startTime;
        public long endTime;
        public long passedTests;
        public long failedTests;
        public String commandLineArgs;
        public String hostName;
    }
}

