/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.retry;

import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.EventsLoggerListener;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.MultiFailureDescription;
import com.android.tradefed.result.ResultAndLogForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.retry.ISupportGranularResults;
import com.android.tradefed.retry.MergeStrategy;
import com.android.tradefed.retry.RetryStrategy;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ResultAggregator
extends CollectingTestListener {
    private ResultAndLogForwarder mAllForwarder;
    private ResultAndLogForwarder mAggregatedForwarder;
    private ResultAndLogForwarder mDetailedForwarder;
    private RetryStrategy mRetryStrategy;
    private boolean mModuleInProgress = false;
    private TestRunResult mDetailedRunResults = null;
    private boolean mShouldReportFailure = true;
    private List<FailureDescription> mAllDetailedFailures = new ArrayList<FailureDescription>();
    private Map<String, LogFile> mDetailedModuleLogs = new LinkedHashMap<String, LogFile>();
    private boolean mUpdatedDetailedReporting = false;
    private boolean mUnorderedRetry = true;
    private boolean mRunStartCalled = false;
    private final Map<String, List<TestRunResult>> mPureRunResultForAgg = new LinkedHashMap<String, List<TestRunResult>>();
    private ILogSaver mLogSaver;
    private EventsLoggerListener mAggregatedEventsLogger;
    private EventsLoggerListener mDetailedEventsLogger;

    public ResultAggregator(List<ITestInvocationListener> listeners, RetryStrategy strategy) {
        List<ITestInvocationListener> supportDetails = listeners.stream().filter(i -> i instanceof ISupportGranularResults && ((ISupportGranularResults)i).supportGranularResults()).collect(Collectors.toList());
        List<ITestInvocationListener> noSupportDetails = listeners.stream().filter(i -> !(i instanceof ISupportGranularResults) || !((ISupportGranularResults)i).supportGranularResults()).collect(Collectors.toList());
        this.mDetailedEventsLogger = new EventsLoggerListener("detailed-events");
        supportDetails.add(this.mDetailedEventsLogger);
        this.mAggregatedEventsLogger = new EventsLoggerListener("aggregated-events");
        noSupportDetails.add(this.mAggregatedEventsLogger);
        this.mAggregatedForwarder = new ResultAndLogForwarder(noSupportDetails);
        this.mDetailedForwarder = new ResultAndLogForwarder(supportDetails);
        ArrayList<ITestInvocationListener> allListeners = new ArrayList<ITestInvocationListener>(listeners);
        allListeners.add(this.mDetailedEventsLogger);
        allListeners.add(this.mAggregatedEventsLogger);
        this.mAllForwarder = new ResultAndLogForwarder(allListeners);
        this.mRetryStrategy = strategy;
        MergeStrategy mergeStrategy = MergeStrategy.getMergeStrategy(this.mRetryStrategy);
        this.setMergeStrategy(mergeStrategy);
    }

    public void setUpdatedReporting(boolean updatedReporting) {
        this.mUpdatedDetailedReporting = updatedReporting;
    }

    @Override
    public void invocationStarted(IInvocationContext context) {
        super.invocationStarted(context);
        this.mAllForwarder.invocationStarted(context);
    }

    @Override
    public void invocationFailed(Throwable cause) {
        super.invocationFailed(cause);
        this.mAllForwarder.invocationFailed(cause);
    }

    @Override
    public void invocationFailed(FailureDescription failure) {
        super.invocationFailed(failure);
        this.mAllForwarder.invocationFailed(failure);
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        if (!this.mPureRunResultForAgg.isEmpty()) {
            for (String string : this.mPureRunResultForAgg.keySet()) {
                this.forwardTestRunResults(this.mPureRunResultForAgg.get(string), this.mAggregatedForwarder);
            }
            this.mPureRunResultForAgg.clear();
        }
        this.forwardDetailedFailure();
        for (Map.Entry entry : this.mDetailedModuleLogs.entrySet()) {
            this.mDetailedForwarder.logAssociation((String)entry.getKey(), (LogFile)entry.getValue());
        }
        this.mDetailedModuleLogs.clear();
        super.invocationEnded(elapsedTime);
        this.forwardAggregatedInvocationLogs();
        this.mAggregatedEventsLogger.invocationEnded(elapsedTime);
        this.saveEventsLog(this.mAggregatedEventsLogger.getLoggedEvents(), "aggregated-events");
        this.mDetailedEventsLogger.invocationEnded(elapsedTime);
        this.saveEventsLog(this.mDetailedEventsLogger.getLoggedEvents(), "detailed-events");
        this.mAllForwarder.invocationEnded(elapsedTime);
    }

    public final void forwardAggregatedInvocationLogs() {
        for (String key : this.getNonAssociatedLogFiles().keySet()) {
            for (LogFile log : this.getNonAssociatedLogFiles().get(key)) {
                this.mAggregatedForwarder.logAssociation(key, log);
            }
        }
    }

    public void cleanEventsFiles() {
        if (this.mAggregatedEventsLogger != null) {
            FileUtil.deleteFile(this.mAggregatedEventsLogger.getLoggedEvents());
        }
        if (this.mDetailedEventsLogger != null) {
            FileUtil.deleteFile(this.mDetailedEventsLogger.getLoggedEvents());
        }
    }

    @Override
    public void testModuleStarted(IInvocationContext moduleContext) {
        this.mUnorderedRetry = false;
        this.mRunStartCalled = false;
        if (!this.mPureRunResultForAgg.isEmpty()) {
            for (String name : this.mPureRunResultForAgg.keySet()) {
                this.forwardTestRunResults(this.mPureRunResultForAgg.get(name), this.mAggregatedForwarder);
            }
            this.mPureRunResultForAgg.clear();
        }
        this.mShouldReportFailure = true;
        if (this.mDetailedRunResults != null) {
            this.forwardDetailedFailure();
        }
        this.mModuleInProgress = true;
        super.testModuleStarted(moduleContext);
        this.mAllForwarder.testModuleStarted(moduleContext);
    }

    @Override
    public void setLogSaver(ILogSaver logSaver) {
        this.mLogSaver = logSaver;
        super.setLogSaver(logSaver);
        this.mAllForwarder.setLogSaver(logSaver);
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        super.testLog(dataName, dataType, dataStream);
        this.mAllForwarder.testLog(dataName, dataType, dataStream);
    }

    @Override
    public void testRunStarted(String name, int testCount, int attemptNumber, long startTime) {
        this.mRunStartCalled = true;
        if (!this.mUnorderedRetry && !this.mPureRunResultForAgg.isEmpty() && this.mPureRunResultForAgg.get(name) != null) {
            this.forwardTestRunResults(this.mPureRunResultForAgg.get(name), this.mAggregatedForwarder);
            this.mPureRunResultForAgg.remove(name);
        }
        if (!this.mUpdatedDetailedReporting && this.mDetailedRunResults != null) {
            if (this.mDetailedRunResults.getName().equals(name)) {
                if (!this.mDetailedRunResults.isRunFailure() && RetryStrategy.RETRY_ANY_FAILURE.equals((Object)this.mRetryStrategy)) {
                    this.mShouldReportFailure = false;
                }
                this.mDetailedForwarder.testRunEnded(this.mDetailedRunResults.getElapsedTime(), this.mDetailedRunResults.getRunProtoMetrics());
                this.mDetailedRunResults = null;
            } else {
                this.mShouldReportFailure = true;
                this.forwardDetailedFailure();
            }
        }
        super.testRunStarted(name, testCount, attemptNumber, startTime);
        this.mDetailedForwarder.testRunStarted(name, testCount, attemptNumber, startTime);
    }

    @Override
    public void testRunFailed(String errorMessage) {
        super.testRunFailed(errorMessage);
        if (this.mUpdatedDetailedReporting) {
            this.mDetailedForwarder.testRunFailed(errorMessage);
        }
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        super.testRunFailed(failure);
        if (this.mUpdatedDetailedReporting) {
            this.mDetailedForwarder.testRunFailed(failure);
        }
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        super.testStarted(test, startTime);
        this.mDetailedForwarder.testStarted(test, startTime);
    }

    @Override
    public void testIgnored(TestDescription test) {
        super.testIgnored(test);
        this.mDetailedForwarder.testIgnored(test);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, String trace) {
        super.testAssumptionFailure(test, trace);
        this.mDetailedForwarder.testAssumptionFailure(test, trace);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        super.testAssumptionFailure(test, failure);
        this.mDetailedForwarder.testAssumptionFailure(test, failure);
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        super.testFailed(test, trace);
        this.mDetailedForwarder.testFailed(test, trace);
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        super.testFailed(test, failure);
        this.mDetailedForwarder.testFailed(test, failure);
    }

    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        super.testEnded(test, endTime, testMetrics);
        this.mDetailedForwarder.testEnded(test, endTime, testMetrics);
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        super.logAssociation(dataName, logFile);
        if (this.mDetailedRunResults != null) {
            this.mDetailedModuleLogs.put(dataName, logFile);
        } else {
            this.mDetailedForwarder.logAssociation(dataName, logFile);
        }
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        super.testLogSaved(dataName, dataType, dataStream, logFile);
        this.mDetailedForwarder.testLogSaved(dataName, dataType, dataStream, logFile);
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        super.testRunEnded(elapsedTime, runMetrics);
        if (this.mUpdatedDetailedReporting) {
            this.mDetailedForwarder.testRunEnded(elapsedTime, runMetrics);
        } else {
            this.mDetailedRunResults = this.getCurrentRunResults();
            if (this.mDetailedRunResults.isRunFailure()) {
                FailureDescription currentFailure = this.mDetailedRunResults.getRunFailureDescription();
                if (currentFailure instanceof MultiFailureDescription) {
                    this.mAllDetailedFailures.addAll(((MultiFailureDescription)currentFailure).getFailures());
                } else {
                    this.mAllDetailedFailures.add(currentFailure);
                }
            }
        }
        if (!this.mModuleInProgress) {
            List results = this.mPureRunResultForAgg.getOrDefault(this.getCurrentRunResults().getName(), new ArrayList());
            results.add(this.getCurrentRunResults());
            this.mPureRunResultForAgg.put(this.getCurrentRunResults().getName(), results);
        }
    }

    @Override
    public void testModuleEnded() {
        if (!this.mUpdatedDetailedReporting) {
            this.forwardDetailedFailure();
            for (Map.Entry<String, LogFile> assos : this.mDetailedModuleLogs.entrySet()) {
                this.mDetailedForwarder.logAssociation(assos.getKey(), assos.getValue());
            }
            this.mDetailedModuleLogs.clear();
        }
        this.mModuleInProgress = false;
        super.testModuleEnded();
        this.mDetailedForwarder.testModuleEnded();
        if (this.mRunStartCalled) {
            List<TestRunResult> mergedResults = this.getMergedTestRunResults();
            HashSet<String> resultNames = new HashSet<String>();
            int expectedTestCount = 0;
            for (TestRunResult result : mergedResults) {
                expectedTestCount += result.getExpectedTestCount();
                resultNames.add(result.getName());
            }
            this.mAggregatedForwarder.testRunStarted(this.getCurrentRunResults().getName(), expectedTestCount, 0, this.getCurrentRunResults().getStartTime());
            for (TestRunResult runResult : mergedResults) {
                this.forwardTestResults(runResult.getTestResults(), this.mAggregatedForwarder);
                if (runResult.isRunFailure()) {
                    this.mAggregatedForwarder.testRunFailed(runResult.getRunFailureDescription());
                }
                for (String key : runResult.getRunLoggedFiles().keySet()) {
                    for (LogFile logFile : runResult.getRunLoggedFiles().get(key)) {
                        this.mAggregatedForwarder.logAssociation(key, logFile);
                    }
                }
            }
            this.mAggregatedForwarder.testRunEnded(this.getCurrentRunResults().getElapsedTime(), this.getCurrentRunResults().getRunProtoMetrics());
            for (String name : resultNames) {
                this.clearResultsForName(name);
            }
        }
        for (String key : this.getModuleLogFiles().keySet()) {
            for (LogFile log : this.getModuleLogFiles().get(key)) {
                this.mAggregatedForwarder.logAssociation(key, log);
            }
        }
        this.clearModuleLogFiles();
        this.mAggregatedForwarder.testModuleEnded();
        this.mUnorderedRetry = true;
    }

    @VisibleForTesting
    String getInvocationMetricRunError() {
        return InvocationMetricLogger.getInvocationMetrics().get(InvocationMetricLogger.InvocationMetricKey.CLEARED_RUN_ERROR.toString());
    }

    @VisibleForTesting
    void addInvocationMetricRunError(String errors) {
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.CLEARED_RUN_ERROR, errors);
    }

    private void forwardTestResults(Map<TestDescription, TestResult> testResults, ITestInvocationListener listener) {
        for (Map.Entry<TestDescription, TestResult> testEntry : testResults.entrySet()) {
            listener.testStarted(testEntry.getKey(), testEntry.getValue().getStartTime());
            switch (testEntry.getValue().getStatus()) {
                case FAILURE: {
                    listener.testFailed(testEntry.getKey(), testEntry.getValue().getFailure());
                    break;
                }
                case ASSUMPTION_FAILURE: {
                    listener.testAssumptionFailure(testEntry.getKey(), testEntry.getValue().getFailure());
                    break;
                }
                case IGNORED: {
                    listener.testIgnored(testEntry.getKey());
                    break;
                }
                case INCOMPLETE: {
                    listener.testFailed(testEntry.getKey(), FailureDescription.create("Test did not complete due to exception."));
                    break;
                }
            }
            for (Map.Entry<String, LogFile> logFile : testEntry.getValue().getLoggedFiles().entrySet()) {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(logFile.getKey(), logFile.getValue());
            }
            listener.testEnded(testEntry.getKey(), testEntry.getValue().getEndTime(), testEntry.getValue().getProtoMetrics());
        }
    }

    private void forwardTestRunResults(List<TestRunResult> results, ILogSaverListener listener) {
        TestRunResult result = TestRunResult.merge(results, MergeStrategy.getMergeStrategy(this.mRetryStrategy));
        listener.testRunStarted(result.getName(), result.getExpectedTestCount(), 0, result.getStartTime());
        this.forwardTestResults(result.getTestResults(), listener);
        if (result.isRunFailure()) {
            listener.testRunFailed(result.getRunFailureDescription());
        }
        for (String key : result.getRunLoggedFiles().keySet()) {
            for (LogFile logFile : result.getRunLoggedFiles().get(key)) {
                listener.logAssociation(key, logFile);
            }
        }
        listener.testRunEnded(result.getElapsedTime(), result.getRunProtoMetrics());
        this.clearResultsForName(result.getName());
    }

    private void forwardDetailedFailure() {
        if (this.mDetailedRunResults != null) {
            if (this.mDetailedRunResults.isRunFailure() && this.mShouldReportFailure) {
                if (this.mAllDetailedFailures.size() == 1) {
                    this.mDetailedForwarder.testRunFailed(this.mAllDetailedFailures.get(0));
                } else {
                    this.mDetailedForwarder.testRunFailed(new MultiFailureDescription(this.mAllDetailedFailures));
                }
            } else {
                ArrayList<String> invocationFailures = new ArrayList<String>();
                String value = this.getInvocationMetricRunError();
                if (value != null) {
                    invocationFailures.add(value);
                }
                if (!this.mAllDetailedFailures.isEmpty()) {
                    invocationFailures.add(new MultiFailureDescription(this.mAllDetailedFailures).toString());
                    this.addInvocationMetricRunError(String.join((CharSequence)"\n\n", invocationFailures));
                }
            }
            this.mAllDetailedFailures.clear();
            this.mDetailedForwarder.testRunEnded(this.mDetailedRunResults.getElapsedTime(), this.mDetailedRunResults.getRunProtoMetrics());
            this.mDetailedRunResults = null;
        }
    }

    private void saveEventsLog(File eventsLog, String key) {
        if (eventsLog != null && eventsLog.length() > 0L && this.mLogSaver != null) {
            try {
                LogFile logged = this.mLogSaver.saveLogFile(eventsLog.getName(), LogDataType.TF_EVENTS, eventsLog);
                if (logged != null) {
                    this.mAggregatedForwarder.logAssociation(key, logged);
                    this.mDetailedForwarder.logAssociation(key, logged);
                }
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
        FileUtil.deleteFile(eventsLog);
    }

    @VisibleForTesting
    protected File[] getEventsLogs() {
        File[] logs = new File[]{this.mAggregatedEventsLogger.getLoggedEvents(), this.mDetailedEventsLogger.getLoggedEvents()};
        return logs;
    }
}

