/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.retry;

import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.retry.BaseRetryDecision;
import com.android.tradefed.retry.RetryStatistics;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class RetryStatsHelper {
    private List<List<TestRunResult>> mResults = new ArrayList<List<TestRunResult>>();
    private RetryStatistics mStats = new RetryStatistics();

    RetryStatsHelper() {
    }

    public void addResultsFromRun(List<TestRunResult> mLatestResults) {
        this.addResultsFromRun(mLatestResults, 0L, 0);
    }

    public void addResultsFromRun(List<TestRunResult> mLatestResults, long timeForIsolation, int attempt) {
        if (!this.mResults.isEmpty()) {
            this.updateSuccess(this.mResults.get(this.mResults.size() - 1), mLatestResults);
        }
        if (timeForIsolation != 0L) {
            this.mStats.mAttemptIsolationCost.put(attempt, timeForIsolation);
        }
        this.mResults.add(mLatestResults);
    }

    public RetryStatistics calculateStatistics() {
        if (!this.mResults.isEmpty()) {
            List<TestRunResult> attemptResults = this.mResults.get(this.mResults.size() - 1);
            Set<TestDescription> attemptFailures = BaseRetryDecision.getFailedTestCases(attemptResults).keySet();
            this.mStats.mRetryFailure = attemptFailures.size();
        }
        return this.mStats;
    }

    private void updateSuccess(List<TestRunResult> previousResults, List<TestRunResult> latestResults) {
        Sets.SetView<TestDescription> diff = Sets.difference(BaseRetryDecision.getFailedTestCases(previousResults).keySet(), BaseRetryDecision.getFailedTestCases(latestResults).keySet());
        this.mStats.mRetrySuccess += (long)diff.size();
    }
}

