/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.sandbox;

import com.android.ddmlib.Log;
import com.android.tradefed.build.StubBuildProvider;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.SandboxConfigurationFactory;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.log.FileLogger;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.result.FileSystemLogSaver;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.SubprocessResultsReporter;
import com.android.tradefed.result.proto.StreamProtoResultReporter;
import com.android.tradefed.result.retry.ISupportGranularResults;
import com.android.tradefed.sandbox.SandboxOptions;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SandboxConfigDump {
    public static final Set<String> VERSIONED_ELEMENTS = new HashSet<String>();
    private static final Set<String> NON_TEST_ELEMENTS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int parse(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        DumpCmd cmd = DumpCmd.valueOf((String)argList.remove(0));
        File resFile = new File((String)argList.remove(0));
        SandboxConfigurationFactory factory = SandboxConfigurationFactory.getInstance();
        PrintWriter pw = null;
        try {
            IConfiguration config = factory.createConfigurationFromArgs(argList.toArray(new String[0]), cmd);
            if (DumpCmd.RUN_CONFIG.equals((Object)cmd) || DumpCmd.TEST_MODE.equals((Object)cmd)) {
                ILogSaver logSaver;
                config.getCommandOptions().setShouldUseSandboxing(false);
                config.getConfigurationDescription().setSandboxed(true);
                config.getCommandOptions().setReplicateSetup(false);
                for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
                    deviceConfig.addSpecificConfig(new StubBuildProvider(), "build_provider");
                }
                ISupportGranularResults reporter = null;
                if (this.getSandboxOptions(config).shouldUseProtoReporter()) {
                    reporter = new StreamProtoResultReporter();
                } else {
                    reporter = new SubprocessResultsReporter();
                    ((SubprocessResultsReporter)reporter).setOutputTestLog(true);
                }
                config.setTestInvocationListener(reporter);
                ILeveledLogOutput logger = config.getLogOutput();
                logger.setLogLevel(Log.LogLevel.VERBOSE);
                if (logger instanceof FileLogger) {
                    ((FileLogger)logger).setLogLevelDisplay(Log.LogLevel.VERBOSE);
                }
                if ((logSaver = config.getLogSaver()) instanceof FileSystemLogSaver) {
                    ((FileSystemLogSaver)logSaver).setCompressFiles(false);
                }
                this.secureDeviceAllocation(config);
                config.getCommandOptions().getInvocationData().put("subprocess", "true");
            }
            if (DumpCmd.TEST_MODE.equals((Object)cmd)) {
                config.getCommandOptions().setShouldUseSandboxing(true);
                config.getConfigurationDescription().setSandboxed(false);
                config.getCommandOptions().setUseSandboxTestMode(false);
            }
            pw = new PrintWriter(resFile);
            if (DumpCmd.NON_VERSIONED_CONFIG.equals((Object)cmd)) {
                config.dumpXml(pw, new ArrayList<String>(VERSIONED_ELEMENTS), true, false);
            } else if (DumpCmd.STRICT_TEST.equals((Object)cmd)) {
                config.dumpXml(pw, new ArrayList<String>(NON_TEST_ELEMENTS), true, false);
            } else {
                config.dumpXml(pw, new ArrayList<String>(), true, false);
            }
            StreamUtil.close(pw);
        }
        catch (ConfigurationException | IOException e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            StreamUtil.close(pw);
        }
        return 0;
    }

    public static void main(String[] mainArgs) {
        try {
            GlobalConfiguration.createGlobalConfiguration(new String[0]);
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        SandboxConfigDump configDump = new SandboxConfigDump();
        int code = configDump.parse(mainArgs);
        System.exit(code);
    }

    private SandboxOptions getSandboxOptions(IConfiguration config) {
        return (SandboxOptions)config.getConfigurationObject("sandbox_options");
    }

    private void secureDeviceAllocation(IConfiguration config) {
        for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
            IDeviceSelection requirements = deviceConfig.getDeviceRequirements();
            if (requirements.nullDeviceRequested() || requirements.tcpDeviceRequested() || requirements.gceDeviceRequested()) {
                requirements.setSerial(new String[0]);
            }
            requirements.setBaseDeviceTypeRequested(null);
            requirements.setRequireBatteryCheck(false);
        }
    }

    static {
        VERSIONED_ELEMENTS.add("system_checker");
        VERSIONED_ELEMENTS.add("metrics_collector");
        VERSIONED_ELEMENTS.add("multi_pre_target_preparer");
        VERSIONED_ELEMENTS.add("multi_target_preparer");
        VERSIONED_ELEMENTS.add("target_preparer");
        VERSIONED_ELEMENTS.add("test");
        NON_TEST_ELEMENTS = new HashSet<String>();
        NON_TEST_ELEMENTS.add("build_provider");
        NON_TEST_ELEMENTS.add("logger");
        NON_TEST_ELEMENTS.add("device_recovery");
        NON_TEST_ELEMENTS.add("log_saver");
        NON_TEST_ELEMENTS.add("result_reporter");
        NON_TEST_ELEMENTS.add("device_requirements");
        NON_TEST_ELEMENTS.add("device_options");
        NON_TEST_ELEMENTS.add("coverage");
        NON_TEST_ELEMENTS.add("retry_decision");
        NON_TEST_ELEMENTS.add("sandbox_options");
        NON_TEST_ELEMENTS.add("cmd_options");
        NON_TEST_ELEMENTS.add("config_desc");
        NON_TEST_ELEMENTS.add("global_filters");
        NON_TEST_ELEMENTS.add("skip_manager");
    }

    public static enum DumpCmd {
        FULL_XML,
        NON_VERSIONED_CONFIG,
        RUN_CONFIG,
        TEST_MODE,
        STRICT_TEST;

    }
}

