/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.sandbox;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.NoOpConfigOptionValueTransformer;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.sandbox.SandboxConfigDump;
import com.android.tradefed.sandbox.SandboxConfigurationException;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.TimeUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public class SandboxConfigUtil {
    private static final long DUMP_TIMEOUT = 300000L;

    public static File dumpConfigForVersion(String classpath, IRunUtil runUtil, String[] args, SandboxConfigDump.DumpCmd dump, File globalConfig) throws SandboxConfigurationException, IOException {
        return SandboxConfigUtil.dumpConfigForVersion(classpath, runUtil, args, dump, globalConfig, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static File dumpConfigForVersion(String classpath, IRunUtil runUtil, String[] args, SandboxConfigDump.DumpCmd dump, File globalConfig, boolean skipJavaCheck) throws SandboxConfigurationException, IOException {
        void var10_21;
        if (Strings.isNullOrEmpty(classpath)) {
            throw new SandboxConfigurationException("Something went wrong with the sandbox setup, classpath was empty.", (ErrorIdentifier)InfraErrorIdentifier.INTERNAL_CONFIG_ERROR);
        }
        runUtil.unsetEnvVariable("TF_GLOBAL_CONFIG");
        runUtil.unsetEnvVariable("TF_GLOBAL_CONFIG_SERVER_CONFIG");
        runUtil.unsetEnvVariable("PROTO_REPORTING_PORT");
        File destination = null;
        try {
            destination = FileUtil.createTempFile("config-container", ".xml");
            if (globalConfig != null) {
                runUtil.setEnvVariable("TF_GLOBAL_CONFIG", globalConfig.getAbsolutePath());
                runUtil.setEnvVariablePriority(IRunUtil.EnvPriority.SET);
            }
        }
        catch (IOException e) {
            FileUtil.deleteFile(globalConfig);
            FileUtil.deleteFile(destination);
            throw e;
        }
        File tmpDir = FileUtil.createTempDir("config-dump-temp-dir");
        CommandResult result = null;
        try {
            ArrayList<String> mCmdArgs = new ArrayList<String>();
            mCmdArgs.add(SystemUtil.getRunningJavaBinaryPath(skipJavaCheck).getAbsolutePath());
            mCmdArgs.add(String.format("-Djava.io.tmpdir=%s", tmpDir.getAbsolutePath()));
            mCmdArgs.add("-cp");
            mCmdArgs.add(classpath);
            mCmdArgs.add(SandboxConfigDump.class.getCanonicalName());
            mCmdArgs.add(dump.toString());
            mCmdArgs.add(destination.getAbsolutePath());
            for (String arg : args) {
                mCmdArgs.add(arg);
            }
            result = runUtil.runTimedCmd(300000L, mCmdArgs.toArray(new String[0]));
            if (CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
                File file2 = destination;
                return file2;
            }
        }
        finally {
            FileUtil.recursiveDelete(tmpDir);
        }
        if (result.getStderr() != null && !result.getStderr().isEmpty()) {
            LogUtil.CLog.d("stderr: %s\nstdout: %s", result.getStderr(), result.getStdout());
        }
        FileUtil.deleteFile(destination);
        String errorMessage = "Error when dumping the config.";
        if (CommandStatus.TIMED_OUT.equals((Object)result.getStatus())) {
            errorMessage = errorMessage + String.format(" Timed out after %s.", TimeUtil.formatElapsedTime(300000L));
        }
        errorMessage = errorMessage + String.format(" stderr: %s", result.getStderr());
        InfraErrorIdentifier infraErrorIdentifier = InfraErrorIdentifier.INTERNAL_CONFIG_ERROR;
        if (result.getStderr().contains(InfraErrorIdentifier.KEYSTORE_CONFIG_ERROR.name())) {
            InfraErrorIdentifier infraErrorIdentifier2 = InfraErrorIdentifier.KEYSTORE_CONFIG_ERROR;
        }
        if (result.getStderr().contains(InfraErrorIdentifier.CLASS_NOT_FOUND.name())) {
            InfraErrorIdentifier infraErrorIdentifier3 = InfraErrorIdentifier.CLASS_NOT_FOUND;
        }
        if (result.getStderr().contains(InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR.name())) {
            InfraErrorIdentifier infraErrorIdentifier4 = InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR;
        }
        if (result.getStderr().contains(InfraErrorIdentifier.GCS_ERROR.name())) {
            InfraErrorIdentifier infraErrorIdentifier5 = InfraErrorIdentifier.GCS_ERROR;
        }
        throw new SandboxConfigurationException(errorMessage, (ErrorIdentifier)var10_21);
    }

    public static File dumpConfigForVersion(File rootDir, IRunUtil runUtil, String[] args, SandboxConfigDump.DumpCmd dump, File globalConfig) throws ConfigurationException, IOException {
        String classpath = "";
        Set<String> jarFiles = FileUtil.findFiles(rootDir, ".*.jar");
        classpath = String.join((CharSequence)":", jarFiles);
        return SandboxConfigUtil.dumpConfigForVersion(classpath, runUtil, args, dump, globalConfig, false);
    }

    public static File dumpFilteredGlobalConfig(Set<String> exclusionPatterns) throws IOException {
        return GlobalConfiguration.getInstance().cloneConfigWithFilter(exclusionPatterns, new NoOpConfigOptionValueTransformer(), false, new String[0]);
    }
}

