/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.sandbox;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.sandbox.ISandbox;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.PrettyPrintDelimiter;

public class SandboxInvocationRunner {
    public static boolean prepareAndRun(TestInformation info, IConfiguration config, ITestInvocationListener listener) throws Throwable {
        SandboxInvocationRunner.prepareSandbox(info, config, listener);
        return SandboxInvocationRunner.runSandbox(info, config, listener);
    }

    public static void teardownSandbox(IConfiguration config) {
        ISandbox sandbox = (ISandbox)config.getConfigurationObject("sandbox");
        if (sandbox == null) {
            throw new RuntimeException("Couldn't find the sandbox object.");
        }
        sandbox.tearDown();
    }

    public static void prepareSandbox(TestInformation info, IConfiguration config, ITestInvocationListener listener) throws Throwable {
        ISandbox sandbox = (ISandbox)config.getConfigurationObject("sandbox");
        if (sandbox == null) {
            throw new RuntimeException("Couldn't find the sandbox object.");
        }
        PrettyPrintDelimiter.printStageDelimiter("Starting Sandbox Environment Setup");
        Exception res = null;
        try {
            res = sandbox.prepareEnvironment(info.getContext(), config, listener);
        }
        catch (RuntimeException e) {
            sandbox.tearDown();
            throw e;
        }
        if (res != null) {
            LogUtil.CLog.w("Sandbox prepareEnvironment threw an Exception.");
            sandbox.tearDown();
            throw res;
        }
        PrettyPrintDelimiter.printStageDelimiter("Done with Sandbox Environment Setup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runSandbox(TestInformation info, IConfiguration config, ITestInvocationListener listener) throws Throwable {
        ISandbox sandbox = (ISandbox)config.getConfigurationObject("sandbox");
        if (sandbox == null) {
            throw new RuntimeException("Couldn't find the sandbox object.");
        }
        try {
            CommandResult result = sandbox.run(info, config, listener);
            boolean bl = CommandStatus.SUCCESS.equals((Object)result.getStatus());
            return bl;
        }
        finally {
            sandbox.tearDown();
        }
    }
}

