/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.sandbox;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="sandbox", global_namespace=true)
public final class SandboxOptions {
    public static final String TF_LOCATION = "tf-location";
    public static final String SANDBOX_BUILD_ID = "sandbox-build-id";
    public static final String USE_PROTO_REPORTER = "use-proto-reporter";
    public static final String CHILD_GLOBAL_CONFIG = "sub-global-config";
    public static final String PARENT_PREPARER_CONFIG = "parent-preparer-config";
    public static final String WAIT_FOR_EVENTS_TIMEOUT = "wait-for-events";
    public static final String ENABLE_DEBUG_THREAD = "sandbox-debug-thread";
    private static final String SANDBOX_JAVA_OPTIONS = "sandbox-java-options";
    private static final String SANDBOX_ENV_VARIABLE_OPTIONS = "sandbox-env-variable";
    private static final String SANDBOX_TESTS_ZIPS_OPTIONS = "sandbox-tests-zips";
    private static final String ENABLE_DEFAULT_TESTS_ZIPS_OPTIONS = "sandbox-default-zips";
    private static final String DUMP_TEST_TEMPLATE = "dump-test-template";
    private static final String START_AVD_IN_PARENT = "avd-in-parent";
    private static final String PARALLEL_SANDBOX_SETUP = "parallel-sandbox-setup";
    private static final String UPDATED_FLAG_ORDER = "update-flag-orders";
    private static final String SANDBOX_USE_TEST_DISCOVERY = "sandbox-use-test-discovery";
    private static final String SANDBOX_FORCE_PARTIAL_DOWNLOAD_FILE_REGEX = "sandbox-force-partial-download-file-regex";
    private static final String SANDBOX_PARTIAL_DOWNLOAD_CACHE = "sandbox-use-partial-download-cache";
    private static final String SANDBOX_SPLIT_DISCOVERY = "sandbox-split-discovery";
    @Option(name="tf-location", description="The path to the Tradefed binary of the version to use for the sandbox.")
    private File mTfVersion = null;
    @Option(name="sandbox-build-id", description="Provide the build-id to force the sandbox version of Tradefed to be.Mutually exclusive with the tf-location option.")
    private String mBuildId = null;
    @Option(name="use-proto-reporter", description="Whether or not to use protobuf format reporting between processes.")
    private boolean mUseProtoReporter = true;
    @Option(name="sub-global-config", description="Force a particular configuration to be used as global configuration for the sandbox.")
    private String mChildGlobalConfig = null;
    @Option(name="parent-preparer-config", description="A configuration which target_preparers will be run in the parent of the sandbox.")
    private String mParentPreparerConfig = null;
    @Option(name="wait-for-events", isTimeVal=true, description="The time we should wait for all events to complete after the sandbox is done running.")
    private long mWaitForEventsTimeoutMs = 30000L;
    @Option(name="sandbox-debug-thread", description="Whether or not to enable a debug thread for sandbox.")
    private boolean mEnableDebugThread = false;
    @Option(name="sandbox-java-options", description="Pass options for the java process of the sandbox.")
    private List<String> mSandboxJavaOptions = new ArrayList<String>();
    @Option(name="sandbox-env-variable", description="Pass environment variable and its value to the sandbox process.")
    private Map<String, String> mSandboxEnvVariable = new LinkedHashMap<String, String>();
    @Option(name="sandbox-tests-zips", description="The set of tests zips to stage during sandboxing.")
    private Set<String> mSandboxTestsZips = new LinkedHashSet<String>();
    @Option(name="sandbox-default-zips", description="Whether or not to download the default tests zip when no sandbox-tests-zips has been specified")
    private boolean mEnableDefaultZips = true;
    @Option(name="dump-test-template", description="Whether or not to use the test template from sandbox version in fallback.")
    private boolean mDumpTestTemplate = false;
    @Option(name="avd-in-parent", description="Whether or not to start the avd device in the parent sandbox")
    private boolean mStartAvdInParent = true;
    @Option(name="parallel-sandbox-setup", description="Execute the sandbox setup step in parallel")
    private boolean mParallelSandboxSetup = true;
    @Option(name="update-flag-orders", description="Feature flag to test safely new flags order")
    private boolean mNewFlagOrder = true;
    @Option(name="sandbox-use-test-discovery", description="Feature flag to use observatory to discovery test modules for staging jars")
    private boolean mUseTestDiscovery = false;
    @Option(name="sandbox-force-partial-download-file-regex", description="The set of regex to force sandbox partial download always stage the files that match any of the regex in the list")
    private Set<String> mSandboxForcePartialDownloadFileRegexList = new HashSet<String>();
    @Option(name="sandbox-use-partial-download-cache", description="Feature flag to use partial download cache")
    private boolean mUsePartialDownloadCache = true;
    @Option(name="sandbox-split-discovery", description="Enable setup where discovery is done independently.")
    private boolean mUseSandboxSplitDiscovery = false;

    public File getSandboxTfDirectory() {
        return this.mTfVersion;
    }

    public String getSandboxBuildId() {
        return this.mBuildId;
    }

    public boolean shouldUseProtoReporter() {
        return this.mUseProtoReporter;
    }

    public String getChildGlobalConfig() {
        return this.mChildGlobalConfig;
    }

    public String getParentPreparerConfig() {
        return this.mParentPreparerConfig;
    }

    public long getWaitForEventsTimeout() {
        return this.mWaitForEventsTimeoutMs;
    }

    public boolean shouldEnableDebugThread() {
        return this.mEnableDebugThread;
    }

    public List<String> getJavaOptions() {
        return this.mSandboxJavaOptions;
    }

    public Map<String, String> getEnvVariables() {
        return this.mSandboxEnvVariable;
    }

    public Set<String> getTestsZips() {
        return this.mSandboxTestsZips;
    }

    public boolean downloadDefaultZips() {
        return this.mEnableDefaultZips;
    }

    public boolean dumpTestTemplate() {
        return this.mDumpTestTemplate;
    }

    public boolean startAvdInParent() {
        return this.mStartAvdInParent;
    }

    public boolean shouldParallelSetup() {
        return this.mParallelSandboxSetup;
    }

    public boolean shouldUseTestDiscovery() {
        return this.mUseTestDiscovery;
    }

    public boolean shouldUsePartialDownload() {
        return this.mUsePartialDownloadCache;
    }

    public Set<String> getForcePartialDownloadFileRegexList() {
        return this.mSandboxForcePartialDownloadFileRegexList;
    }

    public boolean shouldUseSplitDiscovery() {
        return this.mUseSandboxSplitDiscovery;
    }
}

