/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.sandbox;

import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.ConfigurationXmlParserSettings;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.IGlobalConfiguration;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.IDeviceSelection;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.proto.InvocationContext;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.proto.StreamProtoReceiver;
import com.android.tradefed.sandbox.ISandbox;
import com.android.tradefed.sandbox.SandboxConfigDump;
import com.android.tradefed.sandbox.SandboxConfigUtil;
import com.android.tradefed.sandbox.SandboxConfigurationException;
import com.android.tradefed.sandbox.SandboxOptions;
import com.android.tradefed.sandbox.TradefedSandboxRunner;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.PrettyPrintDelimiter;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SubprocessExceptionParser;
import com.android.tradefed.util.SubprocessTestResultsParser;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.keystore.IKeyStoreClient;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TradefedSandbox
implements ISandbox {
    private static final String SANDBOX_PREFIX = "sandbox-";
    public static final String SANDBOX_ENABLED = "SANDBOX_ENABLED";
    private static final String SANDBOX_JVM_OPTIONS_ENV_VAR_KEY = "TF_SANDBOX_JVM_OPTIONS";
    private File mStdoutFile = null;
    private File mStderrFile = null;
    private File mHeapDump = null;
    private File mSandboxTmpFolder = null;
    private File mRootFolder = null;
    private File mGlobalConfig = null;
    private File mSerializedContext = null;
    private File mSerializedConfiguration = null;
    private File mSerializedTestConfig = null;
    private SubprocessTestResultsParser mEventParser = null;
    private StreamProtoReceiver mProtoReceiver = null;
    private IRunUtil mRunUtil;

    protected String getJava() {
        return SystemUtil.getRunningJavaBinaryPath().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult run(TestInformation info, IConfiguration config, ITestLogger logger) throws Throwable {
        String stderrText;
        ArrayList<String> mCmdArgs = new ArrayList<String>();
        mCmdArgs.add(this.getJava());
        mCmdArgs.add(String.format("-Djava.io.tmpdir=%s", this.mSandboxTmpFolder.getAbsolutePath()));
        mCmdArgs.add(String.format("-DTF_JAR_DIR=%s", this.mRootFolder.getAbsolutePath()));
        try {
            this.mHeapDump = FileUtil.createTempDir("heap-dump", this.getWorkFolder());
            mCmdArgs.add("-XX:+HeapDumpOnOutOfMemoryError");
            mCmdArgs.add(String.format("-XX:HeapDumpPath=%s", this.mHeapDump.getAbsolutePath()));
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
        }
        SandboxOptions sandboxOptions = this.getSandboxOptions(config);
        mCmdArgs.addAll(sandboxOptions.getJavaOptions());
        if (System.getenv(SANDBOX_JVM_OPTIONS_ENV_VAR_KEY) != null) {
            mCmdArgs.addAll(Arrays.asList(System.getenv(SANDBOX_JVM_OPTIONS_ENV_VAR_KEY).split(",")));
        }
        mCmdArgs.add("-cp");
        mCmdArgs.add(this.createClasspath(this.mRootFolder));
        mCmdArgs.add(TradefedSandboxRunner.class.getCanonicalName());
        mCmdArgs.add(this.mSerializedContext.getAbsolutePath());
        mCmdArgs.add(this.mSerializedConfiguration.getAbsolutePath());
        if (this.mProtoReceiver != null) {
            mCmdArgs.add("--proto-report-port");
            mCmdArgs.add(Integer.toString(this.mProtoReceiver.getSocketServerPort()));
        } else {
            mCmdArgs.add("--subprocess-report-port");
            mCmdArgs.add(Integer.toString(this.mEventParser.getSocketServerPort()));
        }
        if (config.getCommandOptions().shouldUseSandboxTestMode()) {
            mCmdArgs.add("--use-sandbox");
        }
        if (sandboxOptions.startAvdInParent()) {
            LinkedHashSet<String> notifyAsNative = new LinkedHashSet<String>();
            for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
                if (!deviceConfig.getDeviceRequirements().gceDeviceRequested()) continue;
                String deviceName = config.getDeviceConfig().size() > 1 ? String.format("{%s}", deviceConfig.getDeviceName()) : "";
                mCmdArgs.add(String.format("--%sno-gce-device", deviceName));
                mCmdArgs.add(String.format("--%sserial", deviceName));
                mCmdArgs.add(info.getContext().getDevice(deviceConfig.getDeviceName()).getSerialNumber());
                if (DeviceSelectionOptions.DeviceRequestedType.GCE_DEVICE.equals((Object)((DeviceSelectionOptions)deviceConfig.getDeviceRequirements()).getDeviceTypeRequested())) {
                    mCmdArgs.add(String.format("--%sdevice-type", deviceName));
                    mCmdArgs.add(DeviceSelectionOptions.DeviceRequestedType.EXISTING_DEVICE.name());
                }
                if (!IDeviceSelection.BaseDeviceType.NATIVE_DEVICE.equals((Object)deviceConfig.getDeviceRequirements().getBaseDeviceTypeRequested())) continue;
                notifyAsNative.add(info.getContext().getDevice(deviceConfig.getDeviceName()).getSerialNumber());
            }
            if (!notifyAsNative.isEmpty()) {
                this.mRunUtil.setEnvVariable("NOTIFY_AS_NATIVE", Joiner.on(",").join(notifyAsNative));
            }
        }
        long timeout = Math.max(config.getCommandOptions().getInvocationTimeout() - 120000L, 0L);
        this.mRunUtil.allowInterrupt(true);
        CommandResult result = null;
        RuntimeException interruptedException = null;
        try {
            result = this.mRunUtil.runTimedCmdWithInput(timeout, null, this.mStdoutFile, this.mStderrFile, mCmdArgs.toArray(new String[0]));
        }
        catch (RuntimeException interrupted) {
            LogUtil.CLog.e("Sandbox runtimedCmd threw an exception");
            LogUtil.CLog.e(interrupted);
            interruptedException = interrupted;
            result = new CommandResult(CommandStatus.EXCEPTION);
            result.setStdout(StreamUtil.getStackTrace(interrupted));
        }
        boolean failedStatus = false;
        try {
            stderrText = FileUtil.readStringFromFile(this.mStderrFile);
        }
        catch (IOException e) {
            stderrText = "Could not read the stderr output from process.";
        }
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            failedStatus = true;
            result.setStderr(stderrText);
        }
        try {
            boolean joinResult = false;
            long waitTime = this.getSandboxOptions(config).getWaitForEventsTimeout();
            try (CloseableTraceScope ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.invocation_events_processing.toString());){
                joinResult = this.mProtoReceiver != null ? this.mProtoReceiver.joinReceiver(waitTime) : this.mEventParser.joinReceiver(waitTime);
            }
            if (interruptedException != null) {
                throw interruptedException;
            }
            if (!joinResult) {
                if (!failedStatus) {
                    result.setStatus(CommandStatus.EXCEPTION);
                }
                result.setStderr(String.format("%s:\n%s", "Event receiver thread did not complete.", stderrText));
            }
            PrettyPrintDelimiter.printStageDelimiter(String.format("Execution of the tests occurred in the sandbox, you can find its logs under the name pattern '%s*'", SANDBOX_PREFIX));
        }
        finally {
            if (this.mProtoReceiver != null) {
                this.mProtoReceiver.completeModuleEvents();
            }
            try (FileInputStreamSource contextFile = new FileInputStreamSource(this.mSerializedContext);){
                logger.testLog("sandbox-context", LogDataType.PB, contextFile);
            }
            if (this.mStdoutFile != null) {
                try (FileInputStreamSource sourceStdOut = new FileInputStreamSource(this.mStdoutFile);){
                    logger.testLog("sandbox-stdout", LogDataType.HARNESS_STD_LOG, sourceStdOut);
                }
            }
            try (FileInputStreamSource sourceStdErr = new FileInputStreamSource(this.mStderrFile);){
                logger.testLog("sandbox-stderr", LogDataType.HARNESS_STD_LOG, sourceStdErr);
            }
            this.logAndCleanHeapDump(this.mHeapDump, logger);
            this.mHeapDump = null;
        }
        if (result.getExitCode() != null) {
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.SANDBOX_EXIT_CODE, result.getExitCode().intValue());
        }
        if (this.mProtoReceiver != null && this.mProtoReceiver.hasInvocationFailed()) {
            return result;
        }
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            LogUtil.CLog.e("Sandbox finished with status: %s and exit code: %s", new Object[]{result.getStatus(), result.getExitCode()});
            SubprocessExceptionParser.handleStderrException(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exception prepareEnvironment(IInvocationContext context, IConfiguration config, ITestInvocationListener listener) {
        long startTime = System.currentTimeMillis();
        try {
            try {
                this.mStdoutFile = FileUtil.createTempFile("stdout_subprocess_", ".log", this.getWorkFolder());
                this.mStderrFile = FileUtil.createTempFile("stderr_subprocess_", ".log", this.getWorkFolder());
                this.mSandboxTmpFolder = FileUtil.createTempDir("tf-container", this.getWorkFolder());
            }
            catch (IOException e) {
                IOException iOException = e;
                if (!this.getSandboxOptions(config).shouldParallelSetup()) {
                    InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.DYNAMIC_FILE_RESOLVER_PAIR, startTime, System.currentTimeMillis());
                }
                return iOException;
            }
            this.mRunUtil = this.createRunUtil();
            this.mRunUtil.unsetEnvVariable("TF_GLOBAL_CONFIG");
            this.mRunUtil.unsetEnvVariable("TF_GLOBAL_CONFIG_SERVER_CONFIG");
            this.mRunUtil.unsetEnvVariable("PROTO_REPORTING_PORT");
            this.mRunUtil.unsetEnvVariable("START_FEATURE_SERVER");
            this.mRunUtil.setEnvVariable(SANDBOX_ENABLED, "true");
            if (this.getSandboxOptions(config).shouldEnableDebugThread()) {
                this.mRunUtil.setEnvVariable("debug_thread", "true");
            }
            for (Map.Entry<String, String> entry : this.getSandboxOptions(config).getEnvVariables().entrySet()) {
                this.mRunUtil.setEnvVariable(entry.getKey(), entry.getValue());
            }
            if (config.getConfigurationDescription().getMetaData("SERVER_REFERENCE") != null) {
                this.mRunUtil.setEnvVariable("SERVER_REFERENCE", config.getConfigurationDescription().getAllMetaData().getUniqueMap().get("SERVER_REFERENCE"));
            }
            try {
                this.mRootFolder = this.getTradefedSandboxEnvironment(context, config, QuotationAwareTokenizer.tokenizeLine(config.getCommandLine(), false));
            }
            catch (Exception e) {
                Exception exception = e;
                if (!this.getSandboxOptions(config).shouldParallelSetup()) {
                    InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.DYNAMIC_FILE_RESOLVER_PAIR, startTime, System.currentTimeMillis());
                }
                return exception;
            }
            PrettyPrintDelimiter.printStageDelimiter("Sandbox Configuration Preparation");
            Exception res = this.prepareConfiguration(context, config, listener);
            if (res != null) {
                Exception exception = res;
                return exception;
            }
            try (CloseableTraceScope closeableTraceScope = new CloseableTraceScope("prepareContext");){
                this.mSerializedContext = this.prepareContext(context, config);
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                if (!this.getSandboxOptions(config).shouldParallelSetup()) {
                    InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.DYNAMIC_FILE_RESOLVER_PAIR, startTime, System.currentTimeMillis());
                }
                return iOException2;
            }
        }
        finally {
            if (!this.getSandboxOptions(config).shouldParallelSetup()) {
                InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.DYNAMIC_FILE_RESOLVER_PAIR, startTime, System.currentTimeMillis());
            }
        }
        return null;
    }

    @Override
    public void tearDown() {
        StreamUtil.close(this.mEventParser);
        StreamUtil.close(this.mProtoReceiver);
        FileUtil.deleteFile(this.mStdoutFile);
        FileUtil.deleteFile(this.mStderrFile);
        FileUtil.recursiveDelete(this.mSandboxTmpFolder);
        FileUtil.deleteFile(this.mSerializedContext);
        FileUtil.deleteFile(this.mSerializedConfiguration);
        FileUtil.deleteFile(this.mGlobalConfig);
        FileUtil.deleteFile(this.mSerializedTestConfig);
    }

    @Override
    public File getTradefedSandboxEnvironment(IInvocationContext context, IConfiguration nonVersionedConfig, String[] args) throws Exception {
        SandboxOptions options = this.getSandboxOptions(nonVersionedConfig);
        if (options.getSandboxTfDirectory() != null && options.getSandboxBuildId() != null) {
            throw new ConfigurationException(String.format("Sandbox options %s and %s cannot be set at the same time", "tf-location", "sandbox-build-id"));
        }
        if (options.getSandboxTfDirectory() != null) {
            return options.getSandboxTfDirectory();
        }
        String tfDir = System.getProperty("TF_JAR_DIR");
        if (tfDir == null || tfDir.isEmpty()) {
            throw new ConfigurationException("Could not read TF_JAR_DIR to get current Tradefed instance.");
        }
        return new File(tfDir);
    }

    @Override
    public String createClasspath(File workingDir) throws ConfigurationException {
        String classpathStr = System.getProperty("java.class.path");
        if (classpathStr == null) {
            throw new ConfigurationException("Could not find the classpath property: java.class.path");
        }
        return classpathStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Exception prepareConfiguration(IInvocationContext context, IConfiguration config, ITestInvocationListener listener) {
        try {
            String commandLine = config.getCommandLine();
            if (this.getSandboxOptions(config).shouldUseProtoReporter()) {
                this.mProtoReceiver = new StreamProtoReceiver(listener, context, false, false, SANDBOX_PREFIX);
                commandLine = commandLine + " --" + "use-proto-reporter";
            } else {
                this.mEventParser = new SubprocessTestResultsParser(listener, true, context);
                commandLine = commandLine + " --no-" + "use-proto-reporter";
            }
            String[] args = QuotationAwareTokenizer.tokenizeLine(commandLine, false);
            this.mGlobalConfig = this.dumpGlobalConfig(config, new HashSet<String>());
            try (FileInputStreamSource source = new FileInputStreamSource(this.mGlobalConfig);){
                listener.testLog("sandbox-global-config", LogDataType.HARNESS_CONFIG, source);
            }
            SandboxConfigDump.DumpCmd mode = SandboxConfigDump.DumpCmd.RUN_CONFIG;
            if (config.getCommandOptions().shouldUseSandboxTestMode()) {
                mode = SandboxConfigDump.DumpCmd.TEST_MODE;
            }
            try (CloseableTraceScope ignored = new CloseableTraceScope("serialize_test_config");){
                this.mSerializedConfiguration = SandboxConfigUtil.dumpConfigForVersion(this.createClasspath(this.mRootFolder), this.mRunUtil, args, mode, this.mGlobalConfig, false);
                return null;
            }
            catch (SandboxConfigurationException e) {
                LogUtil.CLog.e(e);
                LogUtil.CLog.e("%s", args[0]);
                if (!e.getMessage().contains(String.format("Can not find local config %s", args[0]))) {
                    if (!e.getMessage().contains(String.format("Could not find configuration '%s'", args[0]))) throw e;
                }
                LogUtil.CLog.w("Child version doesn't contains '%s'. Attempting to backfill missing parent configuration.", args[0]);
                File parentConfig = this.handleChildMissingConfig(this.getSandboxOptions(config), args);
                if (parentConfig == null) throw e;
                try (FileInputStreamSource source = new FileInputStreamSource(parentConfig);){
                    listener.testLog("sandbox-parent-config", LogDataType.HARNESS_CONFIG, source);
                }
                if (this.mSerializedTestConfig != null) {
                    source = new FileInputStreamSource(this.mSerializedTestConfig);
                    try {
                        listener.testLog("sandbox-test-config", LogDataType.HARNESS_CONFIG, source);
                    }
                    finally {
                        source.close();
                    }
                }
                try {
                    this.mSerializedConfiguration = SandboxConfigUtil.dumpConfigForVersion(this.createClasspath(this.mRootFolder), this.mRunUtil, new String[]{parentConfig.getAbsolutePath()}, mode, this.mGlobalConfig, false);
                }
                finally {
                    FileUtil.deleteFile(parentConfig);
                }
                Exception exception = null;
                return exception;
            }
            finally {
                config.getCommandOptions().setBugreportOnInvocationEnded(false);
                config.getCommandOptions().setBugreportzOnInvocationEnded(false);
            }
        }
        catch (ConfigurationException | IOException e2) {
            StreamUtil.close(this.mEventParser);
            StreamUtil.close(this.mProtoReceiver);
            return e2;
        }
    }

    IRunUtil createRunUtil() {
        return new RunUtil();
    }

    protected File prepareContext(IInvocationContext context, IConfiguration config) throws IOException {
        if (config.getCommandOptions().shouldUseSandboxTestMode()) {
            try {
                Method unlock = InvocationContext.class.getDeclaredMethod("unlock", new Class[0]);
                unlock.setAccessible(true);
                unlock.invoke((Object)context, new Object[0]);
                unlock.setAccessible(false);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IOException("Couldn't unlock the context.", e);
            }
        }
        File protoFile = FileUtil.createTempFile("context-proto", "." + LogDataType.PB.getFileExt(), this.mSandboxTmpFolder);
        InvocationContext.Context contextProto = context.toProto();
        contextProto.writeDelimitedTo(new FileOutputStream(protoFile));
        return protoFile;
    }

    protected File dumpGlobalConfig(IConfiguration config, Set<String> exclusionPatterns) throws IOException, ConfigurationException {
        SandboxOptions options = this.getSandboxOptions(config);
        if (options.getChildGlobalConfig() != null) {
            IConfigurationFactory factory = ConfigurationFactory.getInstance();
            IGlobalConfiguration globalConfig = factory.createGlobalConfigurationFromArgs(new String[]{options.getChildGlobalConfig()}, new ArrayList<String>());
            LogUtil.CLog.d("Using %s directly as global config without filtering", options.getChildGlobalConfig());
            return globalConfig.cloneConfigWithFilter(new String[0]);
        }
        return SandboxConfigUtil.dumpFilteredGlobalConfig(exclusionPatterns);
    }

    @Override
    public IConfiguration createThinLauncherConfig(String[] args, IKeyStoreClient keyStoreClient, IRunUtil runUtil, File globalConfig) {
        return null;
    }

    private SandboxOptions getSandboxOptions(IConfiguration config) {
        return (SandboxOptions)config.getConfigurationObject("sandbox_options");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File handleChildMissingConfig(SandboxOptions options, String[] args) {
        IConfiguration parentConfig = null;
        File tmpParentConfig = null;
        PrintWriter pw = null;
        try {
            if (options.dumpTestTemplate()) {
                args = this.extractTestTemplate(args);
            }
            tmpParentConfig = FileUtil.createTempFile("parent-config", ".xml", this.mSandboxTmpFolder);
            pw = new PrintWriter(tmpParentConfig);
            parentConfig = ConfigurationFactory.getInstance().createConfigurationFromArgs(args);
            parentConfig.dumpXml(pw, new ArrayList<String>(), false, false);
            File file2 = tmpParentConfig;
            StreamUtil.close(pw);
            return file2;
        }
        catch (ConfigurationException | IOException e) {
            LogUtil.CLog.e("Parent doesn't understand the command either:");
            LogUtil.CLog.e(e);
            FileUtil.deleteFile(tmpParentConfig);
            File file3 = null;
            return file3;
        }
        finally {
            StreamUtil.close(pw);
        }
    }

    private String[] extractTestTemplate(String[] args) throws ConfigurationException, IOException {
        ConfigurationXmlParserSettings parserSettings = new ConfigurationXmlParserSettings();
        ArgsOptionParser templateArgParser = new ArgsOptionParser(parserSettings);
        ArrayList<String> listArgs = new ArrayList<String>(Arrays.asList(args));
        String configArg = (String)listArgs.remove(0);
        ArrayList<String> leftOverCommandLine = new ArrayList<String>();
        leftOverCommandLine.addAll(templateArgParser.parseBestEffort(listArgs, true));
        Map<String, String> uniqueTemplates = parserSettings.templateMap.getUniqueMap();
        LogUtil.CLog.d("Templates: %s", uniqueTemplates);
        if (!uniqueTemplates.containsKey("test")) {
            return args;
        }
        for (Map.Entry<String, String> template : uniqueTemplates.entrySet()) {
            if ("test".equals(template.getKey())) continue;
            leftOverCommandLine.add("--template:map");
            leftOverCommandLine.add(String.format("%s=%s", template.getKey(), template.getValue()));
        }
        this.mSerializedTestConfig = SandboxConfigUtil.dumpConfigForVersion(this.createClasspath(this.mRootFolder), this.mRunUtil, new String[]{uniqueTemplates.get("test")}, SandboxConfigDump.DumpCmd.STRICT_TEST, this.mGlobalConfig, false);
        leftOverCommandLine.add("--template:map");
        leftOverCommandLine.add("test=" + this.mSerializedTestConfig.getAbsolutePath());
        leftOverCommandLine.add(0, configArg);
        LogUtil.CLog.d("New Command line: %s", leftOverCommandLine);
        return leftOverCommandLine.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logAndCleanHeapDump(File heapDumpDir, ITestLogger logger) {
        try {
            if (heapDumpDir == null) {
                return;
            }
            if (!heapDumpDir.isDirectory()) {
                return;
            }
            if (heapDumpDir.listFiles().length == 0) {
                return;
            }
            for (File f : heapDumpDir.listFiles()) {
                FileInputStreamSource fileInput = new FileInputStreamSource(f);
                logger.testLog(f.getName(), LogDataType.HPROF, fileInput);
                StreamUtil.cancel(fileInput);
            }
        }
        finally {
            FileUtil.recursiveDelete(heapDumpDir);
        }
    }

    private File getWorkFolder() {
        return CurrentInvocation.getWorkFolder();
    }
}

