/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.sandbox;

import com.android.ddmlib.Log;
import com.android.tradefed.command.CommandRunner;
import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.device.FreeDeviceState;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NoDeviceException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.proto.InvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.SerializationUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class TradefedSandboxRunner {
    public static final String EXCEPTION_KEY = "serialized_exception";
    public static final String DEBUG_THREAD_KEY = "debug_thread";
    private ICommandScheduler mScheduler;
    private CommandRunner.ExitCode mErrorCode = CommandRunner.ExitCode.NO_ERROR;

    public CommandRunner.ExitCode getErrorCode() {
        return this.mErrorCode;
    }

    void initGlobalConfig(String[] args) throws ConfigurationException {
        GlobalConfiguration.createGlobalConfiguration(args);
    }

    ICommandScheduler getCommandScheduler() {
        return GlobalConfiguration.getInstance().getCommandScheduler();
    }

    void printStackTrace(Throwable e) {
        e.printStackTrace();
        File serializedException = null;
        try {
            serializedException = SerializationUtil.serialize(e);
            JSONObject json = new JSONObject();
            json.put(EXCEPTION_KEY, serializedException.getAbsolutePath());
            System.err.println(json.toString());
            System.err.flush();
        }
        catch (IOException | JSONException io) {
            io.printStackTrace();
            FileUtil.deleteFile(serializedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        if (System.getenv(DEBUG_THREAD_KEY) != null) {
            new DebugThread().start();
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        IInvocationContext context = null;
        if (argList.size() < 2) {
            this.mErrorCode = CommandRunner.ExitCode.THROWABLE_EXCEPTION;
            this.printStackTrace(new RuntimeException("TradefedContainerRunner expect at least 2 args."));
            return;
        }
        File contextFile = new File((String)argList.remove(0));
        try {
            InvocationContext.Context c = InvocationContext.Context.parseDelimitedFrom(new FileInputStream(contextFile));
            context = InvocationContext.fromProto(c);
        }
        catch (IOException e) {
            try {
                context = (IInvocationContext)SerializationUtil.deserialize(contextFile, false);
            }
            catch (IOException e2) {
                this.printStackTrace(e);
                this.printStackTrace(e2);
                this.mErrorCode = CommandRunner.ExitCode.THROWABLE_EXCEPTION;
                return;
            }
        }
        try {
            this.initGlobalConfig(new String[0]);
            this.mScheduler = this.getCommandScheduler();
            this.mScheduler.start();
            SignalHandler handler = new SignalHandler(){

                @Override
                public void handle(Signal sig) {
                    LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, String.format("Received signal %s. Shutting down.", sig.getName()));
                    TradefedSandboxRunner.this.mScheduler.shutdownHard(false);
                }
            };
            Signal.handle(new Signal("TERM"), handler);
            RunUtil.getDefault().sleep(2000L);
            this.mScheduler.execCommand(context, new StubScheduledInvocationListener(), argList.toArray(new String[0]));
        }
        catch (NoDeviceException e) {
            this.printStackTrace(e);
            this.mErrorCode = CommandRunner.ExitCode.NO_DEVICE_ALLOCATED;
        }
        catch (ConfigurationException e) {
            this.printStackTrace(e);
            this.mErrorCode = CommandRunner.ExitCode.CONFIG_EXCEPTION;
        }
        finally {
            this.mScheduler.shutdownOnEmpty();
        }
        try {
            this.mScheduler.join();
            if (CommandRunner.ExitCode.NO_ERROR.equals((Object)this.mErrorCode)) {
                this.mErrorCode = this.mScheduler.getLastInvocationExitCode();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.mErrorCode = CommandRunner.ExitCode.THROWABLE_EXCEPTION;
        }
        if (!CommandRunner.ExitCode.NO_ERROR.equals((Object)this.mErrorCode) && this.mScheduler.getLastInvocationThrowable() != null) {
            this.printStackTrace(this.mScheduler.getLastInvocationThrowable());
        }
    }

    public static void main(String[] mainArgs) {
        TradefedSandboxRunner console = new TradefedSandboxRunner();
        console.run(mainArgs);
        System.exit(console.getErrorCode().getCodeValue());
    }

    private void dumpStacks(PrintStream ps) {
        Map<Thread, StackTraceElement[]> threadMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> threadEntry : threadMap.entrySet()) {
            this.dumpThreadStack(threadEntry.getKey(), threadEntry.getValue(), ps);
        }
    }

    private void dumpThreadStack(Thread thread, StackTraceElement[] trace, PrintStream ps) {
        this.printLine(String.format("%s", thread), ps);
        for (int i = 0; i < trace.length; ++i) {
            this.printLine(String.format("\t%s", trace[i]), ps);
        }
        this.printLine("", ps);
    }

    private void printLine(String output, PrintStream pw) {
        pw.print(output);
        pw.println();
    }

    private void printMemoryMessage() {
        long diff = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        System.out.println(String.format("=====\nTotal: %s, Free: %s, Diff: %s\n=====", Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory(), diff));
    }

    private class DebugThread
    extends Thread {
        DebugThread() {
            this.setDaemon(true);
            this.setName("TradefedSandboxRunner-DebugThread");
        }

        @Override
        public void run() {
            System.out.println("Starting the DebugThread");
            try {
                File dumpStack = FileUtil.createTempFile("debugger-thread-stacks", ".txt");
                while (true) {
                    RunUtil.getDefault().sleep(300000L);
                    try (PrintStream ps = new PrintStream(dumpStack);){
                        TradefedSandboxRunner.this.dumpStacks(ps);
                    }
                    TradefedSandboxRunner.this.printMemoryMessage();
                }
            }
            catch (IOException e) {
                System.err.println(e);
                return;
            }
        }
    }

    public static class StubScheduledInvocationListener
    implements ICommandScheduler.IScheduledInvocationListener {
        @Override
        public void invocationComplete(IInvocationContext metadata, Map<ITestDevice, FreeDeviceState> devicesStates) {
        }
    }
}

