/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.service;

import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.service.TradefedFeatureServer;
import com.android.tradefed.util.StreamUtil;
import com.proto.tradefed.feature.ErrorInfo;
import com.proto.tradefed.feature.FeatureRequest;
import com.proto.tradefed.feature.FeatureResponse;
import com.proto.tradefed.feature.TradefedInformationGrpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import java.util.Map;

public class TradefedFeatureClient
implements AutoCloseable {
    private static final int MAX_MESSAGE_SIZE_BYTES = 0x2000000;
    private TradefedInformationGrpc.TradefedInformationBlockingStub mBlockingStub;
    private ManagedChannel mChannel = ((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forAddress("localhost", TradefedFeatureServer.getPort()).usePlaintext()).maxInboundMessageSize(0x2000000)).build();

    public TradefedFeatureClient() {
        this.mBlockingStub = TradefedInformationGrpc.newBlockingStub(this.mChannel);
    }

    public FeatureResponse triggerFeature(String featureName, Map<String, String> args) {
        return this.triggerFeature(featureName, System.getenv("SERVER_REFERENCE"), args);
    }

    private FeatureResponse triggerFeature(String featureName, String invocationReference, Map<String, String> args) {
        FeatureResponse response;
        try (CloseableTraceScope ignore = new CloseableTraceScope("triggerFeature:" + featureName);){
            LogUtil.CLog.d("invoking feature '%s'", featureName);
            FeatureRequest.Builder request = FeatureRequest.newBuilder().setName(featureName).putAllArgs(args);
            if (invocationReference != null) {
                request.setReferenceId(invocationReference);
            } else if (InvocationMetricLogger.getInvocationMetrics().containsKey(InvocationMetricLogger.InvocationMetricKey.SERVER_REFERENCE.toString())) {
                LogUtil.CLog.d("Using reference id from metrics.");
                request.setReferenceId(InvocationMetricLogger.getInvocationMetrics().get(InvocationMetricLogger.InvocationMetricKey.SERVER_REFERENCE.toString()));
            } else {
                LogUtil.CLog.w("Reference id is null.");
            }
            LogUtil.CLog.d("%s", request);
            response = this.mBlockingStub.triggerFeature(request.build());
        }
        catch (StatusRuntimeException e) {
            response = FeatureResponse.newBuilder().setErrorInfo(ErrorInfo.newBuilder().setErrorTrace(StreamUtil.getStackTrace(e)).build()).build();
        }
        String message2 = String.format("Feature name: %s. response: %s", featureName, response);
        if (response.hasErrorInfo()) {
            StringBuilder callsite = new StringBuilder();
            for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                callsite.append(e.toString());
            }
            message2 = message2 + String.format(". Callsite: %s", callsite);
            LogUtil.CLog.w(message2);
        } else {
            LogUtil.CLog.d(message2);
        }
        return response;
    }

    @Override
    public void close() {
        if (this.mChannel != null) {
            this.mChannel.shutdown();
        }
    }
}

