/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.service;

import com.android.tradefed.command.ICommandScheduler;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.service.IRemoteFeature;
import com.android.tradefed.service.internal.IRemoteScheduledListenersFeature;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.util.StreamUtil;
import com.proto.tradefed.feature.ErrorInfo;
import com.proto.tradefed.feature.FeatureRequest;
import com.proto.tradefed.feature.FeatureResponse;
import com.proto.tradefed.feature.TradefedInformationGrpc;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;

public class TradefedFeatureServer
extends TradefedInformationGrpc.TradefedInformationImplBase {
    public static final String SERVER_REFERENCE = "SERVER_REFERENCE";
    public static final String TEST_INFORMATION_OBJECT = "TEST_INFORMATION";
    public static final String TF_SERVICE_PORT = "TF_SERVICE_PORT";
    private static final int DEFAULT_PORT = 8889;
    private Server mServer;
    private Map<String, IConfiguration> mRegisteredInvocation = new HashMap<String, IConfiguration>();
    private Map<String, ThreadGroup> mRegisteredGroup = new HashMap<String, ThreadGroup>();
    private Map<String, List<ICommandScheduler.IScheduledInvocationListener>> mRegisteredScheduledInvocationListeners = new HashMap<String, List<ICommandScheduler.IScheduledInvocationListener>>();

    public static int getPort() {
        return System.getenv(TF_SERVICE_PORT) != null ? Integer.parseInt(System.getenv(TF_SERVICE_PORT)) : 8889;
    }

    public TradefedFeatureServer() {
        this(ServerBuilder.forPort(TradefedFeatureServer.getPort()));
    }

    TradefedFeatureServer(ServerBuilder<?> serverBuilder) {
        this.mServer = ((ServerBuilder)serverBuilder.addService(this)).build();
    }

    public void start() {
        try {
            LogUtil.CLog.d("Starting feature server.");
            this.mServer.start();
        }
        catch (IOException e) {
            LogUtil.CLog.w("TradefedFeatureServer already started: %s", e.getMessage());
        }
    }

    public void shutdown() throws InterruptedException {
        if (this.mServer != null) {
            LogUtil.CLog.d("Stopping feature server.");
            this.mServer.shutdown();
            this.mServer.awaitTermination();
        }
    }

    @Override
    public void triggerFeature(FeatureRequest request, StreamObserver<FeatureResponse> responseObserver) {
        FeatureResponse response;
        try {
            response = this.createResponse(request);
        }
        catch (RuntimeException exception) {
            response = FeatureResponse.newBuilder().setErrorInfo(ErrorInfo.newBuilder().setErrorTrace(StreamUtil.getStackTrace(exception))).build();
        }
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    public String registerInvocation(IConfiguration config, ThreadGroup tg, List<ICommandScheduler.IScheduledInvocationListener> listeners) {
        String referenceId = UUID.randomUUID().toString();
        this.mRegisteredInvocation.put(referenceId, config);
        this.mRegisteredGroup.put(referenceId, tg);
        this.mRegisteredScheduledInvocationListeners.put(referenceId, listeners);
        config.getConfigurationDescription().addMetadata(SERVER_REFERENCE, referenceId);
        return referenceId;
    }

    public void unregisterInvocation(IConfiguration reference) {
        String referenceId = reference.getConfigurationDescription().getAllMetaData().getUniqueMap().get(SERVER_REFERENCE);
        this.mRegisteredInvocation.remove(referenceId);
        this.mRegisteredGroup.remove(referenceId);
        this.mRegisteredScheduledInvocationListeners.remove(referenceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureResponse createResponse(FeatureRequest request) {
        ServiceLoader<IRemoteFeature> serviceLoader = ServiceLoader.load(IRemoteFeature.class);
        for (IRemoteFeature feature : serviceLoader) {
            List<ICommandScheduler.IScheduledInvocationListener> listeners;
            if (!feature.getName().equals(request.getName())) continue;
            InvocationMetricLogger.setLocalGroup(this.mRegisteredGroup.get(request.getReferenceId()));
            if (feature instanceof IConfigurationReceiver) {
                ((IConfigurationReceiver)((Object)feature)).setConfiguration(this.mRegisteredInvocation.get(request.getReferenceId()));
            }
            if (feature instanceof ITestInformationReceiver && this.mRegisteredInvocation.get(request.getReferenceId()) != null) {
                ((ITestInformationReceiver)((Object)feature)).setTestInformation((TestInformation)this.mRegisteredInvocation.get(request.getReferenceId()).getConfigurationObject(TEST_INFORMATION_OBJECT));
            }
            if (feature instanceof IRemoteScheduledListenersFeature && (listeners = this.mRegisteredScheduledInvocationListeners.get(request.getReferenceId())) != null) {
                ((IRemoteScheduledListenersFeature)feature).setListeners(listeners);
            }
            try {
                FeatureResponse rep = feature.execute(request);
                if (rep == null) {
                    FeatureResponse featureResponse = FeatureResponse.newBuilder().setErrorInfo(ErrorInfo.newBuilder().setErrorTrace(String.format("Feature '%s' returned null response.", request.getName()))).build();
                    return featureResponse;
                }
                FeatureResponse featureResponse = rep;
                return featureResponse;
            }
            finally {
                if (feature instanceof IConfigurationReceiver) {
                    ((IConfigurationReceiver)((Object)feature)).setConfiguration(null);
                }
                InvocationMetricLogger.resetLocalGroup();
            }
        }
        return FeatureResponse.newBuilder().setErrorInfo(ErrorInfo.newBuilder().setErrorTrace(String.format("No feature matching the requested one '%s'", request.getName()))).build();
    }
}

